#!/bin/ksh

# **************************************************************************
# *
# * File:  ProductCatalogSampleData.sh
# *
# * This file is for populating the tables for the ProductCataloge AC
# *
# * Updated: November 30th, 2000
# *
# **************************************************************************

USAGE="\nUsage: ProductCatalogSampleData.sh database [userid password] [qualifier]"
qualifier=$1

function ErrorMessage
{
  print "$USEAGE"
}

function DirectConnectWithCurrentUserid
{
  db2 connect to $1
  qualifier=$USER
  PopulateTables
}

function DirectConnectWithQualifier1
{
  db2 connect to $1
  qualifier=$2
  PopulateTables
}

function ConnectWithParWithUserid
{
  db2 connect to $1 user $2 using $3
  qualifier=$2
  PopulateTables
}

function ConnectWithParWithQualifier2
{
  db2 connect to $1 user $2 using $3
  qualifier=$4
  PopulateTables
}

function PopulateTables
{
  db2 delete from $qualifier.cat_cp_link
  db2 delete from $qualifier.cat_pr_link
  db2 delete from $qualifier.categorylocale
  db2 delete from $qualifier.category
  db2 delete from $qualifier.compointdatalocale
  db2 delete from $qualifier.compointdata
  db2 delete from $qualifier.compointlocale
  db2 delete from $qualifier.compoint
  db2 delete from $qualifier.productlocale
  db2 delete from $qualifier.product
  db2 delete from $qualifier.dyna_text

  print " ***************ADDING PRODUCTS**********************************"
  print " * Insert must occur in pairs.  One for the main table and one for the locale table with same productID."
  print " ****************************************************************"

  print " * add Regular Credit Card Product"
  db2 insert into $qualifier.product "($qualifier.product.productID, $qualifier.product.displaytopublic,$qualifier.product.shippingcode,$qualifier.product.availabilitydate, $qualifier.product.mainsynchkey) values ('1111','true','90',date('2000-08-16'),timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.productlocale "($qualifier.productlocale.id,$qualifier.productlocale.synchkey,$qualifier.productlocale.productid,$qualifier.productlocale.name, $qualifier.productlocale.locale,$qualifier.productlocale.description,$qualifier.productlocale.slideurl,$qualifier.productlocale.relatedinfourl, $qualifier.productlocale.fullsizeimage, $qualifier.productlocale.orderunitsofmeas ) values	(timestamp('2011-08-16-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'1111', 'Regular Credit Card', 'en_US','Regular Credit Card Product','http:/www.slideurl.com','http:/www.relatedurl.com','some image file','1234567')"

  print " * add Gold Credit Card Product"
  db2 insert into $qualifier.product "($qualifier.product.productID, $qualifier.product.displaytopublic,$qualifier.product.shippingcode,$qualifier.product.availabilitydate,$qualifier.product.mainsynchkey) values ('2222','true','90',date('2000-08-16'),timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.productlocale "($qualifier.productlocale.id,$qualifier.productlocale.synchkey,$qualifier.productlocale.productid,$qualifier.productlocale.name, $qualifier.productlocale.locale,$qualifier.productlocale.description,$qualifier.productlocale.slideurl, $qualifier.productlocale.relatedinfourl, $qualifier.productlocale.fullsizeimage, $qualifier.productlocale.orderunitsofmeas ) values (timestamp('2022-09-16-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'2222', 'Gold Credit Card', 'en_US','Gold Credit Card Product','http:/www.slideurl.com','http:/www.relatedurl.com','some image file','1234567')"

  print " * add Platinum Credit Card Product"
  db2 insert into $qualifier.product "($qualifier.product.productID, $qualifier.product.displaytopublic,$qualifier.product.shippingcode,$qualifier.product.availabilitydate,$qualifier.product.mainsynchkey) values ('3333','true','90',date('2000-08-16'),timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.productlocale "($qualifier.productlocale.id,$qualifier.productlocale.synchkey,$qualifier.productlocale.productid,$qualifier.productlocale.name, $qualifier.productlocale.locale,$qualifier.productlocale.description,$qualifier.productlocale.slideurl, $qualifier.productlocale.relatedinfourl, $qualifier.productlocale.fullsizeimage, $qualifier.productlocale.orderunitsofmeas ) values (timestamp('2033-09-17-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'3333', 'Platinum Credit Card', 'en_US','Platinum Credit Card Product','http:/www.slideurl.com','http:/www.relatedurl.com','some image file','1234567')"

  print " * add Balanced Fund Product"
  db2 insert into $qualifier.product "($qualifier.product.productID, $qualifier.product.displaytopublic,$qualifier.product.shippingcode,$qualifier.product.availabilitydate,$qualifier.product.mainsynchkey) values ('4444','true','90',date('2000-08-16'),timestamp('2000-08-19-08.15.40.000000'))"
  db2 insert into $qualifier.productlocale "($qualifier.productlocale.id,$qualifier.productlocale.synchkey,$qualifier.productlocale.productid,$qualifier.productlocale.name, $qualifier.productlocale.locale,$qualifier.productlocale.description,$qualifier.productlocale.slideurl, $qualifier.productlocale.relatedinfourl, $qualifier.productlocale.fullsizeimage, $qualifier.productlocale.orderunitsofmeas ) values (timestamp('2044-11-20-11.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'4444', 'Balanced Fund', 'en_US','Balanced Fund Product','http:/www.slideurl.com','http:/www.relatedurl.com','some image file','1234567')"

  print " * add Technology Fund Product"
  db2 insert into $qualifier.product "($qualifier.product.productID, $qualifier.product.displaytopublic,$qualifier.product.shippingcode,$qualifier.product.availabilitydate,$qualifier.product.mainsynchkey) values ('5555','true','90',date('2000-08-16'),timestamp('2000-08-19-08.15.40.000000'))"
  db2 insert into $qualifier.productlocale "($qualifier.productlocale.id,$qualifier.productlocale.synchkey,$qualifier.productlocale.productid,$qualifier.productlocale.name, $qualifier.productlocale.locale,$qualifier.productlocale.description,$qualifier.productlocale.slideurl, $qualifier.productlocale.relatedinfourl, $qualifier.productlocale.fullsizeimage, $qualifier.productlocale.orderunitsofmeas ) values (timestamp('2055-11-20-11.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'5555', 'Technology Fund', 'en_US', 'Technology Fund Product','http:/www.slideurl.com','http:/www.relatedurl.com','some image file','1234567')"

  print " *************ADDING CATEGORIES***********************************"
  print " * Insert must occur in pairs.  One for the main table and one for the locale table with same productcategoryID."
  print " *****************************************************************"

  print " * add Credit Cards category"
  db2 insert into $qualifier.category "($qualifier.category.productcategoryID, $qualifier.category.hassubcategories,$qualifier.category.hasproducts,$qualifier.category.parentcategoryid, $qualifier.category.maintenanceflag, $qualifier.category.mainsynchkey, $qualifier.category.sequence) values ('1111','false', 'true', null, null, timestamp('2000-08-16-08.15.40.000000'), float(1.0))"
  db2 insert into $qualifier.categorylocale "($qualifier.categorylocale.id,$qualifier.categorylocale.synchkey,$qualifier.categorylocale.productcategoryid,$qualifier.categorylocale.name, $qualifier.categorylocale.locale) values	(timestamp('2000-08-16-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'1111', 'Credit Cards', 'en_US')"

  print " * add Mutual Funds Category"
  db2 insert into $qualifier.category "($qualifier.category.productcategoryID, $qualifier.category.hassubcategories,$qualifier.category.hasproducts,$qualifier.category.parentcategoryid, $qualifier.category.maintenanceflag, $qualifier.category.mainsynchkey,$qualifier.category.sequence) values ('2222','false', 'false', null, null, timestamp('2000-08-16-08.15.40.000000'), float(2.0))"
  db2 insert into $qualifier.categorylocale "($qualifier.categorylocale.id,$qualifier.categorylocale.synchkey,$qualifier.categorylocale.productcategoryid,$qualifier.categorylocale.name, $qualifier.categorylocale.locale) values (timestamp('2000-09-16-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'2222', 'Mutual Funds', 'en_US')"

  print " * add RRSP Category"
  db2 insert into $qualifier.category "($qualifier.category.productcategoryID, $qualifier.category.hassubcategories,$qualifier.category.hasproducts,$qualifier.category.parentcategoryid, $qualifier.category.maintenanceflag, $qualifier.category.mainsynchkey, $qualifier.category.sequence) values ('3333','false','false', null, null, timestamp('2000-08-16-08.15.40.000000'), float(3.0))"
  db2 insert into $qualifier.categorylocale "($qualifier.categorylocale.id,$qualifier.categorylocale.synchkey,$qualifier.categorylocale.productcategoryid,$qualifier.categorylocale.name, $qualifier.categorylocale.locale) values (timestamp('2000-09-17-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'3333', 'RRSPs', 'en_US')"

  print " *************ADDING COMPARISON POINTS****************************"
  print " * Insert must occur in pairs.  One for the main table and one for the locale table with same comparisonPointID."
  print " *****************************************************************"

  print " * add Interest Rate Comparison Point"
  db2 insert into $qualifier.compoint "($qualifier.compoint.comparisonpointID, $qualifier.compoint.maintenanceflag, $qualifier.compoint.mainsynchkey) values ('1111',null, timestamp('2000-08-12-08.15.40.000000'))"
  db2 insert into $qualifier.compointlocale "($qualifier.compointlocale.id,$qualifier.compointlocale.synchkey,$qualifier.compointlocale.comparisonpointid,$qualifier.compointlocale.name, $qualifier.compointlocale.locale, $qualifier.compointlocale.description) values	(timestamp('2011-08-12-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'1111', 'Interest Rate', 'en_US', 'Interest rate comparison point')"

  print " * add Credit Card Limit Comparison Point"
  db2 insert into $qualifier.compoint "($qualifier.compoint.comparisonpointID, $qualifier.compoint.maintenanceflag, $qualifier.compoint.mainsynchkey) values ('2222',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointlocale "($qualifier.compointlocale.id,$qualifier.compointlocale.synchkey,$qualifier.compointlocale.comparisonpointid,$qualifier.compointlocale.name, $qualifier.compointlocale.locale, $qualifier.compointlocale.description) values (timestamp('2022-09-16-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'2222', 'Credit Card Limit', 'en_US', 'Credit card limit comparison point')"

  print " * add Historical Rate of Return Comparison Point"
  db2 insert into $qualifier.compoint "($qualifier.compoint.comparisonpointID, $qualifier.compoint.maintenanceflag, $qualifier.compoint.mainsynchkey) values ('3333',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointlocale "($qualifier.compointlocale.id,$qualifier.compointlocale.synchkey,$qualifier.compointlocale.comparisonpointid,$qualifier.compointlocale.name, $qualifier.compointlocale.locale, $qualifier.compointlocale.description) values (timestamp('2033-09-17-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'3333', 'Historical Rate of Return', 'en_US', 'Historical rate of return comparison point')"

  print " * add Risk Comparison Point"
  db2 insert into $qualifier.compoint "($qualifier.compoint.comparisonpointID, $qualifier.compoint.maintenanceflag, $qualifier.compoint.mainsynchkey) values ('4444',null, timestamp('2000-09-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointlocale "($qualifier.compointlocale.id,$qualifier.compointlocale.synchkey,$qualifier.compointlocale.comparisonpointid,$qualifier.compointlocale.name, $qualifier.compointlocale.locale, $qualifier.compointlocale.description) values (timestamp('2044-11-17-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'4444', 'Risk', 'en_US', 'Risk comparison point')"

  print " *************ADDING COMPARISON POINT DATA************************"
  print " * Insert must occur in pairs.  One for the main table and one for the locale table with same cpdataID."
  print " *****************************************************************"

  print " * add Regular Credit Card Product X Interest Rate Comparison Point CPD"
  db2 insert into $qualifier.compointdata "($qualifier.compointdata.cpdataID, $qualifier.compointdata.comparisonpointID,$qualifier.compointdata.productID, $qualifier.compointdata.maintenanceflag, $qualifier.compointdata.mainsynchkey) values ('1111','1111','1111',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointdatalocale "($qualifier.compointdatalocale.id,$qualifier.compointdatalocale.synchkey,$qualifier.compointdatalocale.cpdataid,$qualifier.compointdatalocale.shortDescription, $qualifier.compointdatalocale.longDescription, $qualifier.compointdatalocale.locale, $qualifier.compointdatalocale.longSameAsShort) values (timestamp('2000-11-17-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'1111', '', 'The interest rate for this card is 9 percent', 'en_US','true')"

  print " * add Gold Credit Credit Card Product X Interest Rate Comparison Point CPD"
  db2 insert into $qualifier.compointdata "($qualifier.compointdata.cpdataID, $qualifier.compointdata.comparisonpointID,$qualifier.compointdata.productID, $qualifier.compointdata.maintenanceflag, $qualifier.compointdata.mainsynchkey) values ('2222','1111','2222',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointdatalocale "($qualifier.compointdatalocale.id,$qualifier.compointdatalocale.synchkey,$qualifier.compointdatalocale.cpdataid,$qualifier.compointdatalocale.shortDescription, $qualifier.compointdatalocale.longDescription, $qualifier.compointdatalocale.locale, $qualifier.compointdatalocale.longSameAsShort) values (timestamp('2022-11-20-08.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'2222', '', 'The interest rate for this card is 16 percent', 'en_US','true')"

  print " * add Platinum Credit Credit Card Product X Interest Rate Comparison Point CPD"
  db2 insert into $qualifier.compointdata "($qualifier.compointdata.cpdataID, $qualifier.compointdata.comparisonpointID,$qualifier.compointdata.productID, $qualifier.compointdata.maintenanceflag, $qualifier.compointdata.mainsynchkey) values ('3333','1111','3333',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointdatalocale "($qualifier.compointdatalocale.id,$qualifier.compointdatalocale.synchkey,$qualifier.compointdatalocale.cpdataid,$qualifier.compointdatalocale.shortDescription, $qualifier.compointdatalocale.longDescription, $qualifier.compointdatalocale.locale, $qualifier.compointdatalocale.longSameAsShort) values (timestamp('2033-11-20-11.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'3333', '','The interest rate for this card is 28 percent','en_US','true')"

  print " * add Regular Credit Card Product X Credit Card Limit Comparison Point CPD"
  db2 insert into $qualifier.compointdata "($qualifier.compointdata.cpdataID, $qualifier.compointdata.comparisonpointID,$qualifier.compointdata.productID, $qualifier.compointdata.maintenanceflag, $qualifier.compointdata.mainsynchkey) values ('4444','2222','1111',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointdatalocale "($qualifier.compointdatalocale.id,$qualifier.compointdatalocale.synchkey,$qualifier.compointdatalocale.cpdataid,$qualifier.compointdatalocale.shortDescription, $qualifier.compointdatalocale.longDescription, $qualifier.compointdatalocale.locale, $qualifier.compointdatalocale.longSameAsShort) values (timestamp('2044-11-20-11.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'4444','', 'The credit limit for this card is $2000', 'en_US','true')"

  print " * add Gold Credit Card Product X Credit Card Limit Comparison Point CPD"
  db2 insert into $qualifier.compointdata "($qualifier.compointdata.cpdataID, $qualifier.compointdata.comparisonpointID,$qualifier.compointdata.productID, $qualifier.compointdata.maintenanceflag, $qualifier.compointdata.mainsynchkey) values ('5555','2222','2222',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointdatalocale "($qualifier.compointdatalocale.id,$qualifier.compointdatalocale.synchkey,$qualifier.compointdatalocale.cpdataid,$qualifier.compointdatalocale.shortDescription, $qualifier.compointdatalocale.longDescription, $qualifier.compointdatalocale.locale, $qualifier.compointdatalocale.longSameAsShort) values (timestamp('2055-11-20-11.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'5555', '','The credit limit for this card is $10000', 'en_US','true')"

  print " * add Platinum Credit Card Product X Credit Card Limit Comparison Point CPD"
  db2 insert into $qualifier.compointdata "($qualifier.compointdata.cpdataID, $qualifier.compointdata.comparisonpointID,$qualifier.compointdata.productID, $qualifier.compointdata.maintenanceflag, $qualifier.compointdata.mainsynchkey) values ('6666','2222','3333',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointdatalocale "($qualifier.compointdatalocale.id,$qualifier.compointdatalocale.synchkey,$qualifier.compointdatalocale.cpdataid,$qualifier.compointdatalocale.shortDescription, $qualifier.compointdatalocale.longDescription, $qualifier.compointdatalocale.locale, $qualifier.compointdatalocale.longSameAsShort) values (timestamp('2066-11-20-11.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'6666', '','The credit limit for this card is $50000','en_US','true')"

  print " * add Balanced Fund Product X Historical Rate of Return Comparison Point CPD"
  db2 insert into $qualifier.compointdata "($qualifier.compointdata.cpdataID, $qualifier.compointdata.comparisonpointID,$qualifier.compointdata.productID, $qualifier.compointdata.maintenanceflag, $qualifier.compointdata.mainsynchkey) values ('7777','3333','4444',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointdatalocale "($qualifier.compointdatalocale.id,$qualifier.compointdatalocale.synchkey,$qualifier.compointdatalocale.cpdataid,$qualifier.compointdatalocale.shortDescription, $qualifier.compointdatalocale.longDescription, $qualifier.compointdatalocale.locale, $qualifier.compointdatalocale.longSameAsShort) values (timestamp('2077-11-20-11.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'7777', '','The Historical Rate of Return is {Rate}','en_US','true')"

  print " * add Balanced Fund Product X Historical Rate of Return Comparison Point CPD"
  db2 insert into $qualifier.compointdata "($qualifier.compointdata.cpdataID, $qualifier.compointdata.comparisonpointID,$qualifier.compointdata.productID, $qualifier.compointdata.maintenanceflag, $qualifier.compointdata.mainsynchkey) values ('8888','3333','5555',null, timestamp('2000-08-16-08.15.40.000000'))"
  db2 insert into $qualifier.compointdatalocale "($qualifier.compointdatalocale.id,$qualifier.compointdatalocale.synchkey,$qualifier.compointdatalocale.cpdataid,$qualifier.compointdatalocale.shortDescription, $qualifier.compointdatalocale.longDescription, $qualifier.compointdatalocale.locale, $qualifier.compointdatalocale.longSameAsShort) values (timestamp('2088-11-20-11.15.40.000000'), timestamp('2000-08-16-08.15.40.000000'),'8888', '','The Historical Rate of Return is 15 percent','en_US','true')"

  print " *************ADDING CATEGORY-PRODUCT LINKS************************"
  print " * CATEGORY AND PRODUCT MUST EXIST IN TABLES"
  print " *****************************************************************"

  print " * add Credit Cards Category X Regular Credit Card Product"
  db2 insert into $qualifier.cat_pr_link "($qualifier.cat_pr_link.productcategoryID, $qualifier.cat_pr_link.productID,$qualifier.cat_pr_link.ID, $qualifier.cat_pr_link.sequence) values ('1111','1111',timestamp('2000-08-16-08.15.40.000000'), float(1.0))"
  print " * add Credit Cards Category X Gold Credit Card Product"
  db2 insert into $qualifier.cat_pr_link "($qualifier.cat_pr_link.productcategoryID, $qualifier.cat_pr_link.productID,$qualifier.cat_pr_link.ID, $qualifier.cat_pr_link.sequence) values ('1111','2222',timestamp('2000-08-17-08.15.40.000000'), float(2.0))"
  print " * add Credit Cards Category X Platinum Credit Card Product"
  db2 insert into $qualifier.cat_pr_link "($qualifier.cat_pr_link.productcategoryID, $qualifier.cat_pr_link.productID,$qualifier.cat_pr_link.ID, $qualifier.cat_pr_link.sequence) values ('1111','3333',timestamp('2000-08-18-08.15.40.000000'), float(3.0))"
  print " * add Mutual Funds Category X Balanced Fund Product"
  db2 insert into $qualifier.cat_pr_link "($qualifier.cat_pr_link.productcategoryID, $qualifier.cat_pr_link.productID,$qualifier.cat_pr_link.ID, $qualifier.cat_pr_link.sequence) values ('2222','4444',timestamp('2000-08-19-08.15.40.000000'), float(1.0))"
  print " * add Mutual Funds Category X Technology Fund Product"
  db2 insert into $qualifier.cat_pr_link "($qualifier.cat_pr_link.productcategoryID, $qualifier.cat_pr_link.productID,$qualifier.cat_pr_link.ID, $qualifier.cat_pr_link.sequence) values ('2222','5555',timestamp('2000-08-20-08.15.40.000000'), float(2.0))"

  print " *************ADDING CATEGORY-COMPARISON POINT LINKS**************"
  print " * CATEGORY AND COMPARISON POINT MUST EXIST IN TABLES"
  print " *****************************************************************"

  print " * add Credit Cards Category X Interest Rate Comparison Point"
  db2 insert into $qualifier.cat_cp_link "($qualifier.cat_cp_link.productcategoryID, $qualifier.cat_cp_link.comparisonpointID,$qualifier.cat_cp_link.ID, $qualifier.cat_cp_link.sequence) values ('1111','1111',timestamp('2000-08-16-08.15.40.000000'), float(1.0))"
  print " * add Credit Cards Category X Credit Card Limit Comparison Point"
  db2 insert into $qualifier.cat_cp_link "($qualifier.cat_cp_link.productcategoryID, $qualifier.cat_cp_link.comparisonpointID,$qualifier.cat_cp_link.ID, $qualifier.cat_cp_link.sequence) values ('1111','2222',timestamp('2000-08-17-08.15.40.000000'), float(2.0))"
  print " * add Mutual Funds Category X Historical Rate of Returns Comparison Point"
  db2 insert into $qualifier.cat_cp_link "($qualifier.cat_cp_link.productcategoryID, $qualifier.cat_cp_link.comparisonpointID,$qualifier.cat_cp_link.ID, $qualifier.cat_cp_link.sequence) values ('2222','3333',timestamp('2000-08-18-08.15.40.000000'), float(1.0))"
  print " * add Mutual Funds Category X Term Locked In Comparison Point"
  db2 insert into $qualifier.cat_cp_link "($qualifier.cat_cp_link.productcategoryID, $qualifier.cat_cp_link.comparisonpointID,$qualifier.cat_cp_link.ID, $qualifier.cat_cp_link.sequence) values ('2222','4444',timestamp('2000-08-19-08.15.40.000000'), float(2.0))"
  print " * add to dynamic text table"
  db2 insert into $qualifier.Dyna_Text"(ID,Tag,Locale,Value) VALUES('7676','Fee','en_US','$10.50')"
  db2 insert into $qualifier.Dyna_Text"(ID,Tag,Locale,Value) VALUES('7878','Charge','en_US','$100')"
  db2 insert into $qualifier.Dyna_Text"(ID,Tag,Locale,Value) VALUES('7979','Cost','en_US','$90.50')"
  db2 insert into $qualifier.Dyna_Text"(ID,Tag,Locale,Value) VALUES('8080','Rate','en_US','14 percent')"
} #End of PopulateTables

# *
# * Following block is for connecting to database and setting qualifier depending 
# * on number of parameters.
# *

if [[ $# = 0 ]]
then ErrorMessage
elif [[ $# = 1 ]]
then DirectConnectWithCurrentUserid $1
elif [[ $# = 2 ]]
then DirectConnectWithQualifier1 $1 $2
elif [[ $# = 3 ]]
then ConnectWithParWithUserid $1 $2 $3
elif [[ $# = 4 ]]
then ConnectWithParWithQualifier2 $1 $2 $3 $4
elif [[ $# > 4 ]]
then ErrorMessage
fi

db2 grant connect on database to public
db2 connect reset