-- Create the database (if nessessary)
CREATE DATABASE BTF

-- Connect to the security database
CONNECT TO BTF

-- Create the user table
CREATE TABLE BTF.USERS ("USERID" CHAR(25) NOT NULL,"XID" CHAR(10) NOT NULL,"PASSWORD" CHAR(120),"RIGHTS" VARCHAR(700),"ROLES" VARCHAR(700),"RIGHT_TIMES" VARCHAR(700),"ROLE_TIMES" VARCHAR(700),"ACTIVATION" CHAR(20),"DURATION" CHAR(20),"LOCK" CHAR,"TIMELOCK" CHAR,"DATA" VARCHAR(700)) IN "USERSPACE1"

-- Create the rights table
CREATE TABLE BTF.RIGHTS ("RIGHT_NAME" CHAR(50) NOT NULL,"XID" CHAR(10) NOT NULL,"DATA" VARCHAR(700)) IN "USERSPACE1"

-- Create the roles table
CREATE TABLE BTF.ROLES ("ROLE" CHAR(50) NOT NULL,"XID" CHAR(10) NOT NULL,"HANDLER" CHAR(100),"RIGHTS" VARCHAR(700),"ROLES" VARCHAR(700),"DATA" VARCHAR(700)) IN "USERSPACE1"

-- Create the services table
CREATE TABLE BTF.SERVICES ("SERVICE" CHAR(50) NOT NULL,"XID" CHAR(10) NOT NULL,"RIGHTS" VARCHAR(700),"DATA" VARCHAR(700)) IN "USERSPACE1"

-- Create the groups table
CREATE TABLE BTF.GROUPS ("GROUP" CHAR(50) NOT NULL,"XID" CHAR(10) NOT NULL,"USERS" VARCHAR(700),"GROUPS" VARCHAR(700),"DATA" VARCHAR(700)) IN "USERSPACE1"

-- Create the contexts table
CREATE TABLE BTF.CONTEXTS ("CONTEXT" CHAR(12) NOT NULL,"XID" CHAR(10) NOT NULL,"USERID" CHAR(10),"OVERRIDE" CHAR(10),"ACTIVE" CHAR,"FORCEDSIGNOFF" CHAR,"DATA" VARCHAR(700)) IN "USERSPACE1"

-- Create the configuration table
CREATE TABLE BTF.CONFIGURATION ("XID" CHAR(10) NOT NULL,"USRP" CHAR,"CTXP" CHAR,"RGTP" CHAR,"ROLP" CHAR,"SRVP" CHAR,"GRPP" CHAR,"CFGP" CHAR,"AUDIT" CHAR,"QPASSWORD" CHAR,"UNIQUE" CHAR,"ROLES" VARCHAR(700)) IN "USERSPACE1"

-- Assign the primary keys
ALTER TABLE BTF.USERS         ADD PRIMARY KEY ("USERID"  , "XID")
ALTER TABLE BTF.RIGHTS        ADD PRIMARY KEY ("RIGHT_NAME"   , "XID")
ALTER TABLE BTF.ROLES         ADD PRIMARY KEY ("ROLE"    , "XID")
ALTER TABLE BTF.SERVICES      ADD PRIMARY KEY ("SERVICE" , "XID")
ALTER TABLE BTF.GROUPS        ADD PRIMARY KEY ("GROUP"   , "XID")
ALTER TABLE BTF.CONTEXTS      ADD PRIMARY KEY ("CONTEXT" , "XID")
ALTER TABLE BTF.CONFIGURATION ADD PRIMARY KEY ("XID")
