################################################################
#
# File: createElectronicJournalTables.sh
#
# Usage: createElectronicJournalTables.sh userid password
#
# This script creates a database BTF and all tables for the
# Electronic Journal on AIX platform.
#
################################################################

echo

if [ $# -ne 2 ]; then
 echo "Usage: createElectronicJournalTables.sh userid password"
 exit 1
fi

#
# Create database BTF
#
echo 'Creating database BTF for Electronic Journal'

db2 "CREATE database BTF"

#
# Create tables 
#

echo 'Creating tables for Electronic Journal'

db2 "CONNECT TO BTF user $1 using $2"

db2 "CREATE TABLE EJDATA.DSEJOUCT ( ENTITY_NAME VARCHAR(20) NOT NULL PRIMARY KEY, WRAP_N INTEGER NOT NULL, LAST_DATE DATE )"

db2 "INSERT INTO EJDATA.DSEJOUCT VALUES('DSEJOU', 1, null)"

db2 "INSERT INTO EJDATA.DSEJOUCT VALUES('EJTABLE', 1, null)"

db2 "CREATE TABLE EJDATA.EJTABLE_1 (DSERECN INTEGER NOT NULL PRIMARY KEY, OPCODE CHAR(30), SESSIONID CHAR(30), USERID CHAR(10), CUSTOMERID CHAR(10), ACCOUNTID CHAR(30), ACCOUNTCURR CHAR(3), AMOUNT DECIMAL(31,0), CURRENCY CHAR(3), CASHIN DECIMAL(31,0), CASHOUT DECIMAL(31,0), EFFECTIVEDATE DATE, POSTINGTIME TIMESTAMP, STATUS CHAR(2), OPID VARCHAR(30), HOSTREQUEST LONG VARCHAR, HOSTRESPONSE LONG VARCHAR, REQUESTDATA LONG VARCHAR)"

db2 "DISCONNECT BTF"

