/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.command.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmdParserHelper {
    static final String timeExpr = "(\\d){2}:(\\d){2}:(\\d){2}";
    static final String dateExpr = "(\\d){4}/(\\d){2}/(\\d){2}";
    static final Pattern timePattern = Pattern.compile("(\\d){2}:(\\d){2}:(\\d){2}");
    static final Pattern datePattern = Pattern.compile("(\\d){4}/(\\d){2}/(\\d){2}");

    public static boolean checkTime(String time) {
        boolean valid = false;
        Matcher m = timePattern.matcher(time);
        boolean rs = m.matches();
        if (rs) {
            String[] strArry = time.split(":");
            int hour = Integer.parseInt(strArry[0]);
            int minute = Integer.parseInt(strArry[1]);
            int second = Integer.parseInt(strArry[2]);
            if (hour >= 0 && hour <= 59 && minute >= 0 && minute <= 59 && second >= 0 && second <= 59) {
                valid = true;
            }
        }
        return valid;
    }

    public static boolean checkDate(String date) {
        boolean valid = false;
        Matcher m = datePattern.matcher(date);
        boolean rs = m.matches();
        if (rs) {
            String[] strArry = date.split("/");
            int month = Integer.parseInt(strArry[1]);
            int day = Integer.parseInt(strArry[2]);
            if (month >= 1 && month <= 12 && day >= 1 && day <= 31) {
                valid = true;
            }
        }
        return valid;
    }

    public static boolean checkOccurrence(String val) {
        if ((val = val.toLowerCase()).equals("once") || val.equals("fixed") || val.equals("daily")) {
            return true;
        }
        if (val.startsWith("weekly")) {
            if (!(val = val.substring("weekly".length())).startsWith("(") || !val.endsWith(")") || val.length() <= 2) {
                return false;
            }
            int len = val.length();
            String tempStr = val.substring(1, len - 1);
            String[] days = tempStr.split("_");
            int i = 0;
            while (i < days.length) {
                boolean validDay = false;
                String day = days[i].trim();
                if (day.equalsIgnoreCase("monday") || day.equalsIgnoreCase("mon")) {
                    validDay = true;
                } else if (day.equalsIgnoreCase("tuesday") || day.equalsIgnoreCase("tue")) {
                    validDay = true;
                } else if (day.equalsIgnoreCase("wednesday") || day.equalsIgnoreCase("wed")) {
                    validDay = true;
                } else if (day.equalsIgnoreCase("thursday") || day.equalsIgnoreCase("thu")) {
                    validDay = true;
                } else if (day.equalsIgnoreCase("friday") || day.equalsIgnoreCase("fri")) {
                    validDay = true;
                } else if (day.equalsIgnoreCase("saturday") || day.equalsIgnoreCase("sat")) {
                    validDay = true;
                } else if (day.equalsIgnoreCase("sunday") || day.equalsIgnoreCase("sun")) {
                    validDay = true;
                }
                if (!validDay) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (val.startsWith("monthly")) {
            if (!(val = val.substring("monthly".length())).startsWith("(") || !val.endsWith(")") || val.length() <= 2) {
                return false;
            }
            int len = val.length();
            String tempStr = val.substring(1, len - 1);
            String[] days = tempStr.split("_");
            int i = 0;
            while (i < days.length) {
                int dayNum;
                String day = days[i].trim();
                try {
                    dayNum = Integer.parseInt(day);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (dayNum < 1 || dayNum > 32) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

