/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.SerializableImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class AssociatedEventImpl
extends SerializableImpl
implements AssociatedEvent,
Cloneable {
    private static final long serialVersionUID = -4327879421885580788L;
    protected static final String ASSOCIATION_ENGINE_EDEFAULT = null;
    protected String associationEngine = ASSOCIATION_ENGINE_EDEFAULT;
    protected static final String RESOLVED_EVENTS_EDEFAULT = null;
    protected String resolvedEvents = RESOLVED_EVENTS_EDEFAULT;
    protected AssociationEngine associationEngineInfo = null;

    protected AssociatedEventImpl() {
    }

    public void setAssociationEngine(String newAssociationEngine) {
        String oldAssociationEngine = this.associationEngine;
        this.associationEngine = newAssociationEngine;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldAssociationEngine, (Object)this.associationEngine));
        }
    }

    public String getAssociationEngine() {
        return this.associationEngine;
    }

    public void setAssociationEngineInfo(AssociationEngine newAssociationEngineInfo) {
        if (newAssociationEngineInfo != this.associationEngineInfo) {
            NotificationChain msgs = null;
            if (this.associationEngineInfo != null) {
                msgs = ((InternalEObject)((Object)this.associationEngineInfo)).eInverseRemove(this, -3, null, msgs);
            }
            if (newAssociationEngineInfo != null) {
                msgs = ((InternalEObject)((Object)newAssociationEngineInfo)).eInverseAdd(this, -3, null, msgs);
            }
            if ((msgs = this.basicSetAssociationEngineInfo(newAssociationEngineInfo, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newAssociationEngineInfo, (Object)newAssociationEngineInfo));
        }
    }

    public void setAssociationEngineInfo(String associationEngineName, String associationEngineType, String associationEngineId) {
        AssociationEngine aei = EventFactory.eINSTANCE.createAssociationEngine();
        aei.setName(associationEngineName);
        aei.setType(associationEngineType);
        aei.setId(associationEngineId);
        this.setAssociationEngineInfo(aei);
    }

    public AssociationEngine getAssociationEngineInfo() {
        return this.associationEngineInfo;
    }

    public void setResolvedEvents(String newResolvedEvents) {
        String oldResolvedEvents = this.resolvedEvents;
        this.resolvedEvents = newResolvedEvents;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldResolvedEvents, (Object)this.resolvedEvents));
        }
    }

    public String getResolvedEvents() {
        return this.resolvedEvents;
    }

    public void setResolvedEventsAsArray(String[] newResolvedEvents) {
        StringBuffer myList = new StringBuffer();
        if (newResolvedEvents != null) {
            int i = 0;
            while (i < newResolvedEvents.length) {
                if (newResolvedEvents[i].indexOf(" ") != -1) {
                    throw new IllegalArgumentException("Blanks are not allowed in the array [" + newResolvedEvents[i] + "]");
                }
                if (i != 0) {
                    myList.append(" ");
                }
                myList.append(newResolvedEvents[i]);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("The input array cannot be null.");
        }
        this.setResolvedEvents(myList.toString());
    }

    public String[] getResolvedEventsAsArray() {
        String resolvedEvents = this.getResolvedEvents();
        if (resolvedEvents != null) {
            return InternationalizationUtilities.tokenize((String)resolvedEvents);
        }
        return new String[0];
    }

    public void addResolvedEvent(String globalInstanceId) {
        if (globalInstanceId != null) {
            if (this.resolvedEvents == RESOLVED_EVENTS_EDEFAULT) {
                this.setResolvedEvents(globalInstanceId);
            } else if (this.resolvedEvents.indexOf(globalInstanceId) == -1) {
                this.setResolvedEvents(this.resolvedEvents.trim().concat(" ").concat(globalInstanceId.trim()));
            }
        } else {
            throw new IllegalArgumentException("The input string cannot be null.");
        }
    }

    public void clearResolvedEvents() {
        this.resolvedEvents = RESOLVED_EVENTS_EDEFAULT;
    }

    public void removeResolvedEvent(String globalInstanceId) {
        if (globalInstanceId != null) {
            if (this.resolvedEvents != RESOLVED_EVENTS_EDEFAULT) {
                int index;
                while ((index = this.resolvedEvents.indexOf(globalInstanceId)) != -1) {
                    this.setResolvedEvents(this.resolvedEvents.substring(0, index).trim().concat(" ").concat(this.resolvedEvents.substring(index + globalInstanceId.length()).trim()));
                }
            }
        } else {
            throw new IllegalArgumentException("The input string cannot be null.");
        }
    }

    public NotificationChain basicSetAssociationEngineInfo(AssociationEngine newAssociationEngineInfo, NotificationChain msgs) {
        AssociationEngine oldAssociationEngineInfo = this.associationEngineInfo;
        this.associationEngineInfo = newAssociationEngineInfo;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldAssociationEngineInfo, (Object)newAssociationEngineInfo);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getAssociationEngine();
            }
            case 1: {
                return this.getResolvedEvents();
            }
            case 2: {
                return this.getAssociationEngineInfo();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 2: {
                    return this.basicSetAssociationEngineInfo(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ASSOCIATION_ENGINE_EDEFAULT == null ? this.associationEngine != null : !ASSOCIATION_ENGINE_EDEFAULT.equals(this.associationEngine);
            }
            case 1: {
                return RESOLVED_EVENTS_EDEFAULT == null ? this.resolvedEvents != null : !RESOLVED_EVENTS_EDEFAULT.equals(this.resolvedEvents);
            }
            case 2: {
                return this.associationEngineInfo != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setAssociationEngine((String)newValue);
                return;
            }
            case 1: {
                this.setResolvedEvents((String)newValue);
                return;
            }
            case 2: {
                this.setAssociationEngineInfo((AssociationEngine)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setAssociationEngine(ASSOCIATION_ENGINE_EDEFAULT);
                return;
            }
            case 1: {
                this.setResolvedEvents(RESOLVED_EVENTS_EDEFAULT);
                return;
            }
            case 2: {
                this.setAssociationEngineInfo(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object arg0) {
        AssociatedEventImpl associatedEventImpl = this;
        synchronized (associatedEventImpl) {
            return EventHelpers.compareEObject(this, arg0);
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (associationEngine: ");
        result.append(this.associationEngine);
        result.append(", resolvedEvents: ");
        result.append(this.resolvedEvents);
        result.append(", associationEngineInfo: ");
        result.append(this.associationEngineInfo);
        result.append(')');
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws ValidationException {
        AssociatedEventImpl associatedEventImpl = this;
        synchronized (associatedEventImpl) {
            if (this.resolvedEvents == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.AssociatedEvent.ResolvedEvents"));
            }
            if (this.associationEngine == null && this.associationEngineInfo == null || this.associationEngine != null && this.associationEngineInfo != null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_", "CommonBaseEvent.AssociatedEvent.AssociationEngine", "CommonBaseEvent.AssociatedEvent.AssociationEngineInfo"));
            }
            String[] resolvedEventsArray = this.getResolvedEventsAsArray();
            int counter = 0;
            while (counter < resolvedEventsArray.length) {
                if (resolvedEventsArray[counter].length() < 32 || resolvedEventsArray[counter].length() > 64) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_", "CommonBaseEvent.AssociatedEvent.ResolvedEvents[".concat(String.valueOf(counter + 1)).concat("]"), resolvedEventsArray[counter]));
                }
                if (!Character.isLetter(resolvedEventsArray[counter].charAt(0))) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_", "CommonBaseEvent.AssociatedEvent.ResolvedEvents[".concat(String.valueOf(counter + 1)).concat("]"), resolvedEventsArray[counter]));
                }
                ++counter;
            }
            if (this.associationEngineInfo != null) {
                this.associationEngineInfo.validate();
            } else {
                if (this.associationEngine.length() < 32 || this.associationEngine.length() > 64) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_", "CommonBaseEvent.AssociatedEvent.AssociationEngine", this.associationEngine));
                }
                if (!Character.isLetter(this.associationEngine.charAt(0))) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_", "CommonBaseEvent.AssociatedEvent.AssociationEngine", this.associationEngine));
                }
            }
        }
    }

    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getAssociatedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        AssociatedEventImpl associatedEventImpl = this;
        synchronized (associatedEventImpl) {
            return EcoreUtil.copy(this);
        }
    }

    public void init() {
        this.setAssociationEngine(ASSOCIATION_ENGINE_EDEFAULT);
        this.setAssociationEngineInfo(null);
        this.setResolvedEvents(RESOLVED_EVENTS_EDEFAULT);
    }
}

