/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.tools;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.discovery.jdk.JDKHooks;

public class ManagedProperties {
    private static final HashMap propertiesCache = new HashMap();

    public static String getProperty(String propertyName) {
        return ManagedProperties.getProperty(ManagedProperties.getThreadContextClassLoader(), propertyName);
    }

    public static String getProperty(String propertyName, String dephault) {
        return ManagedProperties.getProperty(ManagedProperties.getThreadContextClassLoader(), propertyName, dephault);
    }

    public static String getProperty(ClassLoader classLoader, String propertyName) {
        Value val;
        String value2 = System.getProperty(propertyName);
        if (value2 == null && (val = ManagedProperties.getValueProperty(classLoader, propertyName)) != null) {
            value2 = val.value;
        }
        return value2;
    }

    public static String getProperty(ClassLoader classLoader, String propertyName, String dephault) {
        String value2 = ManagedProperties.getProperty(classLoader, propertyName);
        return value2 == null ? dephault : value2;
    }

    public static void setProperty(String propertyName, String value2) {
        ManagedProperties.setProperty(propertyName, value2, false);
    }

    public static void setProperty(String propertyName, String value2, boolean isDefault) {
        if (propertyName != null) {
            HashMap hashMap = propertiesCache;
            synchronized (hashMap) {
                ClassLoader classLoader = ManagedProperties.getThreadContextClassLoader();
                HashMap<String, Value> properties = (HashMap<String, Value>)propertiesCache.get(classLoader);
                if (value2 == null) {
                    properties.remove(propertyName);
                } else {
                    if (properties == null) {
                        properties = new HashMap<String, Value>();
                        propertiesCache.put(classLoader, properties);
                    }
                    properties.put(propertyName, new Value(value2, isDefault));
                }
            }
        }
    }

    public static void setProperties(Map newProperties) {
        ManagedProperties.setProperties(newProperties, false);
    }

    public static void setProperties(Map newProperties, boolean isDefault) {
        Iterator it = newProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ManagedProperties.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), isDefault);
        }
    }

    public static Enumeration propertyNames() {
        Hashtable allProps = new Hashtable();
        ClassLoader classLoader = ManagedProperties.getThreadContextClassLoader();
        while (true) {
            HashMap properties = null;
            HashMap hashMap = propertiesCache;
            synchronized (hashMap) {
                properties = (HashMap)propertiesCache.get(classLoader);
            }
            if (properties != null) {
                allProps.putAll(properties);
            }
            if (classLoader == null) break;
            classLoader = ManagedProperties.getParent(classLoader);
        }
        return allProps.keys();
    }

    public static Properties getProperties() {
        Properties p = new Properties();
        Enumeration names = ManagedProperties.propertyNames();
        while (names.hasMoreElements()) {
            String name2 = (String)names.nextElement();
            ((Hashtable)p).put(name2, ManagedProperties.getProperty(name2));
        }
        return p;
    }

    private static final Value getValueProperty(ClassLoader classLoader, String propertyName) {
        Value value2 = null;
        if (propertyName != null) {
            if (classLoader != null) {
                value2 = ManagedProperties.getValueProperty(ManagedProperties.getParent(classLoader), propertyName);
            }
            if (value2 == null || value2.isDefault) {
                HashMap hashMap = propertiesCache;
                synchronized (hashMap) {
                    Value altValue;
                    HashMap properties = (HashMap)propertiesCache.get(classLoader);
                    if (properties != null && (altValue = (Value)properties.get(propertyName)) != null) {
                        value2 = altValue;
                    }
                }
            }
        }
        return value2;
    }

    private static final ClassLoader getThreadContextClassLoader() {
        return JDKHooks.getJDKHooks().getThreadContextClassLoader();
    }

    private static final ClassLoader getParent(final ClassLoader classLoader) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classLoader.getParent();
            }
        });
    }

    private static class Value {
        final String value;
        final boolean isDefault;

        Value(String value2, boolean isDefault) {
            this.value = value2;
            this.isDefault = isDefault;
        }
    }
}

