/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private boolean doExpungeNotification = true;
    private Status cachedStatus = null;
    private long cachedStatusTime = 0L;
    private boolean debug = false;
    private PrintStream out;
    private boolean connectionPoolDebug;

    protected IMAPFolder(String fullName, char separator, IMAPStore store) {
        super(store);
        if (fullName == null) {
            throw new NullPointerException("Folder name is null");
        }
        this.fullName = fullName;
        this.separator = separator;
        this.messageCacheLock = new Object();
        this.debug = store.getSession().getDebug();
        this.connectionPoolDebug = store.getConnectionPoolDebug();
        this.out = store.getSession().getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
    }

    protected IMAPFolder(ListInfo li, IMAPStore store) {
        this(li.name, li.separator, store);
        if (li.hasInferiors) {
            this.type |= 2;
        }
        if (li.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException(this, this.fullName + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException(this, "Lost folder connection to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRange(int msgno) throws MessagingException {
        if (msgno < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (msgno <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (msgno > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator0()) + 1);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Folder getParent() throws MessagingException {
        char c = this.getSeparator0();
        int index = this.fullName.lastIndexOf(c);
        if (index != -1) {
            return new IMAPFolder(this.fullName.substring(0, index), c, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public boolean exists() throws MessagingException {
        ListInfo[] li = null;
        li = (ListInfo[])this.doCommand(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                return p.list("", IMAPFolder.this.fullName);
            }
        });
        if (li != null) {
            this.fullName = li[0].name;
            this.separator = li[0].separator;
            if (li[0].hasInferiors) {
                this.type |= 2;
            }
            if (li[0].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    public Folder[] list(String pattern) throws MessagingException {
        return this.doList(pattern, false);
    }

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        return this.doList(pattern, true);
    }

    private Folder[] doList(final String pattern, final boolean subscribed) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        final char c = this.getSeparator0();
        ListInfo[] li = (ListInfo[])this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                if (subscribed) {
                    return p.lsub("", IMAPFolder.this.fullName + c + pattern);
                }
                return p.list("", IMAPFolder.this.fullName + c + pattern);
            }
        });
        if (li == null) {
            return new Folder[0];
        }
        int start = 0;
        if (li[0].name.equals(this.fullName + c)) {
            start = 1;
        }
        Folder[] folders = new IMAPFolder[li.length - start];
        for (int i = start; i < li.length; ++i) {
            folders[i - start] = new IMAPFolder(li[i], (IMAPStore)this.store);
        }
        return folders;
    }

    public synchronized char getSeparator() throws MessagingException {
        this.checkExists();
        return this.getSeparator0();
    }

    private synchronized char getSeparator0() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] li = null;
            li = (ListInfo[])this.doCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol p) throws ProtocolException {
                    if (p.isREV1()) {
                        return p.list(IMAPFolder.this.fullName, "");
                    }
                    return p.list("", IMAPFolder.this.fullName);
                }
            });
            this.separator = li != null ? li[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    public boolean isSubscribed() {
        ListInfo[] li = null;
        try {
            li = (ListInfo[])this.doProtocolCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol p) throws ProtocolException {
                    return p.lsub("", IMAPFolder.this.fullName);
                }
            });
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        return li != null;
    }

    public void setSubscribed(final boolean subscribe) throws MessagingException {
        this.checkExists();
        this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                if (subscribe) {
                    p.subscribe(IMAPFolder.this.fullName);
                } else {
                    p.unsubscribe(IMAPFolder.this.fullName);
                }
                return null;
            }
        });
    }

    public synchronized boolean create(final int type) throws MessagingException {
        char sep;
        Object ret;
        char c = '\u0000';
        if ((type & 1) == 0) {
            c = this.getSeparator0();
        }
        if ((ret = this.doCommandIgnoreFailure(new ProtocolCommand(sep = c){
            private final /* synthetic */ char val$sep;
            {
                this.val$sep = val$sep;
            }

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                if ((type & 1) == 0) {
                    p.create(IMAPFolder.this.fullName + this.val$sep);
                } else {
                    ListInfo[] li;
                    p.create(IMAPFolder.this.fullName);
                    if ((type & 2) != 0 && (li = p.list("", IMAPFolder.this.fullName)) != null && !li[0].hasInferiors) {
                        p.delete(IMAPFolder.this.fullName);
                        throw new ProtocolException("Unsupported type");
                    }
                }
                return Boolean.TRUE;
            }
        })) == null) {
            return false;
        }
        this.exists = true;
        this.type = type;
        this.notifyFolderListeners(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        this.checkExists();
        if (this.opened) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.keepConnectionAlive(true);
                }
                catch (ConnectionException cex) {
                    throw new FolderClosedException(this, cex.getMessage());
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
            }
            return this.recent > 0;
        }
        Boolean b = (Boolean)this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                ListInfo[] li = p.list("", IMAPFolder.this.fullName);
                if (li != null) {
                    if (li[0].changeState == 1) {
                        return Boolean.TRUE;
                    }
                    if (li[0].changeState == 2) {
                        return Boolean.FALSE;
                    }
                }
                Status status = IMAPFolder.this.getStatus();
                if (status.recent > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (b == null) {
            return false;
        }
        return b;
    }

    public Folder getFolder(String name2) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c = this.getSeparator0();
        return new IMAPFolder(this.fullName + c + name2, c, (IMAPStore)this.store);
    }

    public synchronized boolean delete(boolean recurse) throws MessagingException {
        Object ret;
        this.checkClosed();
        if (recurse) {
            Folder[] f = this.list();
            for (int i = 0; i < f.length; ++i) {
                f[i].delete(recurse);
            }
        }
        if ((ret = this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                p.delete(IMAPFolder.this.fullName);
                return Boolean.TRUE;
            }
        })) == null) {
            return false;
        }
        this.exists = false;
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized boolean renameTo(final Folder f) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (f.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        Object ret = this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                p.rename(IMAPFolder.this.fullName, f.getFullName());
                return Boolean.TRUE;
            }
        });
        if (ret == null) {
            return false;
        }
        this.exists = false;
        this.notifyFolderRenamedListeners(f);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void open(int mode) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if ((this.type & 1) == 0) {
            throw new MessagingException("folder cannot contain messages");
        }
        MailboxInfo mi = null;
        this.protocol = ((IMAPStore)this.store).getProtocol(this);
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.protocol.addResponseHandler(this);
            try {
                mi = mode == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (CommandFailedException cex) {
                this.releaseProtocol(true);
                this.protocol = null;
                throw new MessagingException(cex.getMessage(), cex);
            }
            catch (ProtocolException pex) {
                try {
                    try {
                        this.protocol.logout();
                    }
                    catch (ProtocolException pex2) {
                        Object var7_9 = null;
                        this.releaseProtocol(false);
                        this.protocol = null;
                        throw new MessagingException(pex.getMessage(), pex);
                    }
                    Object var7_8 = null;
                    this.releaseProtocol(false);
                    this.protocol = null;
                    throw new MessagingException(pex.getMessage(), pex);
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.releaseProtocol(false);
                    this.protocol = null;
                    throw new MessagingException(pex.getMessage(), pex);
                }
            }
            if (!(mi.mode == mode || mode == 2 && mi.mode == 1 && ((IMAPStore)this.store).allowReadOnlySelect())) {
                try {
                    try {
                        this.protocol.close();
                        this.releaseProtocol(true);
                    }
                    catch (ProtocolException pex) {
                        try {
                            this.protocol.logout();
                        }
                        catch (ProtocolException pex2) {
                        }
                        finally {
                            this.releaseProtocol(false);
                        }
                        Object var10_15 = null;
                        this.protocol = null;
                        throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                    }
                    Object var10_14 = null;
                    this.protocol = null;
                    throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    this.protocol = null;
                    throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                }
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mi.mode;
            this.availableFlags = mi.availableFlags;
            this.permanentFlags = mi.permanentFlags;
            this.total = this.realTotal = mi.total;
            this.recent = mi.recent;
            this.uidvalidity = mi.uidvalidity;
            this.messageCache = new Vector(this.total);
            int i = 0;
            while (true) {
                if (i >= this.total) {
                    // MONITOREXIT @DISABLED, blocks:[18, 19, 8] lbl76 : MonitorExitStatement: MONITOREXIT : object
                    this.notifyConnectionListeners(1);
                    return;
                }
                this.messageCache.addElement(new IMAPMessage(this, i + 1, i + 1));
                ++i;
            }
        }
    }

    public synchronized void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, msgs, fp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlags(Message[] msgs, Flags flag, boolean value2) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flag);
        if (msgs.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.storeFlags(Utility.toMessageSet(msgs, null), flag, value2);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean expunge) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            block19: {
                if (!this.opened && this.reallyClosed) {
                    throw new IllegalStateException("This operation is not allowed on a closed folder");
                }
                this.reallyClosed = true;
                if (!this.opened) {
                    return;
                }
                try {
                    block20: {
                        if (((IMAPStore)this.store).isConnectionPoolFull()) {
                            if (this.debug) {
                                this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                            }
                            if (expunge) {
                                this.protocol.close();
                            }
                            if (this.protocol != null) {
                                this.protocol.logout();
                            }
                            break block19;
                        }
                        if (!expunge && this.mode == 2) {
                            try {
                                MailboxInfo mi = this.protocol.examine(this.fullName);
                            }
                            catch (ProtocolException pex2) {
                                if (this.protocol == null) break block20;
                                this.protocol.disconnect();
                            }
                        }
                    }
                    if (this.protocol != null) {
                        this.protocol.close();
                    }
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
                finally {
                    if (this.opened) {
                        this.cleanup(true);
                    }
                }
            }
        }
    }

    private void cleanup(boolean returnToPool) {
        this.releaseProtocol(returnToPool);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
        return this.opened;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    public synchronized int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException bex) {
                IMAPProtocol p = null;
                try {
                    p = this.getStoreProtocol();
                    MailboxInfo minfo = p.examine(this.fullName);
                    p.close();
                    int n = minfo.total;
                    return n;
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
                finally {
                    this.releaseStoreProtocol(p);
                }
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.total;
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
    }

    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException bex) {
                IMAPProtocol p = null;
                try {
                    p = this.getStoreProtocol();
                    MailboxInfo minfo = p.examine(this.fullName);
                    p.close();
                    int n = minfo.recent;
                    return n;
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
                finally {
                    this.releaseStoreProtocol(p);
                }
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.recent;
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException bex) {
                return -1;
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        Flags f = new Flags();
        f.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(new FlagTerm(f, false));
                return matches.length;
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getDeletedMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            return -1;
        }
        Flags f = new Flags();
        f.add(Flags.Flag.DELETED);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(new FlagTerm(f, true));
                return matches.length;
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getStatus() throws ProtocolException {
        int statusCacheTimeout = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (statusCacheTimeout > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)statusCacheTimeout) {
            return this.cachedStatus;
        }
        IMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Status s = p.status(this.fullName, null);
            if (statusCacheTimeout > 0) {
                this.cachedStatus = s;
                this.cachedStatusTime = System.currentTimeMillis();
            }
            Status status = s;
            return status;
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    public synchronized Message getMessage(int msgnum) throws MessagingException {
        this.checkOpened();
        this.checkRange(msgnum);
        return (Message)this.messageCache.elementAt(msgnum - 1);
    }

    public void appendMessages(Message[] msgs) throws MessagingException {
        this.checkExists();
        int maxsize = ((IMAPStore)this.store).getAppendBufferSize();
        for (int i = 0; i < msgs.length; ++i) {
            MessageLiteral mos;
            Message m = msgs[i];
            try {
                mos = new MessageLiteral(m, m.getSize() > maxsize ? 0 : maxsize);
            }
            catch (IOException ex) {
                throw new MessagingException("IOException while appending messages", ex);
            }
            catch (MessageRemovedException mrex) {
                continue;
            }
            Date d = m.getReceivedDate();
            if (d == null) {
                d = m.getSentDate();
            }
            final Date dd = d;
            final Flags f = m.getFlags();
            this.doCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol p) throws ProtocolException {
                    p.append(IMAPFolder.this.fullName, f, dd, mos);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyMessages(Message[] msgs, Folder folder) throws MessagingException {
        this.checkOpened();
        if (msgs.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.protocol.copy(Utility.toMessageSet(msgs, null), folder.getFullName());
                }
                catch (CommandFailedException cfx) {
                    if (cfx.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, folder.getFullName() + " does not exist");
                    }
                    throw new MessagingException(cfx.getMessage(), cfx);
                }
                catch (ConnectionException cex) {
                    throw new FolderClosedException(this, cex.getMessage());
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
            }
        }
        super.copyMessages(msgs, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] expunge() throws MessagingException {
        this.checkOpened();
        Vector<IMAPMessage> v = new Vector<IMAPMessage>();
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.doExpungeNotification = false;
            try {
                this.protocol.expunge();
            }
            catch (CommandFailedException cfx) {
                if (this.mode != 2) {
                    throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                }
                throw new MessagingException(cfx.getMessage(), cfx);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
            finally {
                this.doExpungeNotification = true;
            }
            int i = 0;
            while (i < this.messageCache.size()) {
                IMAPMessage m = (IMAPMessage)this.messageCache.elementAt(i);
                if (m.isExpunged()) {
                    long uid;
                    v.addElement(m);
                    this.messageCache.removeElementAt(i);
                    if (this.uidTable == null || (uid = m.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(uid));
                    continue;
                }
                m.setMessageNumber(m.getSequenceNumber());
                ++i;
            }
        }
        this.total = this.messageCache.size();
        Object[] msgs = new Message[v.size()];
        v.copyInto(msgs);
        if (msgs.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])msgs);
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm term) throws MessagingException {
        this.checkOpened();
        try {
            Message[] matchMsgs = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(term);
                if (matches != null) {
                    matchMsgs = new IMAPMessage[matches.length];
                    for (int i = 0; i < matches.length; ++i) {
                        matchMsgs[i] = this.getMessageBySeqNumber(matches[i]);
                    }
                }
            }
            return matchMsgs;
        }
        catch (CommandFailedException cfx) {
            return super.search(term);
        }
        catch (SearchException sex) {
            return super.search(term);
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        this.checkOpened();
        if (msgs.length == 0) {
            return msgs;
        }
        try {
            Message[] matchMsgs = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(Utility.toMessageSet(msgs, null), term);
                if (matches != null) {
                    matchMsgs = new IMAPMessage[matches.length];
                    for (int i = 0; i < matches.length; ++i) {
                        matchMsgs[i] = this.getMessageBySeqNumber(matches[i]);
                    }
                }
            }
            return matchMsgs;
        }
        catch (CommandFailedException cfx) {
            return super.search(term, msgs);
        }
        catch (SearchException sex) {
            return super.search(term, msgs);
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
    }

    public synchronized long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        IMAPProtocol p = null;
        Status status = null;
        try {
            p = this.getStoreProtocol();
            String[] item = new String[]{"UIDVALIDITY"};
            status = p.status(this.fullName, item);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("Cannot obtain UIDValidity", bex);
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return status.uidvalidity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message getMessageByUID(long uid) throws MessagingException {
        this.checkOpened();
        Long l = new Long(uid);
        IMAPMessage m = null;
        if (this.uidTable != null) {
            m = (IMAPMessage)this.uidTable.get(l);
            if (m != null) {
                return m;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID u = this.protocol.fetchSequenceNumber(uid);
                if (u != null) {
                    m = (IMAPMessage)this.messageCache.elementAt(u.msgno - 1);
                    m.setUID(u.uid);
                    this.uidTable.put(l, m);
                }
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long start, long end) throws MessagingException {
        Message[] msgs;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID[] ua = this.protocol.fetchSequenceNumbers(start, end);
                msgs = new Message[ua.length];
                for (int i = 0; i < ua.length; ++i) {
                    IMAPMessage m = (IMAPMessage)this.messageCache.elementAt(ua[i].msgno - 1);
                    m.setUID(ua[i].uid);
                    msgs[i] = m;
                    this.uidTable.put(new Long(ua[i].uid), m);
                }
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long[] uids) throws MessagingException {
        int i;
        Object v;
        this.checkOpened();
        long[] unavailUids = uids;
        if (this.uidTable != null) {
            v = new Vector();
            for (int i2 = 0; i2 < uids.length; ++i2) {
                Long l = new Long(uids[i2]);
                if (this.uidTable.containsKey(l)) continue;
                ((Vector)v).addElement(l);
            }
            int vsize = ((Vector)v).size();
            unavailUids = new long[vsize];
            for (i = 0; i < vsize; ++i) {
                unavailUids[i] = (Long)((Vector)v).elementAt(i);
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (unavailUids.length > 0) {
            try {
                v = this.messageCacheLock;
                synchronized (v) {
                    UID[] ua = this.protocol.fetchSequenceNumbers(unavailUids);
                    for (i = 0; i < ua.length; ++i) {
                        IMAPMessage m = (IMAPMessage)this.messageCache.elementAt(ua[i].msgno - 1);
                        m.setUID(ua[i].uid);
                        this.uidTable.put(new Long(ua[i].uid), m);
                    }
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        Message[] msgs = new Message[uids.length];
        for (int i3 = 0; i3 < uids.length; ++i3) {
            msgs[i3] = (Message)this.uidTable.get(new Long(uids[i3]));
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage m = (IMAPMessage)message;
        long uid = m.getUID();
        if (uid != -1L) {
            return uid;
        }
        UID u = null;
        Object object = this.messageCacheLock;
        synchronized (object) {
            m.checkExpunged();
            try {
                u = this.protocol.fetchUID(m.getSequenceNumber());
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (u != null) {
            uid = u.uid;
            m.setUID(uid);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(uid), m);
        }
        return uid;
    }

    public Quota[] getQuota() throws MessagingException {
        return (Quota[])this.doOptionalCommand("QUOTA not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                return p.getQuotaRoot(IMAPFolder.this.fullName);
            }
        });
    }

    public void setQuota(final Quota quota) throws MessagingException {
        this.doOptionalCommand("QUOTA not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                p.setQuota(quota);
                return null;
            }
        });
    }

    public ACL[] getACL() throws MessagingException {
        return (ACL[])this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                return p.getACL(IMAPFolder.this.fullName);
            }
        });
    }

    public void addACL(ACL acl) throws MessagingException {
        this.setACL(acl, '\u0000');
    }

    public void removeACL(final String name2) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                p.deleteACL(IMAPFolder.this.fullName, name2);
                return null;
            }
        });
    }

    public void addRights(ACL acl) throws MessagingException {
        this.setACL(acl, '+');
    }

    public void removeRights(ACL acl) throws MessagingException {
        this.setACL(acl, '-');
    }

    public Rights[] listRights(final String name2) throws MessagingException {
        return (Rights[])this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                return p.listRights(IMAPFolder.this.fullName, name2);
            }
        });
    }

    public Rights myRights() throws MessagingException {
        return (Rights)this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                return p.myRights(IMAPFolder.this.fullName);
            }
        });
    }

    private void setACL(final ACL acl, final char mod) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                p.setACL(IMAPFolder.this.fullName, mod, acl);
                return null;
            }
        });
    }

    public void handleResponse(Response r) {
        if (r.isOK() || r.isNO() || r.isBAD() || r.isBYE()) {
            ((IMAPStore)this.store).handleResponseCode(r);
        }
        if (r.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (r.isOK()) {
            return;
        }
        if (!r.isUnTagged()) {
            return;
        }
        if (!(r instanceof IMAPResponse)) {
            this.out.println("UNEXPECTED RESPONSE : " + r.toString());
            this.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse ir = (IMAPResponse)r;
        if (ir.keyEquals("EXISTS")) {
            int exists = ir.getNumber();
            if (exists <= this.realTotal) {
                return;
            }
            int count = exists - this.realTotal;
            Message[] msgs = new Message[count];
            for (int i = 0; i < count; ++i) {
                IMAPMessage msg = new IMAPMessage(this, ++this.total, ++this.realTotal);
                msgs[i] = msg;
                this.messageCache.addElement(msg);
            }
            this.notifyMessageAddedListeners(msgs);
        } else if (ir.keyEquals("EXPUNGE")) {
            IMAPMessage msg = this.getMessageBySeqNumber(ir.getNumber());
            msg.setExpunged(true);
            for (int i = msg.getMessageNumber(); i < this.total; ++i) {
                IMAPMessage m = (IMAPMessage)this.messageCache.elementAt(i);
                if (m.isExpunged()) continue;
                m.setSequenceNumber(m.getSequenceNumber() - 1);
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                Message[] msgs = new Message[]{msg};
                this.notifyMessageRemovedListeners(false, msgs);
            }
        } else if (ir.keyEquals("FETCH")) {
            IMAPMessage msg;
            FetchResponse f = (FetchResponse)ir;
            Flags flags = (Flags)((Object)f.getItem(Flags.class));
            if (flags != null && (msg = this.getMessageBySeqNumber(f.getNumber())) != null) {
                msg._setFlags(flags);
                this.notifyMessageChangedListeners(1, msg);
            }
        } else if (ir.keyEquals("RECENT")) {
            this.recent = ir.getNumber();
        }
    }

    void handleResponses(Response[] r) {
        for (int i = 0; i < r.length; ++i) {
            if (r[i] == null) continue;
            this.handleResponse(r[i]);
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.connectionPoolDebug) {
            this.out.println("DEBUG: getStoreProtocol() - borrowing a connection");
        }
        return ((IMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(ConnectionException cex) throws FolderClosedException, StoreClosedException {
        if (cex.getProtocol() == this.protocol) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        throw new StoreClosedException(this.store, cex.getMessage());
    }

    public IMAPProtocol getProtocol() {
        return this.protocol;
    }

    public Object doCommand(ProtocolCommand cmd) throws MessagingException {
        try {
            return this.doProtocolCommand(cmd);
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return null;
    }

    public Object doOptionalCommand(String err, ProtocolCommand cmd) throws MessagingException {
        try {
            return this.doProtocolCommand(cmd);
        }
        catch (BadCommandException bex) {
            throw new MessagingException(err, bex);
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return null;
    }

    public Object doCommandIgnoreFailure(ProtocolCommand cmd) throws MessagingException {
        try {
            return this.doProtocolCommand(cmd);
        }
        catch (CommandFailedException cfx) {
            return null;
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doProtocolCommand(ProtocolCommand cmd) throws ProtocolException {
        IMAPFolder iMAPFolder = this;
        synchronized (iMAPFolder) {
            if (this.opened && !((IMAPStore)this.store).hasSeparateStoreConnection()) {
                Object object = this.messageCacheLock;
                synchronized (object) {
                    return cmd.doCommand(this.getProtocol());
                }
            }
        }
        IMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = cmd.doCommand(p);
            return object;
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol p) {
        if (p != this.protocol) {
            ((IMAPStore)this.store).releaseStoreProtocol(p);
        }
    }

    private void releaseProtocol(boolean returnToPool) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (returnToPool) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
            } else {
                ((IMAPStore)this.store).releaseProtocol(this, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepConnectionAlive(boolean keepStoreAlive) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.protocol.noop();
        }
        if (keepStoreAlive && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol p = null;
            try {
                p = ((IMAPStore)this.store).getStoreProtocol();
                if (System.currentTimeMillis() - p.getTimestamp() > 1000L) {
                    p.noop();
                }
            }
            finally {
                ((IMAPStore)this.store).releaseStoreProtocol(p);
            }
        }
    }

    IMAPMessage getMessageBySeqNumber(int seqnum) {
        for (int i = seqnum - 1; i < this.total; ++i) {
            IMAPMessage msg = (IMAPMessage)this.messageCache.elementAt(i);
            if (msg.getSequenceNumber() != seqnum) continue;
            return msg;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    public static interface ProtocolCommand {
        public Object doCommand(IMAPProtocol var1) throws ProtocolException;
    }

    public static class FetchProfileItem
    extends FetchProfile.Item {
        public static final FetchProfileItem HEADERS = new FetchProfileItem("HEADERS");
        public static final FetchProfileItem SIZE = new FetchProfileItem("SIZE");

        protected FetchProfileItem(String name2) {
            super(name2);
        }
    }
}

