/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;

public final class XMLString {
    public static final int FLAGS_NOTWHITESPACE = 1;
    public static final int FLAGS_ALLWHITESPACE = 2;
    public static final int FLAGS_NORMALIZE_EOL = 4;
    public byte[] bytes;
    public int startOffset;
    public int endOffset;
    public int length;
    public int flags;
    public DataBuffer firstBuffer;
    public DataBuffer lastBuffer;
    protected char[][] fConvertedChars;
    protected int[] fConvertedCharsOffset;

    public XMLString() {
    }

    public XMLString(XMLString xMLString) {
        this.bytes = xMLString.bytes;
        this.startOffset = xMLString.startOffset;
        this.endOffset = xMLString.endOffset;
        this.length = xMLString.length;
        this.flags = xMLString.flags;
        this.firstBuffer = xMLString.firstBuffer;
        this.lastBuffer = xMLString.lastBuffer;
        if (this.firstBuffer != null) {
            this.firstBuffer.addReference();
            if (this.lastBuffer != null) {
                DataBuffer dataBuffer = this.firstBuffer;
                do {
                    dataBuffer = dataBuffer.next;
                    dataBuffer.addReference();
                } while (dataBuffer != this.lastBuffer);
            }
        }
    }

    public void clear() {
        if (this.firstBuffer != null) {
            this.bytes = null;
            this.startOffset = 0;
            this.endOffset = 0;
            this.length = 0;
            this.flags = 0;
            this.dropBufferReferences();
        }
    }

    private void dropBufferReferences() {
        if (this.lastBuffer == null) {
            this.firstBuffer.removeReference();
            this.firstBuffer = null;
        } else {
            DataBuffer dataBuffer;
            do {
                dataBuffer = this.firstBuffer;
                this.firstBuffer = dataBuffer.next;
                dataBuffer.removeReference();
            } while (dataBuffer != this.lastBuffer);
            this.firstBuffer = null;
            this.lastBuffer = null;
        }
    }

    public void setValues(DataBuffer dataBuffer, int n, int n2, int n3) {
        if (this.lastBuffer == null && n < dataBuffer.endOffset) {
            if (this.firstBuffer != dataBuffer) {
                if (this.firstBuffer == null) {
                    dataBuffer.addReference();
                    this.firstBuffer = dataBuffer;
                } else {
                    this.setValuesSlowly(dataBuffer, n, n2, n3);
                    return;
                }
            }
            this.startOffset = n;
            this.endOffset = n2;
            this.length = n2 - n;
            this.bytes = dataBuffer.bytes;
            this.flags = n3;
        } else {
            this.setValuesSlowly(dataBuffer, n, n2, n3);
        }
    }

    private void setValuesSlowly(DataBuffer dataBuffer, int n, int n2, int n3) {
        this.setStartPos(dataBuffer, n);
        this.setEndPos(dataBuffer, n2, n3);
    }

    public void setStartPos(DataBuffer dataBuffer, int n) {
        if (dataBuffer == this.firstBuffer) {
            if (this.lastBuffer == null) {
                this.startOffset = n;
            } else {
                this.setStartPosClearLast(n);
            }
        } else {
            this.setStartPosNewBuffer(dataBuffer, n);
        }
    }

    private void setStartPosClearLast(int n) {
        this.lastBuffer.removeReference();
        this.lastBuffer = null;
        this.startOffset = n;
    }

    private void setStartPosNewBuffer(DataBuffer dataBuffer, int n) {
        dataBuffer.addReference();
        if (this.firstBuffer != null) {
            this.dropBufferReferences();
        }
        this.firstBuffer = dataBuffer;
        this.startOffset = n;
    }

    public void setEndPos(DataBuffer dataBuffer, int n, int n2) {
        this.flags = n2;
        if (this.startOffset < this.firstBuffer.endOffset && dataBuffer == this.firstBuffer) {
            this.endOffset = n;
            this.length = n - this.startOffset;
            this.bytes = dataBuffer.bytes;
        } else {
            this.setEndPosSpecial(dataBuffer, n);
        }
    }

    private void setEndPosSpecial(DataBuffer dataBuffer, int n) {
        if (this.startOffset < this.firstBuffer.endOffset) {
            if (n > dataBuffer.startOffset) {
                this.setEndPosAcrossBuffers(dataBuffer, n);
            } else {
                this.fixEndPos(dataBuffer);
            }
        } else {
            this.fixStartPos(dataBuffer, n);
        }
    }

    private void setEndPosAcrossBuffers(DataBuffer dataBuffer, int n) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        this.endOffset = n;
        this.length = dataBuffer2.endOffset - this.startOffset;
        dataBuffer2 = dataBuffer2.next;
        while (dataBuffer2 != dataBuffer) {
            dataBuffer2.addReference();
            this.length += dataBuffer2.endOffset - dataBuffer2.startOffset;
            dataBuffer2 = dataBuffer2.next;
        }
        this.length += n - dataBuffer2.startOffset;
        dataBuffer2.addReference();
        this.lastBuffer = dataBuffer2;
        this.bytes = null;
    }

    private void fixStartPos(DataBuffer dataBuffer, int n) {
        if (dataBuffer != this.firstBuffer) {
            DataBuffer dataBuffer2 = this.firstBuffer;
            this.firstBuffer = dataBuffer2.next;
            this.firstBuffer.addReference();
            dataBuffer2.removeReference();
            this.startOffset = this.firstBuffer.startOffset;
            this.setEndPos(dataBuffer, n, this.flags);
        }
    }

    private void fixEndPos(DataBuffer dataBuffer) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        while (dataBuffer2.next != dataBuffer) {
            dataBuffer2 = dataBuffer2.next;
        }
        this.setEndPos(dataBuffer2, dataBuffer2.endOffset, this.flags);
    }

    public void setValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, int n3) {
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer;
        }
        this.setStartPos(dataBuffer, n);
        this.setEndPos(dataBuffer2, n2, n3);
    }

    public void setValues(XMLString xMLString) {
        if (xMLString != null && xMLString.firstBuffer != null) {
            this.bytes = xMLString.bytes;
            this.startOffset = xMLString.startOffset;
            this.endOffset = xMLString.endOffset;
            this.length = xMLString.length;
            this.flags = xMLString.flags;
            if (this.firstBuffer != xMLString.firstBuffer) {
                DataBuffer dataBuffer = xMLString.firstBuffer;
                if (dataBuffer != null) {
                    dataBuffer.addReference();
                    if (xMLString.lastBuffer != null) {
                        do {
                            dataBuffer = dataBuffer.next;
                            dataBuffer.addReference();
                        } while (dataBuffer != xMLString.lastBuffer);
                    }
                }
                if (this.firstBuffer != null) {
                    this.dropBufferReferences();
                }
                this.firstBuffer = xMLString.firstBuffer;
                this.lastBuffer = xMLString.lastBuffer;
            } else if (this.lastBuffer != xMLString.lastBuffer) {
                DataBuffer dataBuffer = this.firstBuffer;
                if (this.lastBuffer == null) {
                    do {
                        dataBuffer = dataBuffer.next;
                        dataBuffer.addReference();
                    } while (dataBuffer != xMLString.lastBuffer);
                } else if (xMLString.lastBuffer == null) {
                    DataBuffer dataBuffer2 = dataBuffer.next;
                    do {
                        dataBuffer = dataBuffer2;
                        dataBuffer2 = dataBuffer.next;
                        dataBuffer.removeReference();
                    } while (dataBuffer != this.lastBuffer);
                } else {
                    while (dataBuffer != this.lastBuffer && dataBuffer != xMLString.lastBuffer) {
                        dataBuffer = dataBuffer.next;
                    }
                    if (dataBuffer == this.lastBuffer) {
                        do {
                            dataBuffer = dataBuffer.next;
                            dataBuffer.addReference();
                        } while (dataBuffer != xMLString.lastBuffer);
                    } else {
                        DataBuffer dataBuffer3 = dataBuffer.next;
                        do {
                            dataBuffer = dataBuffer3;
                            dataBuffer3 = dataBuffer.next;
                            dataBuffer.removeReference();
                        } while (dataBuffer != this.lastBuffer);
                    }
                }
                this.lastBuffer = xMLString.lastBuffer;
            }
        } else {
            this.clear();
        }
    }

    public boolean isAllWhitespace() {
        if ((this.flags & 2) != 0) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            return false;
        }
        return this.checkWhitespace();
    }

    private boolean checkWhitespace() {
        if (this.length > 0) {
            int n;
            if (this.bytes != null) {
                for (n = this.startOffset; n < this.endOffset; ++n) {
                    byte by = this.bytes[n];
                    if (by == 32 || by == 10 || by == 9 || by == 13) {
                        continue;
                    }
                    this.flags |= 1;
                    return false;
                }
            } else {
                DataBuffer dataBuffer = this.firstBuffer;
                byte[] byArray = dataBuffer.bytes;
                int n2 = dataBuffer.endOffset;
                while (true) {
                    if (n < n2) {
                        byte by = byArray[n];
                        if (by == 32 || by == 10 || by == 9 || by == 13) {
                            ++n;
                            continue;
                        }
                        this.flags |= 1;
                        return false;
                    }
                    if (dataBuffer == this.lastBuffer) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    if (dataBuffer == this.lastBuffer) {
                        n2 = this.endOffset;
                        continue;
                    }
                    n2 = dataBuffer.endOffset;
                }
            }
        }
        this.flags |= 2;
        return true;
    }

    public boolean isNormalized() {
        byte by;
        if (this.length == 0) {
            return true;
        }
        if (this.bytes != null) {
            int n = this.startOffset;
            while (n < this.endOffset) {
                byte by2 = this.bytes[n];
                if (by2 < 0 || by2 > 32) {
                    while ((by2 < 0 || by2 > 32) && ++n < this.endOffset) {
                        by2 = this.bytes[n];
                    }
                    if (n >= this.endOffset || by2 >= 32 && ++n != this.endOffset) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n = this.startOffset;
        int n2 = dataBuffer.endOffset;
        while ((by = byArray[n]) < 0 || by > 32) {
            while (by < 0 || by > 32) {
                if (++n < n2) {
                    by = byArray[n];
                    continue;
                }
                if (dataBuffer == this.lastBuffer) {
                    return true;
                }
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                by = byArray[n];
            }
            if (by < 32) {
                return false;
            }
            if (++n != n2) continue;
            if (dataBuffer == this.lastBuffer) {
                return false;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n = dataBuffer.startOffset;
            if (dataBuffer == this.lastBuffer) {
                n2 = this.endOffset;
                continue;
            }
            n2 = dataBuffer.endOffset;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XMLString) {
            XMLString xMLString = (XMLString)object;
            if (this.length > 0 && this.length == xMLString.length) {
                if (this.bytes != null && xMLString.bytes != null) {
                    int n = this.length;
                    if (this.bytes[this.startOffset] != xMLString.bytes[xMLString.startOffset]) {
                        return false;
                    }
                    while (--n > 0) {
                        if (this.bytes[this.startOffset + n] == xMLString.bytes[xMLString.startOffset + n]) continue;
                        return false;
                    }
                    return true;
                }
                DataBuffer dataBuffer = this.firstBuffer;
                DataBuffer dataBuffer2 = xMLString.firstBuffer;
                byte[] byArray = dataBuffer.bytes;
                int n = this.startOffset;
                byte[] byArray2 = dataBuffer2.bytes;
                int n2 = xMLString.startOffset;
                if (byArray[n] != byArray2[n2]) {
                    return false;
                }
                DataBuffer dataBuffer3 = this.lastBuffer != null ? this.lastBuffer : dataBuffer;
                DataBuffer dataBuffer4 = xMLString.lastBuffer != null ? xMLString.lastBuffer : dataBuffer2;
                int n3 = this.lastBuffer != null ? dataBuffer.endOffset : this.endOffset;
                int n4 = xMLString.lastBuffer != null ? dataBuffer2.endOffset : xMLString.endOffset;
                int n5 = this.length;
                while (--n5 > 0) {
                    if (++n == n3) {
                        dataBuffer = dataBuffer.next;
                        byArray = dataBuffer.bytes;
                        n = dataBuffer.startOffset;
                        int n6 = n3 = dataBuffer != dataBuffer3 ? dataBuffer.endOffset : this.endOffset;
                    }
                    if (++n2 == n4) {
                        dataBuffer2 = dataBuffer2.next;
                        byArray2 = dataBuffer2.bytes;
                        n2 = dataBuffer2.startOffset;
                        int n7 = n4 = dataBuffer2 != dataBuffer4 ? dataBuffer2.endOffset : xMLString.endOffset;
                    }
                    if (byArray[n] == byArray2[n2]) continue;
                    return false;
                }
                return true;
            }
            return this.length == xMLString.length;
        }
        return false;
    }

    public int hashCode() {
        if (this.length == 0) {
            return 0;
        }
        int n = 0;
        if (this.bytes != null) {
            for (int i = this.startOffset; i < this.endOffset; ++i) {
                n = n * 31 + (this.bytes[i] & 0xFF);
            }
            return n;
        }
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n2 = this.startOffset;
        DataBuffer dataBuffer2 = this.lastBuffer != null ? this.lastBuffer : dataBuffer;
        int n3 = this.lastBuffer != null ? dataBuffer.endOffset : this.endOffset;
        while (true) {
            for (int i = n2; i < n3; ++i) {
                n = n * 31 + (byArray[i] & 0xFF);
            }
            if (dataBuffer == dataBuffer2) {
                return n;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : this.endOffset;
        }
    }

    public void normalizeLineBreaks(XMLStringBuffer xMLStringBuffer) {
        if (this.firstBuffer != null && (this.flags & 4) != 0) {
            int n = xMLStringBuffer.getOffset();
            xMLStringBuffer.appendXMLString(this);
            xMLStringBuffer.setStringValues(n, xMLStringBuffer.getOffset(), this);
        }
    }

    public CharConversionError getChars(char[][] cArray, int[] nArray) {
        if (this.firstBuffer != null) {
            if ((this.flags & 4) != 0) {
                return UTF8Support.normalizeBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray);
            }
            return UTF8Support.convertBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray);
        }
        return null;
    }

    public String toString() {
        CharConversionError charConversionError = this.convertToChars();
        if (charConversionError == null) {
            return new String(this.fConvertedChars[0], 0, this.fConvertedCharsOffset[0]);
        }
        return null;
    }

    protected final CharConversionError convertToChars() {
        if (this.fConvertedChars == null) {
            int n;
            for (n = 16; n < this.length; n <<= 1) {
            }
            this.fConvertedChars = new char[1][];
            this.fConvertedChars[0] = new char[n];
            this.fConvertedCharsOffset = new int[1];
        }
        this.fConvertedCharsOffset[0] = 0;
        return this.getChars(this.fConvertedChars, this.fConvertedCharsOffset);
    }
}

