/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.scan.util.ErrorReporter;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;

public final class NamespaceContext {
    private static final int NSMAPPING_PREFIX = 0;
    private static final int NSMAPPING_NSURI = 1;
    private static final int NSMAPPING_QNAME = 2;
    private static final int NSMAPPING_SIZE = 3;
    private static final int NSCONTEXT_FIRST_MAPPING = 0;
    private static final int NSCONTEXT_LAST_MAPPING = 1;
    private static final int NSCONTEXT_PARENT_CONTEXT = 2;
    private static final int NSCONTEXT_SIZE = 3;
    private static final int NSSCOPE_FIRST_MAPPING = 0;
    private static final int NSSCOPE_LAST_MAPPING = 1;
    private static final int NSSCOPE_SIZE = 2;
    private ErrorReporter fReporter;
    private SymbolTable fSymbolTable;
    private XMLString fErrorString;
    private int[] fContexts;
    private int fNextContext;
    private int fCurrentContext;
    private int[] fMappings;
    private int fNextMapping;
    private int fFirstMapping;
    private int fLastMapping;
    private int fCurrentScope;
    private int[] fMappingScopes;
    private int fTopDefaultNamespaceMapping;

    public NamespaceContext(ErrorReporter errorReporter, SymbolTable symbolTable) {
        this.fReporter = errorReporter;
        this.fSymbolTable = symbolTable;
        this.fErrorString = new XMLString();
        this.fContexts = new int[8];
        this.fMappings = new int[32];
        this.fMappingScopes = new int[8];
    }

    public void initialize() {
        this.fTopDefaultNamespaceMapping = -1;
        this.fMappings[0] = 2;
        this.fMappings[1] = 4;
        this.fMappings[2] = -1;
        this.fFirstMapping = 0;
        this.fNextMapping = 3;
        this.fLastMapping = 3;
        this.fCurrentContext = 0;
        this.fContexts[0] = 0;
        this.fContexts[1] = 3;
        this.fContexts[2] = -1;
        this.fNextContext = 3;
        this.fCurrentScope = 0;
        this.fMappingScopes[0] = 0;
        this.fMappingScopes[1] = 3;
    }

    public int startNamespacesScope() {
        if (this.fLastMapping != this.fFirstMapping) {
            int n = this.fCurrentContext;
            this.fCurrentContext = this.fNextContext;
            this.fNextContext += 3;
            if (this.fNextContext >= this.fContexts.length) {
                this.growContexts();
            }
            this.fContexts[this.fCurrentContext + 2] = n;
            this.fContexts[this.fCurrentContext + 1] = this.fNextMapping;
            this.fContexts[this.fCurrentContext + 0] = this.fNextMapping;
        }
        this.fCurrentScope += 2;
        if (this.fCurrentScope == this.fMappingScopes.length) {
            this.growScopes();
        }
        this.fMappingScopes[this.fCurrentScope + 0] = this.fNextMapping;
        this.fMappingScopes[this.fCurrentScope + 1] = this.fNextMapping;
        this.fFirstMapping = this.fLastMapping = this.fNextMapping;
        return this.fCurrentContext;
    }

    public int currentContext() {
        return this.fCurrentContext;
    }

    public int endNamespacesScope() {
        boolean bl = this.fLastMapping != this.fFirstMapping;
        int n = this.fCurrentContext;
        this.fCurrentScope -= 2;
        this.fFirstMapping = this.fMappingScopes[this.fCurrentScope + 0];
        this.fLastMapping = this.fMappingScopes[this.fCurrentScope + 1];
        if (this.fLastMapping != this.fFirstMapping || bl) {
            this.fCurrentContext = this.fContexts[this.fCurrentContext + 2];
        }
        if (this.fTopDefaultNamespaceMapping >= this.fLastMapping) {
            this.fTopDefaultNamespaceMapping = this.lookupCurrentDefaultMapping();
        }
        return n;
    }

    private void growScopes() {
        int[] nArray = new int[this.fCurrentScope << 1];
        System.arraycopy(this.fMappingScopes, 0, nArray, 0, this.fCurrentScope);
        this.fMappingScopes = nArray;
    }

    private int lookupCurrentDefaultMapping() {
        int n = this.fCurrentScope;
        int n2 = this.fFirstMapping;
        int n3 = this.fLastMapping;
        while (true) {
            for (int i = n3 - 3; i >= n2; i -= 3) {
                if (this.fMappings[i + 0] != 0) continue;
                return i;
            }
            if (n <= 0) break;
            n2 = this.fMappingScopes[(n -= 2) + 0];
            n3 = this.fMappingScopes[n + 1];
        }
        return -1;
    }

    private void throwAIOOBException(String string) {
        throw new ArrayIndexOutOfBoundsException(string);
    }

    public int nsDeclCount(int n) {
        return (this.fContexts[n + 1] - this.fContexts[n + 0]) / 3;
    }

    public int nsDeclPrefix(int n, int n2) {
        if (n2 >= 0 && n2 < this.nsDeclCount(n)) {
            return this.fMappings[this.fContexts[n + 0] + n2 * 3 + 0];
        }
        this.throwAIOOBException("nsDeclPrefix");
        return -1;
    }

    public int nsDeclURI(int n, int n2) {
        if (n2 >= 0 && n2 < this.nsDeclCount(n)) {
            return this.fMappings[this.fContexts[n + 0] + n2 * 3 + 1];
        }
        this.throwAIOOBException("nsDeclURI");
        return -1;
    }

    public void setNSDeclURI(int n, int n2, int n3) {
        if (n2 >= 0 && n2 < this.nsDeclCount(n)) {
            this.fMappings[this.fContexts[n + 0] + n2 * 3 + 1] = n3;
        } else {
            this.throwAIOOBException("setNSDeclURI");
        }
    }

    public int nsDeclQName(int n, int n2) {
        if (n2 >= 0 && n2 < this.nsDeclCount(n)) {
            return this.fMappings[this.fContexts[n + 0] + n2 * 3 + 2];
        }
        this.throwAIOOBException("nsDeclQName");
        return -1;
    }

    public int prefixMapping(int n, int n2) {
        while (true) {
            int n3 = this.fContexts[n + 0];
            int n4 = this.fContexts[n + 1];
            for (int i = n4 - 3; i >= n3; i -= 3) {
                if (this.fMappings[i + 0] != n2) continue;
                return this.fMappings[i + 1];
            }
            if (n <= 0) break;
            n = this.fContexts[n + 2];
        }
        return -1;
    }

    public int totalMappingsCount(int n) {
        int n2 = 0;
        while (true) {
            n2 += (this.fContexts[n + 1] - this.fContexts[n + 0]) / 3;
            if (n <= 0) break;
            n = this.fContexts[n + 2];
        }
        return n2;
    }

    public int inScopeNamespaces(int n, int[] nArray) {
        int n2 = 0;
        while (true) {
            int n3 = this.fContexts[n + 0];
            int n4 = this.fContexts[n + 1];
            for (int i = n4 - 3; i >= n3; i -= 3) {
                int n5 = this.fMappings[i + 0];
                boolean bl = false;
                for (int j = 0; j < n2; j += 2) {
                    if (nArray[j] != n5) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                nArray[n2++] = n5;
                nArray[n2++] = this.fMappings[i + 1];
            }
            if (n <= 0) break;
            n = this.fContexts[n + 2];
        }
        return n2 >> 1;
    }

    public boolean createPrefixMapping(int n, XMLString xMLString, int n2) {
        int n3;
        int n4 = this.fSymbolTable.addSymbol(xMLString);
        if (n != 0) {
            if (n4 == 0) {
                return this.namespaceNameEmpty(n);
            }
            if (n == 1) {
                return this.fReporter.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 54);
            }
        } else {
            this.fTopDefaultNamespaceMapping = this.fNextMapping;
        }
        if (n4 == 4) {
            if (n != 2) {
                return this.illegalNamespaceURI(n, xMLString);
            }
        } else {
            if (n == 2) {
                return this.fReporter.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 51);
            }
            if (n4 == 3) {
                return this.illegalNamespaceURI(n, xMLString);
            }
        }
        this.fNextMapping += 3;
        if (this.fNextMapping >= this.fMappings.length) {
            this.growNamespaces();
        }
        this.fMappings[this.fLastMapping + 0] = n;
        this.fMappings[this.fLastMapping + 1] = n4;
        this.fMappings[this.fLastMapping + 2] = n2;
        this.fMappingScopes[this.fCurrentScope + 1] = this.fNextMapping;
        if (this.fLastMapping == this.fFirstMapping && this.fMappingScopes[(n3 = this.fCurrentScope - 2) + 1] == this.fMappingScopes[n3 + 0]) {
            int n5 = this.fCurrentContext;
            this.fCurrentContext = this.fNextContext;
            this.fNextContext += 3;
            if (this.fNextContext >= this.fContexts.length) {
                this.growContexts();
            }
            this.fContexts[this.fCurrentContext + 2] = n5;
            this.fContexts[this.fCurrentContext + 0] = this.fFirstMapping;
        }
        this.fContexts[this.fCurrentContext + 1] = this.fLastMapping = this.fNextMapping;
        return true;
    }

    private void growNamespaces() {
        int n = this.fMappings.length << 1;
        int[] nArray = new int[n];
        System.arraycopy(this.fMappings, 0, nArray, 0, this.fMappings.length);
        this.fMappings = nArray;
    }

    private void growContexts() {
        int n = this.fContexts.length << 1;
        int[] nArray = new int[n];
        System.arraycopy(this.fContexts, 0, nArray, 0, this.fContexts.length);
        this.fContexts = nArray;
    }

    private boolean namespaceNameEmpty(int n) {
        this.fSymbolTable.setStringValues(n, this.fErrorString);
        this.fReporter.setParameter(0, this.fErrorString);
        return this.fReporter.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 52);
    }

    private boolean illegalNamespaceURI(int n, XMLString xMLString) {
        this.fSymbolTable.setStringValues(n, this.fErrorString);
        this.fReporter.setParameter(0, this.fErrorString);
        this.fReporter.setParameter(1, xMLString);
        return this.fReporter.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 53);
    }

    public boolean setNamespaceURI(int n, QName qName) {
        int n2 = qName.prefixHandle;
        if (n2 == 0 && this.fTopDefaultNamespaceMapping < 0) {
            qName.nsHandle = 0;
            return true;
        }
        int n3 = this.prefixMapping(n, n2);
        if (n3 >= 0) {
            qName.nsHandle = n3;
            return true;
        }
        return false;
    }

    public boolean checkDuplicateNamespaces(QName qName) {
        for (int i = this.fFirstMapping; i < this.fLastMapping - 3; i += 3) {
            int n = this.fMappings[i + 0];
            for (int j = i + 3; j < this.fLastMapping; j += 3) {
                if (this.fMappings[j + 0] != n) continue;
                return this.duplicateNSDecl(qName, this.fMappings[i + 2]);
            }
        }
        return true;
    }

    private boolean duplicateNSDecl(QName qName, int n) {
        qName.shareValues(this.fErrorString);
        this.fReporter.setParameter(0, this.fErrorString);
        this.fSymbolTable.setStringValues(n, this.fErrorString);
        this.fReporter.setParameter(1, this.fErrorString);
        return this.fReporter.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 17);
    }
}

