/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.wsspi.management.commands.server.ServerCommandBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateServer
extends ServerCommandBase {
    private static TraceComponent tc = Tr.register(CreateServer.class, "CreateServer", "com.ibm.wsspi.management.commands.server");
    private ObjectName matchTemplate = null;
    private String serverTypeSave = null;

    public CreateServer(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void taskCommandExecuted(boolean bl) {
        block5: {
            if (!bl) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                try {
                    ObjectName objectName = (ObjectName)this.getCommandResult().getResult();
                    if (objectName == null) break block5;
                    if (configService != null) {
                        configService.deleteConfigData(session, objectName);
                        break block5;
                    }
                    String string = "Cannot delete config data: no config service created yet for this process";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "taskCommandExecuted", string);
                    }
                    throw new ConfigServiceException(string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", "86");
                }
            }
        }
    }

    public void beforeStepsExecuted() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            ObjectName objectName;
            block32: {
                Session session;
                ConfigService configService;
                block31: {
                    String string;
                    configService = ConfigServiceFactory.getConfigService();
                    if (configService == null) {
                        String string2 = "No config service created yet for this process";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "beforeStepsExecuted", string2);
                        }
                        throw new ConfigServiceException(string2);
                    }
                    session = this.getConfigSession();
                    String string3 = (String)this.getTargetObject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node Name: " + string3);
                    }
                    String string4 = (String)this.getParameter("name");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Name: " + string4);
                    }
                    if ((string = this.serverTypeSave) == null) {
                        this.serverTypeSave = string = this.getServerType(string3);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Type: " + string);
                    }
                    String string5 = (String)this.getParameter("genericShortName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Generic Short Name: " + string5);
                    }
                    if (string5 != null && !this.isShortNameValid(string5, this.getName())) {
                        throw new InvalidParameterValueException(this.getName(), "genericShortName", string5);
                    }
                    String string6 = (String)this.getParameter("specificShortName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Specific Short Name: " + string6);
                    }
                    if (string6 != null && !this.isShortNameValid(string6, this.getName())) {
                        throw new InvalidParameterValueException(this.getName(), "specificShortName", string6);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " use Template:" + this.matchTemplate);
                    }
                    Boolean bl = (Boolean)this.getParameter("genUniquePorts");
                    boolean bl2 = true;
                    if (bl != null) {
                        bl2 = bl;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Generate Unique Ports: " + bl2);
                    }
                    ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result from ConfigService: " + objectNameArray);
                    }
                    if (objectNameArray.length == 0) {
                        String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0250E", new Object[]{string3}, null);
                        throw new ConfigServiceException(string7);
                    }
                    objectName = null;
                    try {
                        Method method = this.implClass.getMethod("createServer", Session.class, ObjectName.class, String.class, ObjectName.class, Boolean.TYPE);
                        objectName = (ObjectName)method.invoke(null, this.getConfigSession(), objectNameArray[0], string4, this.matchTemplate, bl2 ? Boolean.TRUE : Boolean.FALSE);
                        method = this.templateConfigHelperClass.getMethod("updateTemplateMetadata", ConfigService.class, Session.class, ObjectName.class, String.class);
                        method.invoke(null, configService, this.getConfigSession(), objectName, string4);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getTargetException();
                    }
                    try {
                        if (string6 != null) {
                            this.changeServerSpecificShortName(configService, session, string4, string3, string6);
                        }
                        if (string5 != null) {
                            this.changeServerGenericShortName(configService, session, string4, string3, string5);
                        }
                    }
                    catch (Throwable throwable) {
                        if (objectName == null) break block31;
                        try {
                            Method method = this.implClass.getMethod("deleteServer", Session.class, String.class, String.class);
                            method.invoke(null, session, string3, string4);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw invocationTargetException.getTargetException();
                        }
                    }
                }
                if (System.getProperty("os.name").equals("OS/400")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "os.name is " + System.getProperty("os.name"));
                    }
                    try {
                        this.updateIPv6(configService, session, objectName);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!tc.isDebugEnabled()) break block32;
                        Tr.debug(tc, "Exception caught updating server for IPv6", exception);
                    }
                }
            }
            taskCommandResultImpl.setResult(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server created", objectName);
            }
        }
        catch (Throwable throwable) {
            taskCommandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void updateIPv6(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "determine if property fix required for IPv6 on i5/OS");
            Tr.debug(tc, "os.version is " + System.getProperty("os.version"));
        }
        if (System.getProperty("os.version").startsWith("V5R4")) {
            String string = System.getProperty("java.net.preferIPv4Stack");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value of java.net.preferIPv4Stack system property is " + string);
            }
            if (string != null && string.equals("false")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "add IPv6 system property to server");
                }
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
                ObjectName objectName3 = configService.queryConfigObjects(session, objectName, objectName2, null)[0];
                AttributeList attributeList = configService.getAttributes(session, objectName3, new String[]{"jvmEntries"}, false);
                ObjectName objectName4 = (ObjectName)((List)ConfigServiceHelper.getAttributeValue(attributeList, "jvmEntries")).get(0);
                AttributeList attributeList2 = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attributeList2, "name", "java.net.preferIPv4Stack");
                ConfigServiceHelper.setAttributeValue(attributeList2, "value", "false");
                ObjectName objectName5 = configService.createConfigData(session, objectName4, "systemProperties", "Property", attributeList2);
            }
        }
    }

    private String getServerType(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType");
        }
        String string2 = null;
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("listServerTypes");
        adminCommand.setConfigSession(this.getConfigSession());
        adminCommand.setTargetObject(string);
        adminCommand.execute();
        List list = (List)adminCommand.getCommandResult().getResult();
        String string3 = this.getCommandMetadata().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandName", string3);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            AdminCommand adminCommand2 = commandMgr.createCommand("showServerTypeInfo");
            adminCommand2.setConfigSession(this.getConfigSession());
            adminCommand2.setTargetObject(string4);
            adminCommand2.execute();
            AttributeList attributeList = (AttributeList)adminCommand2.getCommandResult().getResult();
            Object object = ConfigServiceHelper.getAttributeValue(attributeList, "createCommand");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createCommandName", object);
            }
            if (!string3.equals(object)) continue;
            string2 = string4;
            break;
        }
        if (string2 == null) {
            FFDCFilter.processException(new Exception(), "com.ibm.ws.management.commands.server.CreateServer.getServerType", "208");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", string2);
        }
        return string2;
    }

    protected List getTemplates(boolean bl) {
        List list;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTemplate, " + bl);
            }
            list = Collections.EMPTY_LIST;
            try {
                String string;
                Session session = this.getConfigSession();
                String string2 = (String)this.getTargetObject();
                String string3 = (String)this.getParameter("templateName");
                String string4 = this.serverTypeSave;
                if (string4 == null) {
                    this.serverTypeSave = string4 = this.getServerType(string2);
                }
                String[] stringArray = null;
                stringArray = !bl ? new String[3] : new String[2];
                boolean bl2 = this.metadataHelper.isNodeZOS(string2);
                if (bl2) {
                    stringArray[0] = "com.ibm.websphere.nodeOperatingSystem=os390";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ZOS Platform Query", stringArray);
                    }
                } else {
                    stringArray[0] = "com.ibm.websphere.nodeOperatingSystem!=os390";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Distributed Platform Query", stringArray);
                    }
                }
                if (!bl) {
                    stringArray[1] = string3 == null || string3.equals("") ? "isDefaultTemplate=true" : "name=" + string3;
                }
                string = (string = this.metadataHelper.getNodeBaseProductVersion(string2)).startsWith("6.1") ? "6.1" : this.metadataHelper.getNodeMajorVersion(string2);
                if (!bl) {
                    stringArray[2] = "com.ibm.websphere.baseProductMajorVersion=" + string;
                } else {
                    stringArray[1] = "com.ibm.websphere.baseProductMajorVersion=" + string;
                }
                list = string == null ? this.listServerTemplates(string4, null, null) : this.listServerTemplates(string4, stringArray, string2);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", "268");
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception occured during getChoices", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplate", list);
        }
        return list;
    }

    public Object[] getChoices(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", string);
        }
        String[] stringArray = null;
        if (string.equals("templateName")) {
            List list = this.getTemplates(true);
            stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ObjectName objectName = (ObjectName)list.get(i);
                stringArray[i] = ConfigServiceHelper.getDisplayName(objectName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", stringArray);
        }
        return stringArray;
    }

    public void validate() throws CommandValidationException {
        Object object;
        int n;
        int n2;
        Object object2;
        String string;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate, ");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        if (configService == null) {
            String string2 = "No config service created yet for this process";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate", string2);
            }
            ConfigServiceException configServiceException = new ConfigServiceException(string2);
            throw new CommandValidationException(configServiceException, "Cannot validate the command parameters.");
        }
        Session session = this.getConfigSession();
        ObjectName[] objectNameArray = null;
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "CellManager");
        try {
            objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        }
        catch (ConfigServiceException configServiceException) {
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
        if (objectNameArray != null && objectNameArray.length > 0 && (object4 = ((Properties)(object3 = ConfigServiceHelper.getObjectLocation(objectNameArray[0]))).getProperty("node")) != null && (string = (String)this.getTargetObject()) != null && ((String)object4).equals(string)) {
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0250E", new Object[]{object4}, null);
            throw new CommandValidationException(string3);
        }
        object3 = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Name: " + (String)object3);
        }
        try {
            object4 = configService.resolve(session, "Node=" + (String)object3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result from ConfigService: " + object4);
            }
            if (((ObjectName[])object4).length == 0) {
                string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0250E", new Object[]{object3}, null);
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0254E", new Object[]{configServiceException}, null);
            throw new CommandValidationException(configServiceException, string);
        }
        catch (ConnectorException connectorException) {
            string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0254E", new Object[]{connectorException}, null);
            throw new CommandValidationException(connectorException, string);
        }
        object4 = (String)this.getParameter("name");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Name: " + (String)object4);
        }
        if (((String)object4).length() == 0) {
            string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0247E", new Object[]{object4}, null);
            throw new CommandValidationException(string);
        }
        boolean bl = ConfigServiceHelper.checkIfNameValid(((String)object4).trim());
        if (!bl) {
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0249E", new Object[]{object4}, null);
            throw new CommandValidationException(string4);
        }
        try {
            object2 = configService.resolve(session, "Node=" + (String)object3 + ":Server=" + (String)object4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result from ConfigService: " + object2);
            }
            if (((ObjectName[])object2).length != 0) {
                String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0248E", new Object[]{object4, object3}, null);
                throw new CommandValidationException(string5);
            }
        }
        catch (ConfigServiceException configServiceException) {
            String string6 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0254E", new Object[]{configServiceException}, null);
            throw new CommandValidationException(configServiceException, string6);
        }
        catch (ConnectorException connectorException) {
            String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0254E", new Object[]{connectorException}, null);
            throw new CommandValidationException(connectorException, string7);
        }
        object2 = null;
        String string8 = (String)this.getParameter("templateName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Template Name: " + string8);
        }
        this.matchTemplate = null;
        ObjectName objectName2 = (ObjectName)this.getParameter("templateLocation");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "templateLocation", objectName2);
        }
        object2 = objectName2 != null ? this.getTemplate(objectName2, string8) : this.getTemplates(false);
        int n3 = 0;
        for (n2 = 0; object2 != null && n2 < object2.size(); ++n2) {
            n = this.getMatchCount((ObjectName)object2.get(n2), (String)object3);
            if (n < n3) continue;
            n3 = n;
            this.matchTemplate = (ObjectName)object2.get(n2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching template", this.matchTemplate);
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "found matching template", new Integer(n3));
        }
        if (string8 != null || objectName2 != null) {
            try {
                if (this.serverTypeSave == null) {
                    this.serverTypeSave = this.getServerType((String)object3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 = this.getDefaultTemplateMatchCount(this.serverTypeSave, (String)object3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "match count ", new Integer(n3) + " " + new Integer(n2));
            }
            if (n2 > n3) {
                this.matchTemplate = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no matching template", new Integer(n2) + " " + new Integer(n3));
                }
            }
        }
        if (object2 == null || object2.size() == 0 || this.matchTemplate == null) {
            String string9 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0253E", new Object[]{string8}, null);
            throw new CommandValidationException(string9);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " matchTemplate", this.matchTemplate);
        }
        if ((object = this.getParameter("genUniquePorts")) != null && object instanceof Boolean) {
            n = 1;
            if (object != null) {
                n = ((Boolean)object).booleanValue() ? 1 : 0;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Generate Unique Ports: " + (n != 0));
            }
        }
    }

    private void changeServerSpecificShortName(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerSpecificShortName", string3);
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("changeServerSpecificShortName");
        adminCommand.setConfigSession(session);
        adminCommand.setParameter("nodeName", string2);
        adminCommand.setParameter("serverName", string);
        adminCommand.setParameter("specificShortName", string3);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (!commandResult.isSuccessful()) {
            Object object = commandResult.getResult();
            if (object != null && object instanceof String) {
                throw new Exception((String)object, commandResult.getException());
            }
            throw new Exception(commandResult.getException());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerSpecificShortName", string3);
        }
    }

    private void changeServerGenericShortName(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerGenericShortName", string3);
        }
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("changeServerGenericShortName");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("nodeName", string2);
            adminCommand.setParameter("serverName", string);
            adminCommand.setParameter("genericShortName", string3);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Object object = commandResult.getResult();
                if (object != null && object instanceof String) {
                    throw new Exception((String)object, commandResult.getException());
                }
                throw new Exception(commandResult.getException());
            }
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerGenericShortName", string3);
        }
    }

    private boolean isShortNameValid(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isShortNameValid", string + " " + string2);
        }
        boolean bl = true;
        if (string.length() > 8) {
            bl = false;
        } else if (!AdminHelper.getPlatformHelper().isZOS()) {
            bl = false;
        } else if (!(string2.equals("createApplicationServer") || string2.equals("createProxyServer") || string2.equals("createOnDemandRouter"))) {
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checking for alpha numberic only ", string);
        }
        for (int i = 0; string != null && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 && Character.isDigit(c)) {
                bl = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "First letter is digit ", string);
                break;
            }
            if (!Character.isLetterOrDigit(c)) {
                bl = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Not letter or digit ", string);
                break;
            }
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            bl = false;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Not Uppercase letter ", string);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isShortNameValid", new Boolean(bl));
        }
        return bl;
    }
}

