/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.Iterator;
import java.util.List;

public class QuiesceRule
implements SelectionRule {
    private static final TraceComponent tc = Tr.register(QuiesceRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final DescriptionKey clusterKey;
    private ClusterDescription myClusterDescription = null;
    private RuleArbitrator arbitrator = null;

    public QuiesceRule(Identity identity) {
        this.clusterKey = (DescriptionKey)identity;
        this.myClusterDescription = (ClusterDescription)descMgr.getDescription(this.clusterKey);
    }

    public void subset(List list, StringBuffer stringBuffer) {
        if (this.myClusterDescription == null) {
            this.myClusterDescription = (ClusterDescription)descMgr.getDescription(this.clusterKey);
            if (this.myClusterDescription == null) {
                return;
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            ClusterDescription.Memento memento = (ClusterDescription.Memento)this.myClusterDescription.getMemento();
            if (!memento.isQuiesced(identity)) continue;
            iterator.remove();
            stringBuffer.append(identity);
            stringBuffer.append(" removed: Member is quiesced. ");
        }
    }

    public void registerRuleArbitrator(RuleArbitrator ruleArbitrator) {
        this.arbitrator = ruleArbitrator;
        this.arbitrator.registerNotificationType(this, this.clusterKey, "type.quiesce.state.changed");
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.5 ");
        }
    }
}

