/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wswebcontainer.webapp.WebApp;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class PortURIManager {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.PortURIManager";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PortURIManager.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    protected static PortURIManager _PortURIManager = null;
    private static final String IMPL_CLASSNAME = "com.ibm.ws.wsaddressing.urimap.PortURIManagerImpl";

    private static void traceAndFFDCException(Exception exception) {
        String string = exception.getClass().getName();
        String string2 = exception.getMessage();
        Object[] objectArray = new Object[]{string, string2};
        String string3 = "Caught a " + string + ": " + string2 + " when trying to create a new concrete PortURIManager instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, string3);
        FFDCFilter.processException(exception, CLASSNAME, "1:1.10:98");
    }

    protected abstract void addApplicationPortMappingsImpl(WebApp var1, Map var2);

    protected abstract void removeApplicationPortMappingsImpl(String var1);

    protected abstract URI getSOAPAddressForPortImpl(String var1, QName var2) throws URIGenerationException;

    protected abstract String getVirtualHostForPortImpl(String var1, QName var2) throws EndpointReferenceCreationException;

    protected abstract boolean intermediaryConfiguredImpl(String var1, QName var2) throws EndpointReferenceCreationException;

    protected abstract void addSysAppPortMappingsImpl(String var1, String var2, QName var3, String var4);

    protected abstract void addApplicationSecurityDataImpl(MetaDataEvent var1);

    public static void addApplicationPortMappings(WebApp webApp, Map map) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addApplicationPortMappings", new Object[]{webApp, map});
        }
        if (_PortURIManager != null) {
            _PortURIManager.addApplicationPortMappingsImpl(webApp, map);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addApplicationPortMappings");
        }
    }

    public static void addApplicationSecurityData(MetaDataEvent metaDataEvent) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addApplicationSecurityData", new Object[]{metaDataEvent});
        }
        if (_PortURIManager != null) {
            _PortURIManager.addApplicationSecurityDataImpl(metaDataEvent);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addApplicationSecurityData");
        }
    }

    public static void addSysAppPortMappings(String string, String string2, QName qName, String string3) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addSysAppPortMappings", new Object[]{string, string2, string3});
        }
        if (_PortURIManager != null) {
            _PortURIManager.addSysAppPortMappingsImpl(string, string2, qName, string3);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addSysAppPortMappings");
        }
    }

    public static void removeApplicationPortMappings(String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeApplicationPortMappings", new Object[]{string});
        }
        if (_PortURIManager != null) {
            _PortURIManager.removeApplicationPortMappingsImpl(string);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeApplicationPortMappings");
        }
    }

    public static URI getSOAPAddressForPort(String string, QName qName) throws URIGenerationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPAddressForPort", new Object[]{string, qName});
        }
        URI uRI = null;
        if (_PortURIManager != null) {
            uRI = _PortURIManager.getSOAPAddressForPortImpl(string, qName);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", uRI);
        }
        return uRI;
    }

    public static String getVirtualHostForPort(String string, QName qName) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForPort", new Object[]{string, qName});
        }
        String string2 = null;
        if (_PortURIManager != null) {
            string2 = _PortURIManager.getVirtualHostForPortImpl(string, qName);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", string2);
        }
        return string2;
    }

    public static boolean intermediaryConfigured(String string, QName qName) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intermediaryConfigured", new Object[]{string, qName});
        }
        boolean bl = false;
        if (_PortURIManager != null) {
            bl = _PortURIManager.intermediaryConfiguredImpl(string, qName);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", bl ? "true" : "false");
        }
        return bl;
    }

    static {
        PortURIManager portURIManager = null;
        try {
            portURIManager = (PortURIManager)Class.forName(IMPL_CLASSNAME).newInstance();
        }
        catch (InstantiationException instantiationException) {
            PortURIManager.traceAndFFDCException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            PortURIManager.traceAndFFDCException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            PortURIManager.traceAndFFDCException(classNotFoundException);
        }
        _PortURIManager = portURIManager;
    }
}

