/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;

public abstract class MessageIDGenerator {
    private static MessageIDGenerator _messageIDGenerator = null;
    private static final String MESSAGE_ID_GENERATOR_CLASS = "com.ibm.ws.wsaddressing.handlers.MessageIDGeneratorImpl";
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.MessageIDGenerator";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(MessageIDGenerator.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public static String newMessageIDAsString() {
        return _messageIDGenerator.concreteNewMessageIDAsString();
    }

    protected abstract String concreteNewMessageIDAsString();

    private static void traceAndFFDCException(Exception exception) {
        String string = exception.getClass().getName();
        String string2 = exception.getMessage();
        String string3 = "Caught a " + string + ": " + string2 + " when trying to create a new " + MESSAGE_ID_GENERATOR_CLASS + " instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, string3);
        FFDCFilter.processException(exception, CLASSNAME, "1:1.4:103");
    }

    static {
        try {
            _messageIDGenerator = (MessageIDGenerator)Class.forName(MESSAGE_ID_GENERATOR_CLASS).newInstance();
        }
        catch (InstantiationException instantiationException) {
            MessageIDGenerator.traceAndFFDCException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageIDGenerator.traceAndFFDCException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageIDGenerator.traceAndFFDCException(classNotFoundException);
        }
    }
}

