/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.WSDLMAPAccessor;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public class WSDLMAPAccessorImpl
implements WSDLMAPAccessor {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLMAPAccessorImpl.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private Definition _wsdlDefinition;
    private QName _serviceName;
    private String _endpointName;
    private Service _service;
    private Port _port;
    private Binding _binding;
    private Boolean _isUsingAddressingRequired;

    public WSDLMAPAccessorImpl() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSDLMAPAccessorImpl");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSDLMAPAccessorImpl", this);
        }
    }

    public void resetEndpoint(Definition definition, QName qName, String string) throws WSDLException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "resetEndpoint", new Object[]{definition, qName, string});
        }
        this._wsdlDefinition = definition;
        this._serviceName = qName;
        this._endpointName = string;
        this._service = this._wsdlDefinition.getService(qName);
        if (this._service == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "The service specified was not found in the wsdl definition", qName);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resetEndpoint");
            }
            throw new WSDLException("CONFIGURATION_ERROR", "Service not found in wsdl definition");
        }
        this._port = this._service.getPort(this._endpointName);
        if (this._port == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "The endpoint specified was not found in the wsdl definition for the service", new Object[]{string, qName});
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resetEndpoint");
            }
            throw new WSDLException("CONFIGURATION_ERROR", "Endpoint not found for service specified");
        }
        this._binding = this._port.getBinding();
        if (this._binding == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "No binding was found for the endpoint specified", string);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resetEndpoint");
            }
            throw new WSDLException("CONFIGURATION_ERROR", "No binding was found for endpoint specified");
        }
        this.resetUsingAddressingRequired();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "resetEndpoint");
        }
    }

    public Boolean isUsingAddressingRequired() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isUsingAddressingRequired");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isUsingAddressingRequired", this._isUsingAddressingRequired);
        }
        return this._isUsingAddressingRequired;
    }

    private void resetUsingAddressingRequired() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "resetUsingAddressingRequired");
        }
        this._isUsingAddressingRequired = null;
        List list = this._binding.getExtensibilityElements();
        Iterator iterator = list.iterator();
        ExtensibilityElement extensibilityElement = null;
        while (iterator.hasNext()) {
            extensibilityElement = (ExtensibilityElement)iterator.next();
            QName qName = extensibilityElement.getElementType();
            if (!"UsingAddressing".equals(qName.getLocalPart()) || !"http://www.w3.org/2006/05/addressing/wsdl".equals(qName.getNamespaceURI()) && !"http://www.w3.org/2006/02/addressing/wsdl".equals(qName.getNamespaceURI())) continue;
            this._isUsingAddressingRequired = extensibilityElement.getRequired();
            break;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "resetUsingAddressingRequired", this._isUsingAddressingRequired);
        }
    }
}

