/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaWriter;
import com.ibm.ws.webservices.wsdl.toJava.Namespaces;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class JavaClassWriter
extends JavaWriter {
    protected Namespaces namespaces;
    protected String className;
    protected String packageName;

    protected JavaClassWriter(Emitter emitter, String string, String string2) {
        super(emitter, string2);
        this.namespaces = emitter.getNamespaces();
        this.packageName = Utils.getJavaPackageName(string);
        this.className = Utils.getJavaLocalName(string);
    }

    protected String getFileName() {
        return this.namespaces.toDir(this.packageName) + this.className + ".java";
    }

    protected void registerFile(String string) {
        String string2 = this.getPackage() + '.' + this.getClassName();
        this.emitter.getGeneratedFileInfo().add(string, string2, this.type);
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
        this.writeHeaderComments(printWriter);
        this.writePackage(printWriter);
        printWriter.println(this.getClassModifiers() + this.getClassText() + this.getClassName() + ' ' + this.getExtendsText() + this.getImplementsText() + "{");
    }

    protected void writeHeaderComments(PrintWriter printWriter) throws IOException {
        String string = this.getFileName();
        int n = string.lastIndexOf(this.emitter.getToolEnv().getSeparatorChar());
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        printWriter.println("/**");
        printWriter.println(" * " + string);
        printWriter.println(" *");
        printWriter.println(" * " + Messages.getMessage("wsdlGenLine00"));
        printWriter.println(" * " + Messages.getMessage("wsdlGenLine01"));
        printWriter.println(" * " + Version.getRawData());
        printWriter.println(" */");
        printWriter.println();
    }

    protected void writePackage(PrintWriter printWriter) throws IOException {
        if (this.getPackage() != null) {
            printWriter.println("package " + this.getPackage() + ";");
            printWriter.println();
        }
    }

    protected String getClassModifiers() {
        return "public ";
    }

    protected String getClassText() {
        return "class ";
    }

    protected String getExtendsText() {
        return "";
    }

    protected String getImplementsText() {
        return "";
    }

    protected String getPackage() {
        return this.packageName;
    }

    protected String getClassName() {
        return this.className;
    }

    protected void writeFileFooter(PrintWriter printWriter) throws IOException {
        super.writeFileFooter(printWriter);
        printWriter.println('}');
    }
}

