/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import com.ibm.ws.webservices.utils.OptionDescriptor;
import com.ibm.wsdl.BindingFaultImpl;
import com.ibm.wsdl.BindingInputImpl;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.BindingOutputImpl;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public abstract class ModelBindingGenerator
implements BindingGenerator {
    protected String bindingTypeName;
    protected OptionDescriptor[] defaultOptionDescriptors = null;

    public ModelBindingGenerator(String string) {
        this.bindingTypeName = string;
        this.defaultOptionDescriptors = new OptionDescriptor[]{new OptionDescriptor(this.bindingTypeName + ".bindingName", false, Messages.getMessage("desc.bindingName", this.bindingTypeName)), new OptionDescriptor(this.bindingTypeName + ".servicePortName", false, Messages.getMessage("desc.servicePortName", this.bindingTypeName)), new OptionDescriptor(this.bindingTypeName + ".location", false, Messages.getMessage("desc.locationURI", this.bindingTypeName))};
    }

    public String getBindingTypeName() {
        return this.bindingTypeName;
    }

    protected OptionDescriptor[] getDefaultOptionDescriptors() {
        return this.defaultOptionDescriptors;
    }

    public OptionDescriptor[] getOptionDescriptors() {
        return this.getDefaultOptionDescriptors();
    }

    public Binding makeBinding(Definition definition, PortType portType, QName qName, Properties properties) {
        Binding binding = definition.createBinding();
        binding.setPortType(portType);
        binding.setQName(qName);
        ExtensibilityElement extensibilityElement = this.getBindingExtension(portType);
        if (extensibilityElement != null) {
            binding.addExtensibilityElement(extensibilityElement);
        }
        this.addOperations(portType, binding);
        binding.setUndefined(false);
        this.addNamespaces(definition);
        return binding;
    }

    protected abstract ExtensibilityElement getBindingExtension(PortType var1);

    protected void addOperations(PortType portType, Binding binding) {
        Iterator iterator = portType.getOperations().iterator();
        while (iterator.hasNext()) {
            Object object;
            Serializable serializable;
            Input input;
            Operation operation = (Operation)iterator.next();
            BindingOperationImpl bindingOperationImpl = new BindingOperationImpl();
            bindingOperationImpl.setName(operation.getName());
            bindingOperationImpl.setOperation(operation);
            ExtensibilityElement extensibilityElement = this.getBindingOperation(operation);
            if (extensibilityElement != null) {
                bindingOperationImpl.addExtensibilityElement(extensibilityElement);
            }
            if ((input = operation.getInput()) != null) {
                serializable = new BindingInputImpl();
                serializable.setName(input.getName());
                this.doGetBindingInput(operation, bindingOperationImpl, (BindingInput)serializable);
                bindingOperationImpl.setBindingInput((BindingInput)serializable);
            }
            if ((serializable = operation.getOutput()) != null) {
                object = new BindingOutputImpl();
                object.setName(serializable.getName());
                this.doGetBindingOutput(operation, bindingOperationImpl, (BindingOutput)object);
                bindingOperationImpl.setBindingOutput((BindingOutput)object);
            }
            if (operation.getFaults() != null) {
                object = operation.getFaults().values().iterator();
                while (object.hasNext()) {
                    Fault fault2 = (Fault)object.next();
                    BindingFaultImpl bindingFaultImpl = new BindingFaultImpl();
                    bindingFaultImpl.setName(fault2.getName());
                    bindingOperationImpl.addBindingFault(bindingFaultImpl);
                }
            }
            binding.addBindingOperation(bindingOperationImpl);
        }
    }

    protected abstract ExtensibilityElement getBindingOperation(Operation var1);

    protected void doGetBindingInput(Operation operation, BindingOperation bindingOperation, BindingInput bindingInput) {
    }

    protected void doGetBindingOutput(Operation operation, BindingOperation bindingOperation, BindingOutput bindingOutput) {
    }

    protected void addNamespaces(Definition definition) {
        Map map = this.getRequiredNamespaces();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                if (definition.getNamespace(string) != null) continue;
                definition.addNamespace(string, string2);
            }
        }
    }

    protected abstract Map getRequiredNamespaces();

    public ExtensibilityElement makePortAddress(Definition definition, Port port2, Properties properties) {
        String string = properties.getProperty(this.bindingTypeName + ".location");
        String string2 = properties.getProperty("location");
        AgnosticAddress agnosticAddress = new AgnosticAddress();
        agnosticAddress.setLocationURI(string != null ? string : string2);
        String string3 = AgnosticAddress.AGNOSTIC_ADDRESS_ELEMENT_QNAME.getNamespaceURI();
        if (definition.getNamespace(string3) == null) {
            definition.addNamespace("generic", string3);
        }
        return agnosticAddress;
    }

    public String getBindingName(Properties properties) {
        String string;
        String string2 = properties.getProperty(this.bindingTypeName + ".bindingName");
        if (string2 != null) {
            string = string2;
        } else {
            String string3 = properties.getProperty("bindingName");
            string = string3 + JavaUtils.capitalizeFirstChar(this.bindingTypeName) + "Binding";
        }
        return string;
    }

    public String getPortName(Properties properties) {
        String string;
        String string2 = properties.getProperty(this.bindingTypeName + ".servicePortName");
        if (string2 != null) {
            string = string2;
        } else {
            String string3 = properties.getProperty("servicePortName");
            string = string3 + JavaUtils.capitalizeFirstChar(this.bindingTypeName);
        }
        return string;
    }
}

