/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.discovery;

import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class ServiceProviderLocator {
    protected static Log log = LogFactory.getLog(ServiceProviderLocator.class.getName());
    protected List discoveredServiceProviders;
    public static final String CONFIGURATION_FILE_NAME = "META-INF/services/" + ServiceProvider.class.getName();
    protected static ServiceProviderLocator instance = new ServiceProviderLocator();

    protected ServiceProviderLocator() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServiceProviderLocator ctor");
        }
        this.discoveredServiceProviders = this.findAllServiceProviders();
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServiceProviderLocator ctor");
        }
    }

    public static ServiceProviderLocator getInstance() {
        return instance;
    }

    public List getServiceProviders() {
        return this.discoveredServiceProviders;
    }

    protected List findAllServiceProviders() {
        List list = (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServiceProviderLocator.this.discoverServiceProviders();
            }
        });
        return Collections.unmodifiableList(list);
    }

    protected ArrayList discoverServiceProviders() {
        Iterator iterator;
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServiceProviderLocator::discoverServiceProviders");
        }
        ArrayList<ServiceProvider> arrayList = new ArrayList<ServiceProvider>();
        this.findServiceProvidersViaExtPtRegistry(arrayList);
        if (arrayList.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("No service providers via extension point registry, searching for ServiceProvider files...");
            }
            if ((object = this.getServiceProviderClassNames()) != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ServiceProvider serviceProvider = this.instantiateServiceProvider(string);
                    if (serviceProvider == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Instantiated service provider: " + string);
                    }
                    arrayList.add(serviceProvider);
                }
            }
        }
        if (log.isDebugEnabled()) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                iterator = object.next();
                log.debug("Found multiprotocol service provider: " + iterator.getClass().getName());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServiceProviderLocator::discoverServiceProviders");
        }
        return arrayList;
    }

    protected ServiceProvider instantiateServiceProvider(String string) {
        ServiceProvider serviceProvider;
        ServiceProvider serviceProvider2 = null;
        Object var3_3 = null;
        try {
            var3_3 = ClassUtils.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.instantiateServiceProvider", "229", this);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.instantiateServiceProvider", "231", this);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.instantiateServiceProvider", "233", this);
        }
        if (var3_3 instanceof ServiceProvider && (serviceProvider = (ServiceProvider)var3_3).isEnabled()) {
            serviceProvider2 = serviceProvider;
        }
        return serviceProvider2;
    }

    protected List getServiceProviderClassNames() {
        ArrayList arrayList = new ArrayList();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources(CONFIGURATION_FILE_NAME);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                classLoader = ExtClassLoader.getInstance();
                enumeration = classLoader.getResources(CONFIGURATION_FILE_NAME);
            }
            while (enumeration != null && enumeration.hasMoreElements()) {
                this.readMETAINFClassNames(enumeration.nextElement(), arrayList);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.getServiceProviderClassNames", "264", this);
        }
        return arrayList;
    }

    private void findServiceProvidersViaExtPtRegistry(ArrayList arrayList) {
        IExtensionRegistry iExtensionRegistry;
        if (log.isDebugEnabled()) {
            log.debug("Enter: ServiceProviderLocator::findServiceProvidersViaExtPtRegistry");
        }
        if ((iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to get eclipse extension registry");
            }
            return;
        }
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".service-provider";
        if (log.isDebugEnabled()) {
            log.debug("Looking for instances of epid: " + string);
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
            if (!"serviceProvider".equals(iConfigurationElement.getName())) continue;
            try {
                arrayList.add(iConfigurationElement.createExecutableExtension("classname"));
                continue;
            }
            catch (CoreException coreException) {
                FFDCFilter.processException((Throwable)coreException, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.addServiceProvidersFromExtensionPoint", "350", this);
                if (!log.isDebugEnabled()) continue;
                log.debug("Couldn't load ServiceProvider implementation with classname: " + iConfigurationElement.getAttribute("classname"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ServiceProviderLocator::findServiceProvidersViaExtPtRegistry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMETAINFClassNames(URL uRL, ArrayList arrayList) {
        if (log.isDebugEnabled()) {
            log.debug("Reading class names from file: " + uRL.toString());
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(35);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((string = string.trim()).length() <= 0 || arrayList.contains(string)) continue;
                arrayList.add(string);
                if (!log.isDebugEnabled()) continue;
                log.debug("Found classname: " + string);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.readMETAINFClassNames", "298", this);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator.readMETAINFClassNames", "305", this);
                }
            }
        }
    }
}

