/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.commons.logging.Log;

public class SessionUtils {
    protected static Log log = LogFactory.getLog(SessionUtils.class.getName());
    protected static Random random = null;
    protected static String randomClass = "java.security.SecureRandom";
    private static String thisHost = null;
    private static int count = (int)(Math.random() * 100.0);

    public static synchronized String generateSessionId() {
        return SessionUtils.getEntropy();
    }

    public static synchronized Long generateSession() {
        return new Long(SessionUtils.getRandom().nextLong());
    }

    private static synchronized Random getRandom() {
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(randomClass);
                random = (Random)clazz.newInstance();
                long l = System.currentTimeMillis();
                char[] cArray = SessionUtils.getEntropy().toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    long l2 = (byte)cArray[i] << i % 8 * 8;
                    l ^= l2;
                }
                random.setSeed(l);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.utils.SessionUtils.getRandom", "202");
                random = new Random();
            }
        }
        return random;
    }

    private static String getEntropy() {
        if (null == thisHost) {
            try {
                thisHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException(unknownHostException, "com.ibm.ws.webservices.engine.utils.SessionUtils.getEntropy", "219");
                log.error(Messages.getMessage("javaNetUnknownHostException00"), unknownHostException);
                thisHost = "localhost";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(++count).append(stringBuffer.hashCode()).append('.').append(System.currentTimeMillis()).append(".IBM.WEBSERVICES@").append(thisHost);
        return stringBuffer.toString();
    }
}

