/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.custom.CustomBindingContextImpl;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.wsspi.webservices.binding.CustomBinder;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class CustomSerializerProxy
implements Serializer {
    protected static Log log = LogFactory.getLog(CustomSerializerProxy.class.getName());
    private QName xmlType;
    private Class javaType;
    private Class binderClass;

    protected CustomSerializerProxy(Class clazz, QName qName, Class clazz2) {
        this.javaType = clazz;
        this.xmlType = qName;
        this.binderClass = clazz2;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        CustomBinder customBinder = null;
        try {
            customBinder = (CustomBinder)this.binderClass.newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerProxy.serialize", "63", this);
            throw new IOException(exception.getMessage());
        }
        if (customBinder == null) {
            throw new IOException("No CustomBinder is found for xml type: " + this.xmlType);
        }
        try {
            javax.xml.soap.SOAPElement sOAPElement = SOAPFactory.newInstance().createElement(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
            sOAPElement = customBinder.serialize(object, sOAPElement, new CustomBindingContextImpl());
            if (sOAPElement instanceof SOAPElement) {
                SOAPElement sOAPElement2 = (SOAPElement)sOAPElement;
                sOAPElement2.output(serializationContext);
            } else {
                SOAPElement sOAPElement3 = (SOAPElement)SOAPFactory.newInstance().createElement(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
                sOAPElement3.setAlternateContent(sOAPElement);
                sOAPElement3.output(serializationContext);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerProxy.serialize", "98", this);
            throw new IOException(exception.getMessage());
        }
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

