/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.EnumDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class BeanDeserializerFactory
extends BaseDeserializerFactory {
    protected BeanDesc beanDesc = null;
    protected Map propertyMap = null;

    public BeanDeserializerFactory(Class clazz, QName qName) {
        super(BeanDeserializer.class, qName, clazz);
        if (JavaUtils.isEnumClass(clazz)) {
            this.deserClass = EnumDeserializer.class;
        }
    }

    public static BeanDeserializerFactory create(Class clazz, QName qName, QName qName2, QName qName3) {
        return new BeanDeserializerFactory(clazz, qName);
    }

    protected void lazyInitialization() {
        super.lazyInitialization();
        this.beanDesc = BeanDesc.getBeanDescForClass(this.javaType);
        if (this.beanDesc == null) {
            this.propertyMap = BeanDeserializerFactory.getProperties(this.javaType, null);
        }
    }

    public static Map getProperties(Class clazz, BeanDesc beanDesc) {
        HashMap<String, BeanPropertyDescriptor> hashMap = null;
        if (beanDesc != null) {
            return beanDesc.getPropertyDescriptorMap();
        }
        BeanPropertyDescriptor[] beanPropertyDescriptorArray = BeanUtils.getPd(clazz, null);
        hashMap = new HashMap<String, BeanPropertyDescriptor>();
        for (int i = 0; i < beanPropertyDescriptorArray.length; ++i) {
            BeanPropertyDescriptor beanPropertyDescriptor = beanPropertyDescriptorArray[i];
            hashMap.put(beanPropertyDescriptor.getName(), beanPropertyDescriptor);
        }
        return hashMap;
    }

    protected Deserializer getSpecialized(String string) {
        Deserializer deserializer = super.getSpecialized(string);
        if (deserializer != null && deserializer instanceof AttributeDeserializer && this.beanDesc != null) {
            ((AttributeDeserializer)deserializer).setup(this.beanDesc, this.beanDesc.getPropertyDescriptorMap());
        }
        return deserializer;
    }

    protected Deserializer getGeneralPurpose(String string) {
        if (this.javaType == null || this.xmlType == null) {
            return super.getGeneralPurpose(string);
        }
        if (this.deserClass == EnumDeserializer.class) {
            return super.getGeneralPurpose(string);
        }
        if (this.beanDesc != null) {
            return new BeanDeserializer(this.javaType, this.xmlType, this.beanDesc);
        }
        return new BeanDeserializer(this.javaType, this.xmlType, null, this.propertyMap);
    }

    protected Method getDeserializerMethod(Class clazz) {
        Method method = super.getDeserializerMethod(clazz);
        if (method == null && !this.deserClass.equals(EnumDeserializer.class)) {
            throw new InternalException(Messages.getMessage("missingHelper00", this.javaType.getName()));
        }
        return method;
    }
}

