/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMappingContainer;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDUndeployment
extends WSDDElement
implements WSDDTypeMappingContainer {
    private Vector services = new Vector();
    private Vector transports = new Vector();
    private Vector typeMappings = new Vector();

    public void addTransport(QName qName) {
        this.transports.add(qName);
    }

    public void addService(QName qName) {
        this.services.add(qName);
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        this.typeMappings.add(wSDDTypeMapping);
    }

    public WSDDUndeployment() {
    }

    private QName getQName(Element element) throws WSDDException {
        String string = element.getAttribute("name");
        if (string == null || "".equals(string)) {
            throw new WSDDException(Messages.getMessage("badNameAttr00"));
        }
        return QNameTable.createQName("", string);
    }

    public WSDDUndeployment(Element element) throws WSDDException {
        super(element);
        int n;
        Element[] elementArray = this.getChildElements(element, "transport");
        for (n = 0; n < elementArray.length; ++n) {
            this.addTransport(this.getQName(elementArray[n]));
        }
        elementArray = this.getChildElements(element, "port");
        for (n = 0; n < elementArray.length; ++n) {
            this.addService(this.getQName(elementArray[n]));
        }
    }

    protected QName getElementName() {
        return QNAME_UNDEPLOY;
    }

    public void undeployFromRegistry(WSDDDeployment wSDDDeployment) throws ConfigurationException {
        QName qName;
        int n;
        for (n = 0; n < this.transports.size(); ++n) {
            qName = (QName)this.transports.get(n);
            wSDDDeployment.undeployTransport(qName);
        }
        for (n = 0; n < this.services.size(); ++n) {
            qName = (QName)this.services.get(n);
            wSDDDeployment.undeployPort(qName);
        }
    }

    private void writeElement(SerializationContext serializationContext, QName qName, QName qName2) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.getSerializationWriter().qName2String(qName2));
        serializationContext.getSerializationWriter().simpleElement(qName, attributesImpl, null);
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        QName qName;
        serializationContext.getSerializationWriter().addMapping("", "http://websphere.ibm.com/webservices/wsdd/");
        serializationContext.getSerializationWriter().startElement(WSDDConstants.QNAME_UNDEPLOY, null);
        Iterator iterator = this.services.iterator();
        while (iterator.hasNext()) {
            qName = (QName)iterator.next();
            this.writeElement(serializationContext, QNAME_PORT, qName);
        }
        iterator = this.transports.iterator();
        while (iterator.hasNext()) {
            qName = (QName)iterator.next();
            this.writeElement(serializationContext, QNAME_TRANSPORT, qName);
        }
        iterator = this.typeMappings.iterator();
        while (iterator.hasNext()) {
            WSDDTypeMapping wSDDTypeMapping = (WSDDTypeMapping)iterator.next();
            wSDDTypeMapping.writeToContext(serializationContext);
        }
        serializationContext.getSerializationWriter().endElement();
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] wSDDTypeMappingArray = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.toArray(wSDDTypeMappingArray);
        return wSDDTypeMappingArray;
    }
}

