/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.SecureSocketFactory;
import com.ibm.ws.webservices.engine.components.net.SocketFactory;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;

public class SocketFactoryFactory {
    protected static Log log = LogFactory.getLog(SocketFactoryFactory.class.getName());
    private static Hashtable factories = new Hashtable();
    private static final Class[] classes = new Class[]{Hashtable.class};

    public static synchronized SocketFactory getFactory(String string, Map map) {
        SocketFactory socketFactory = (SocketFactory)factories.get(string);
        if (socketFactory == null) {
            Object[] objectArray = new Object[]{map};
            if (string.equalsIgnoreCase("http")) {
                socketFactory = (SocketFactory)WebServicesProperties.newInstance(SocketFactory.class, classes, objectArray);
            } else if (string.equalsIgnoreCase("https")) {
                socketFactory = (SecureSocketFactory)WebServicesProperties.newInstance(SecureSocketFactory.class, classes, objectArray);
            }
            if (socketFactory != null) {
                factories.put(string, socketFactory);
            }
        }
        return socketFactory;
    }

    static {
        WebServicesProperties.setClassOverrideProperty(SocketFactory.class, "webservices.socketFactory");
        WebServicesProperties.setClassDefault(SocketFactory.class, "com.ibm.ws.webservices.engine.components.net.DefaultSocketFactory");
        WebServicesProperties.setClassOverrideProperty(SecureSocketFactory.class, "webservices.socketSecureFactory");
        WebServicesProperties.setClassDefault(SecureSocketFactory.class, "com.ibm.ws.webservices.engine.components.net.JSSESocketFactory");
    }
}

