/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.BooleanHolder;
import com.ibm.ws.webservices.engine.components.net.SocketFactory;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.encoding.Base64;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class DefaultSocketFactory
implements SocketFactory {
    private static Log log = LogFactory.getLog(DefaultSocketFactory.class.getName());
    protected Hashtable attributes = null;

    public DefaultSocketFactory(Hashtable hashtable) {
        this.attributes = hashtable;
    }

    public Socket create(String string, int n, StringBuffer stringBuffer, BooleanHolder booleanHolder) throws Exception {
        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create("http");
        Socket socket = null;
        boolean bl = this.isHostInNonProxyList(string, transportClientProperties.getNonProxyHosts());
        if (n == -1) {
            n = 80;
        }
        if (transportClientProperties.getProxyHost().length() == 0 || transportClientProperties.getProxyPort().length() == 0 || bl) {
            socket = new Socket(string, n);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("createdHTTP00"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("httpProxyConfiguration00", transportClientProperties.getProxyHost(), transportClientProperties.getProxyPort(), transportClientProperties.getProxyUser(), JavaUtils.hasValue(transportClientProperties.getProxyPassword()) ? "******" : ""));
            }
            if (transportClientProperties.getProxyUser().length() != 0 && transportClientProperties.getProxyPassword().length() != 0) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(transportClientProperties.getProxyUser()).append(":").append(transportClientProperties.getProxyPassword());
                stringBuffer.append("Proxy-Authorization").append(": Basic ").append(Base64.encode(stringBuffer2.toString().getBytes())).append("\r\n");
            }
            socket = new Socket(transportClientProperties.getProxyHost(), (int)new Integer(transportClientProperties.getProxyPort()));
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("createdHTTP01", transportClientProperties.getProxyHost(), transportClientProperties.getProxyPort()));
            }
            booleanHolder.value = true;
        }
        return socket;
    }

    protected boolean isHostInNonProxyList(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("match00", new String[]{"HTTPSender", string, string3}));
            }
            if (!DefaultSocketFactory.match(string3, string, false)) continue;
            return true;
        }
        return false;
    }

    protected static boolean match(String string, String string2, boolean bl) {
        char c;
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = 0;
        int n3 = cArray.length - 1;
        int n4 = 0;
        int n5 = cArray2.length - 1;
        boolean bl2 = false;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '*') continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (n3 != n5) {
                return false;
            }
            for (n = 0; n <= n3; ++n) {
                char c2 = cArray[n];
                if (bl && c2 != cArray2[n]) {
                    return false;
                }
                if (bl || Character.toUpperCase(c2) == Character.toUpperCase(cArray2[n])) continue;
                return false;
            }
            return true;
        }
        if (n3 == 0) {
            return true;
        }
        while ((c = cArray[n2]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n4]) {
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4])) {
                return false;
            }
            ++n2;
            ++n4;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                return false;
            }
            return true;
        }
        while ((c = cArray[n3]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n5]) {
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n5])) {
                return false;
            }
            --n3;
            --n5;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                return false;
            }
            return true;
        }
        while (n2 != n3 && n4 <= n5) {
            int n6;
            n = -1;
            for (n6 = n2 + 1; n6 <= n3; ++n6) {
                if (cArray[n6] != '*') continue;
                n = n6;
                break;
            }
            if (n == n2 + 1) {
                ++n2;
                continue;
            }
            n6 = n - n2 - 1;
            int n7 = n5 - n4 + 1;
            int n8 = -1;
            block8: for (int i = 0; i <= n7 - n6; ++i) {
                for (int j = 0; j < n6; ++j) {
                    c = cArray[n2 + j + 1];
                    if (bl && c != cArray2[n4 + i + j] || !bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4 + i + j])) continue block8;
                }
                n8 = n4 + i;
                break;
            }
            if (n8 == -1) {
                return false;
            }
            n2 = n;
            n4 = n8 + n6;
        }
        for (n = n2; n <= n3; ++n) {
            if (cArray[n] == '*') continue;
            return false;
        }
        return true;
    }
}

