/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.NoEndPointException;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.MimeUtils;
import com.ibm.ws.webservices.engine.client.Connection;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.custom.Utils;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.SessionContext;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import com.ibm.ws.webservices.tools.WSDLQuery;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class Call
implements com.ibm.wsspi.webservices.rpc.Call {
    protected static Log log = LogFactory.getLog(Call.class.getName());
    protected static Log entLog = LogFactory.getLog("com.ibm.ws.webservices.engine.enterprise");
    protected SessionContext cachedSessionContext = null;
    private boolean parmAndRetReq = true;
    private Service service = null;
    private MessageContext msgContext = null;
    private Connection connection = null;
    private OperationDesc operation = new OperationDesc();
    private Vector myHeaders = null;
    private Map outParams = null;
    private ArrayList outParamsList = null;
    private boolean invokeOneWayCalled = false;
    private boolean customBinderLoaded = false;
    private WSDLQuery wsdlQuery = null;
    private boolean wsdlQueryUnavailable = false;
    private boolean wsdlQueryReloadOp = false;
    public static final boolean FAULT_ON_NO_RESPONSE = false;
    public static final String SEND_TYPE_ATTR = "send_type_attr";
    public static final String TIMEOUT = "timeout";
    public static final String TRANSPORT_NAME = "transport_name";
    public static final String WSDL_PORT_NAME = "wsdl.portName";
    public static final String OPERATION_USE_PROPERTY = "operation_use";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT = "attachment_encapsulation_format";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_MIME = "webservices.attachment.style.mime";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_DIME = "webservices.attachment.style.dime";
    private static ArrayList propertyNames = new ArrayList();
    protected Vector attachmentParts = new Vector();

    public Call(Service service) {
        this.service = service;
        this.msgContext = new MessageContext(service.getEngine());
        this.msgContext.setProperty("javax.xml.rpc.session.maintain", new Boolean(service.getMaintainSession()));
        this.msgContext.setOperation(this.operation);
    }

    public Call(String string) throws MalformedURLException {
        this(new Service());
        this.setTargetEndpointAddress(new URL(string));
    }

    public Call(URL uRL) {
        this(new Service());
        this.setTargetEndpointAddress(uRL);
    }

    public void setProperty(String string, Object object) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.setProperty()  " + string);
        }
        if ("javax.xml.rpc.service.endpoint.address".equals(string)) {
            this.setTargetEndpointAddress((String)object);
        } else if ("com.ibm.websphere.wsaddressing.destinationEPR".equals(string)) {
            Object object2;
            Object object3;
            this.msgContext.setProperty(string, object);
            EndpointReference endpointReference = (EndpointReference)object;
            AttributedURI attributedURI = endpointReference.getAddress();
            if (attributedURI != null) {
                object3 = attributedURI.getURI();
                if (object3 != null) {
                    object2 = ((URI)object3).toString();
                    if (entLog.isDebugEnabled()) {
                        entLog.debug("Setting based on WSADDRESSING_DESTINATION_EPR address:" + (String)object2);
                    }
                    this.setTargetEndpointAddress((String)object2);
                } else if (entLog.isDebugEnabled()) {
                    entLog.debug("WSADDRESSING_DESTINATION_EPR address (URI) is null.");
                }
            } else if (entLog.isDebugEnabled()) {
                entLog.debug("WSADDRESSING_DESTINATION_EPR address (AttributedURI) is null.");
            }
            object3 = endpointReference.getMetadata();
            if (object3 != null) {
                if (entLog.isDebugEnabled()) {
                    entLog.debug("Metadata Found. Checking Service and Endpoint Name");
                }
                if ((object2 = object3.getServiceName()) != null) {
                    String string2;
                    if (entLog.isDebugEnabled()) {
                        entLog.debug("ServiceName found in Metadata");
                    }
                    QName qName = object2.getQName();
                    QName qName2 = this.service.getServiceName();
                    if (qName2 == null) {
                        if (entLog.isDebugEnabled()) {
                            entLog.debug("No ServiceName available from Service. Not checking.");
                        }
                    } else if (!qName2.equals(qName)) {
                        String string3 = qName == null ? "null" : qName.toString();
                        throw new JAXRPCException(Messages.getMessage("MismatchedServiceName", string3, qName2.toString()));
                    }
                    if ((string2 = object2.getEndpointName()) != null) {
                        QName qName3 = new QName(string2);
                        QName qName4 = this.getPortName();
                        if (qName4 != null) {
                            if (!qName4.equals(qName3)) {
                                String string4 = qName3 == null ? "null" : qName3.toString();
                                throw new JAXRPCException(Messages.getMessage("MismatchedPortName", string4, qName4.toString()));
                            }
                        } else {
                            if (entLog.isDebugEnabled()) {
                                entLog.debug("EndpointName found in Metadata. Setting PortName to " + string2);
                            }
                            this.setPortName(new QName(string2));
                        }
                    }
                }
            }
        } else {
            this.msgContext.setProperty(string, object);
        }
        if ("noDataBinding".equals(string) || "jaxrpcMappingFile".equals(string)) {
            this.wsdlQuery = null;
            this.wsdlQueryUnavailable = false;
            this.wsdlQueryReloadOp = true;
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.setProperty()");
        }
    }

    public Object getProperty(String string) {
        if (string == null || !this.isPropertySupported(string)) {
            throw new JAXRPCException(string == null ? Messages.getMessage("badProp03") : Messages.getMessage("badProp05", string));
        }
        return this.msgContext.getProperty(string);
    }

    public void removeProperty(String string) {
        if (string == null || !this.isPropertySupported(string)) {
            throw new JAXRPCException(string == null ? Messages.getMessage("badProp03") : Messages.getMessage("badProp05", string));
        }
        this.msgContext.removeProperty(string);
    }

    public Iterator getPropertyNames() {
        return propertyNames.iterator();
    }

    public boolean isPropertySupported(String string) {
        return propertyNames.contains(string) || !string.startsWith("java.") && !string.startsWith("javax.");
    }

    public void setUsername(String string) {
        this.msgContext.setUsername(string);
    }

    public String getUsername() {
        return this.msgContext.getUsername();
    }

    public void setPassword(String string) {
        this.msgContext.setPassword(string);
    }

    public String getPassword() {
        return this.msgContext.getPassword();
    }

    public void setMaintainSession(boolean bl) {
        this.msgContext.setMaintainSession(bl);
    }

    public boolean getMaintainSession() {
        return this.msgContext.getMaintainSession();
    }

    public void setOperationStyle(String string) {
        this.msgContext.setOperationStyle(string);
    }

    public Style getOperationStyle() {
        return this.msgContext.getOperationStyle();
    }

    public String getOperationStyleString() {
        return this.msgContext.getOperationStyleString();
    }

    public void setOperationUse(String string) {
        this.msgContext.setOperationUse(string);
    }

    public com.ibm.ws.webservices.engine.enum.Use getOperationUse() {
        return this.msgContext.getOperationUse();
    }

    public String getOperationUseString() {
        return this.msgContext.getOperationUseString();
    }

    public void setUseSOAPAction(boolean bl) {
        this.msgContext.setUseSOAPAction(bl);
    }

    public boolean useSOAPAction() {
        return this.msgContext.useSOAPAction();
    }

    public void setSOAPActionURI(String string) throws IllegalArgumentException {
        this.msgContext.setSOAPActionURI(string);
    }

    public String getSOAPActionURI() {
        return this.msgContext.getSOAPActionURI();
    }

    public void setEncodingStyle(String string) {
        this.msgContext.setEncodingStyle(string);
    }

    public String getEncodingStyle() {
        return this.msgContext.getEncodingStyle();
    }

    public void setTargetEndpointAddress(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.webservices.engine.client.Call.setTargetEndpointAddress", "555", this);
            throw new JAXRPCException(malformedURLException);
        }
        this.setTargetEndpointAddress(uRL);
    }

    public void setTargetEndpointAddress(URL uRL) {
        this.msgContext.setTargetEndpointAddress(uRL);
        this.connection = this.service.getConnection(uRL);
    }

    public String getTargetEndpointAddress() {
        return (String)this.msgContext.getProperty("javax.xml.rpc.service.endpoint.address");
    }

    public URL getTargetEndpointAddressAsURL() {
        return this.msgContext.getTargetEndpointAddressAsURL();
    }

    public Integer getTimeout() {
        return (Integer)this.msgContext.getProperty(TIMEOUT);
    }

    public void setTimeout(Integer n) {
        this.msgContext.setTimeout(n);
    }

    public String getTransportName() {
        return (String)this.getProperty(TRANSPORT_NAME);
    }

    public void setTransportName(String string) {
        if (string != null) {
            this.setProperty(TRANSPORT_NAME, string);
        }
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        return this.parmAndRetReq;
    }

    public void addParameter(QName qName, QName qName2, ParameterMode parameterMode) {
        Class clazz = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (typeMapping != null) {
            clazz = typeMapping.getClassForQName(qName2);
        }
        this.addParameter(qName, qName2, clazz, parameterMode);
    }

    public void addParameter(QName qName, QName qName2, Class clazz, ParameterMode parameterMode) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.addParameter()  " + qName.toString());
        }
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setQName(qName);
        parameterDesc.setTypeQName(qName2);
        parameterDesc.setJavaType(clazz);
        byte by = 1;
        if (parameterMode == ParameterMode.INOUT) {
            by = 3;
        } else if (parameterMode == ParameterMode.OUT) {
            by = 2;
        }
        parameterDesc.setMode(by);
        this.operation.addParameter(parameterDesc);
        this.parmAndRetReq = true;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.addParameter()");
        }
    }

    public void addParameter(String string, QName qName, ParameterMode parameterMode) {
        Class clazz = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (typeMapping != null) {
            clazz = typeMapping.getClassForQName(qName);
        }
        this.addParameter(QNameTable.createQName("", string), qName, clazz, parameterMode);
    }

    public void addParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) {
        this.addParameter(QNameTable.createQName("", string), qName, clazz, parameterMode);
    }

    public void addParameterAsHeader(QName qName, QName qName2, Class clazz, ParameterMode parameterMode, ParameterMode parameterMode2) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.addParameterAsHeader()  " + qName.toString());
        }
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setQName(qName);
        parameterDesc.setTypeQName(qName2);
        parameterDesc.setJavaType(clazz);
        if (parameterMode == ParameterMode.IN) {
            parameterDesc.setMode((byte)1);
        } else if (parameterMode == ParameterMode.INOUT) {
            parameterDesc.setMode((byte)3);
        } else if (parameterMode == ParameterMode.OUT) {
            parameterDesc.setMode((byte)2);
        }
        if (parameterMode2 == ParameterMode.IN) {
            parameterDesc.setInHeader(true);
        } else if (parameterMode2 == ParameterMode.INOUT) {
            parameterDesc.setInHeader(true);
            parameterDesc.setOutHeader(true);
        } else if (parameterMode2 == ParameterMode.OUT) {
            parameterDesc.setOutHeader(true);
        }
        this.operation.addParameter(parameterDesc);
        this.parmAndRetReq = true;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.addParameterAsHeader()");
        }
    }

    public QName getParameterTypeByName(String string) {
        QName qName = QNameTable.createQName("", string);
        return this.getParameterTypeByQName(qName);
    }

    public QName getParameterTypeByQName(QName qName) {
        ParameterDesc parameterDesc = this.operation.getParamByQName(qName);
        if (parameterDesc != null) {
            return parameterDesc.getTypeQName();
        }
        return null;
    }

    public void setReturnType(QName qName) {
        TypeMapping typeMapping = this.getTypeMapping();
        Class clazz = typeMapping.getClassForQName(qName);
        this.setReturnType(qName, clazz);
    }

    public void setReturnType(QName qName, Class clazz) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.setReturnType() " + (qName == null ? "null" : qName.getLocalPart()));
        }
        this.operation.setReturnType(qName);
        this.operation.setReturnClass(clazz);
        this.parmAndRetReq = true;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.setReturnType() ");
        }
    }

    public void setReturnTypeAsHeader(QName qName) {
        this.setReturnType(qName);
        this.operation.setReturnHeader(true);
    }

    public void setReturnTypeAsHeader(QName qName, Class clazz) {
        this.setReturnType(qName, clazz);
        this.operation.setReturnHeader(true);
    }

    public QName getReturnType() {
        return this.operation.getReturnType();
    }

    public void setReturnQName(QName qName) {
        this.operation.setReturnQName(qName);
    }

    public void setReturnClass(Class clazz) {
        QName qName = this.getTypeMapping().getTypeQName(clazz);
        this.setReturnType(qName, clazz);
    }

    public void removeAllParameters() {
        this.operation.removeParameters();
        this.parmAndRetReq = true;
    }

    public QName getOperationName() {
        return this.operation.getElementQName();
    }

    public void setOperationName(QName qName) {
        this.operation.setElementQName(qName);
    }

    public void setOperationName(String string) {
        this.operation.setElementQName(QNameTable.createQName("", string));
    }

    public void setOperation(QName qName, String string) {
        this.setOperation(qName, string, null);
    }

    public void setOperation(QName qName, String string, String string2) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        BindingInput bindingInput;
        Object object5;
        Object object6;
        SOAPAddress sOAPAddress;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.setOperation()  " + string);
        }
        if (this.service == null) {
            throw new JAXRPCException(Messages.getMessage("noService04"));
        }
        this.setPortName(qName);
        this.setEncodingStyle(null);
        this.removeAllParameters();
        this.setOperationName(string);
        javax.wsdl.Service service = this.service.getWSDLService();
        if (service == null) {
            return;
        }
        Port port2 = service.getPort(qName.getLocalPart());
        if (port2 == null) {
            throw new JAXRPCException(Messages.getMessage("noPortType00", "" + this.getPortName()));
        }
        Binding binding = port2.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new JAXRPCException(Messages.getMessage("noPortType00", "" + this.getPortName()));
        }
        List list = portType.getOperations();
        if (list == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation01", string));
        }
        Operation operation = null;
        for (int i = 0; i < list.size() && !string.equals((operation = (Operation)list.get(i)).getName()); ++i) {
            operation = null;
        }
        if (operation == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation01", string));
        }
        List list2 = port2.getExtensibilityElements();
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            Object e = list2.get(i);
            if (!(e instanceof SOAPAddress)) continue;
            try {
                sOAPAddress = (SOAPAddress)e;
                object6 = new URL(sOAPAddress.getLocationURI());
                this.setTargetEndpointAddress((URL)object6);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.client.Call.setOperation", "1044", this);
                throw new JAXRPCException(Messages.getMessage("cantSetURI00", "" + exception));
            }
        }
        BindingOperation bindingOperation = binding.getBindingOperation(string, string2, null);
        if (bindingOperation == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation02", string));
        }
        list2 = bindingOperation.getExtensibilityElements();
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            sOAPAddress = list2.get(i);
            if (!(sOAPAddress instanceof SOAPOperation)) continue;
            object6 = (SOAPOperation)((Object)sOAPAddress);
            object5 = object6.getSoapActionURI();
            if (object5 != null) {
                this.setUseSOAPAction(true);
                this.setSOAPActionURI((String)object5);
                break;
            }
            this.setUseSOAPAction(false);
            this.setSOAPActionURI(null);
            break;
        }
        if ((bindingInput = bindingOperation.getBindingInput()) != null) {
            list2 = bindingInput.getExtensibilityElements();
            for (int i = 0; list2 != null && i < list2.size(); ++i) {
                object6 = list2.get(i);
                if (object6 instanceof MIMEMultipartRelated) {
                    object5 = (MIMEMultipartRelated)object6;
                    object4 = null;
                    object3 = object5.getMIMEParts();
                    for (n = 0; object3 != null && n < object3.size() && object4 == null; ++n) {
                        object2 = (MIMEPart)object3.get(n);
                        object = object2.getExtensibilityElements();
                        for (int j = 0; object != null && j < object.size() && object4 == null; ++j) {
                            object4 = object.get(j);
                            if (object4 instanceof SOAPBody) continue;
                            object4 = null;
                        }
                    }
                    if (null != object4) {
                        object6 = object4;
                    }
                }
                if (!(object6 instanceof SOAPBody)) continue;
                object5 = (SOAPBody)object6;
                list2 = object5.getEncodingStyles();
                if (list2 != null && list2.size() > 0) {
                    this.setEncodingStyle((String)list2.get(0));
                }
                if ((object4 = object5.getNamespaceURI()) == null || ((String)object4).equals("")) break;
                this.setOperationName(QNameTable.createQName((String)object4, string));
                break;
            }
        }
        List list3 = operation.getParameterOrdering();
        object6 = operation.getInput();
        object5 = null;
        object4 = null;
        if (object6 != null) {
            object5 = object6.getMessage();
        }
        if (object5 != null) {
            object4 = object5.getOrderedParts(list3);
        }
        if (object4 != null) {
            for (int i = 0; i < object4.size(); ++i) {
                Part part = (Part)object4.get(i);
                if (part == null) continue;
                object2 = part.getName();
                object = part.getTypeName();
                if (object == null) {
                    object = part.getElementName();
                    if (object != null) {
                        object = QNameTable.createQName("java", "org.w3c.dom.Element");
                    } else {
                        throw new JAXRPCException(Messages.getMessage("typeNotSet00", (String)object2));
                    }
                }
                QName qName2 = QNameTable.createQName(((QName)object).getNamespaceURI(), ((QName)object).getLocalPart());
                ParameterMode parameterMode = ParameterMode.IN;
                this.addParameter((String)object2, qName2, parameterMode);
            }
        }
        object3 = operation.getOutput();
        object5 = null;
        object4 = null;
        if (object3 != null) {
            object5 = object3.getMessage();
        }
        if (object5 != null) {
            object4 = object5.getOrderedParts(null);
        }
        if (object3 != null && this.operation != null && this.operation.getNumParams() > 0) {
            this.setReturnType(Constants.WEBSERVICES_VOID);
        }
        if (object4 != null) {
            for (n = 0; n < object4.size(); ++n) {
                object2 = (Part)object4.get(n);
                if (list3 != null && list3.contains(object2.getName())) continue;
                object = object2.getTypeName();
                if (object == null) {
                    object = object2.getElementName();
                    if (object != null) {
                        object = QNameTable.createQName("java", "org.w3c.dom.Element");
                    } else {
                        throw new JAXRPCException(Messages.getMessage("typeNotSet00", "<return>"));
                    }
                }
                QName qName3 = QNameTable.createQName(((QName)object).getNamespaceURI(), ((QName)object).getLocalPart());
                this.setReturnType(qName3);
                break;
            }
        }
        this.loadOperationFromWSDL(qName.getLocalPart(), string);
        this.parmAndRetReq = false;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.setOperation()");
        }
    }

    public QName getPortName() {
        return this.msgContext.getPortName();
    }

    public void setPortName(QName qName) {
        this.msgContext.setPortName(qName);
    }

    public QName getPortTypeName() {
        QName qName = this.getPortName();
        return qName == null ? QNameTable.createQName("", "") : qName;
    }

    public void setPortTypeName(QName qName) {
        this.setPortName(qName);
    }

    public void setSOAPVersion(SOAPConstants sOAPConstants) {
        this.msgContext.setSOAPConstants(sOAPConstants);
    }

    public Object invoke(QName qName, Object[] objectArray) throws RemoteException {
        this.operation.setElementQName(qName);
        return this.invoke(objectArray);
    }

    public Object invoke(Object[] objectArray) throws RemoteException {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.invoke(Object[])  " + this.operation.getElementQName().toString());
        }
        if (!this.invokeOneWayCalled && this.operation.getReturnClass() == null) {
            this.setReturnType(Constants.WEBSERVICES_VOID);
        }
        if (this.operation.getElementQName() == null) {
            throw new WebServicesFault(Messages.getMessage("noOperation00"));
        }
        this.validateTargetEndpointAddress();
        this.syncProperties();
        try {
            QName qName;
            QName qName2 = qName = this.msgContext == null ? null : this.msgContext.getWSDLPort();
            if (this.wsdlQueryReloadOp && qName != null) {
                this.loadOperationFromWSDL(qName.getLocalPart(), this.operation.getElementQName().getLocalPart());
                this.wsdlQueryReloadOp = false;
            } else {
                this.copyOptionsFromWSDLOperation(qName, this.operation.getElementQName());
            }
            this.msgContext.protectProperties();
            if (this.cachedSessionContext != null) {
                this.msgContext.setProperty("com.ibm.ws.webservices.engine.session.context", this.cachedSessionContext);
            }
            Vector vector = this.connection.invoke(this.msgContext, objectArray, this.myHeaders, this.attachmentParts);
            Object object = this.msgContext.getProperty("com.ibm.ws.webservices.engine.session.context");
            if (object != null) {
                this.cachedSessionContext = (SessionContext)object;
            }
            this.msgContext.resetProperties();
            Object object2 = this.sortOutputs(vector);
            Class clazz = this.operation.getReturnClass();
            if (clazz != null) {
                object2 = JavaUtils.convert(object2, clazz);
            }
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Exit Call.invoke(Object[])");
            }
            return object2;
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.client.Call.invoke", "1335", this);
            throw webServicesFault;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.client.Call.invoke", "1339", this);
            if (entLog.isDebugEnabled()) {
                entLog.debug(Messages.getMessage("toWebServicesFault00"), exception);
            }
            throw new WebServicesFault(Messages.getMessage("errorInvoking00", "\n" + exception));
        }
    }

    private Object sortOutputs(Vector vector) throws WebServicesFault {
        Object object = null;
        this.outParams = new HashMap();
        this.outParamsList = new ArrayList();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            boolean bl = false;
            QName qName = this.operation.getReturnQName();
            if (!Constants.WEBSERVICES_VOID.equals(this.operation.getReturnType())) {
                if (qName == null) {
                    ParamValue paramValue = (ParamValue)vector.get(0);
                    object = paramValue.getValue();
                    n = 1;
                } else {
                    bl = true;
                }
            }
            for (int i = n; i < vector.size(); ++i) {
                ParamValue paramValue = (ParamValue)vector.get(i);
                Class clazz = this.getJavaTypeForQName(paramValue.getQName());
                Object object2 = paramValue.getValue();
                if (clazz != null && object2 != null && !clazz.isAssignableFrom(object2.getClass())) {
                    object2 = JavaUtils.convert(object2, clazz);
                }
                if (bl && qName.equals(paramValue.getQName())) {
                    object = object2;
                    bl = false;
                    continue;
                }
                this.outParams.put(paramValue.getQName().getLocalPart(), object2);
                this.outParamsList.add(object2);
            }
            if (bl) {
                String string = qName.toString();
                throw new WebServicesFault(Messages.getMessage("noReturnParam", string));
            }
        }
        return object;
    }

    private Class getJavaTypeForQName(QName qName) {
        ParameterDesc parameterDesc = this.operation.getOutputParamByQName(qName);
        return parameterDesc == null ? null : parameterDesc.getJavaType();
    }

    public void invokeOneWay(Object[] objectArray) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.invokeOneWay(Object[])");
        }
        if (this.operation.isOneway()) {
            try {
                this.invokeOneWayCalled = true;
                this.invoke(objectArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.client.Call.invokeOneWay", "1540", this);
                throw new JAXRPCException(exception.toString());
            }
            finally {
                this.invokeOneWayCalled = false;
                this.outParams = null;
                this.outParamsList = null;
            }
        } else {
            throw new JAXRPCException(Messages.getMessage("onewayInvalid"));
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.invokeOneWay(Object[])");
        }
    }

    public SOAPEnvelope invoke(SOAPEnvelope sOAPEnvelope) throws RemoteException {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.invoke(SOAPEnvelope)");
        }
        this.validateTargetEndpointAddress();
        try {
            QName qName;
            Message message = null;
            message = new Message(sOAPEnvelope);
            this.syncProperties();
            this.msgContext.setRequestMessage(message);
            QName qName2 = qName = this.msgContext == null ? null : this.msgContext.getWSDLPort();
            if (this.wsdlQueryReloadOp && qName != null) {
                this.loadOperationFromWSDL(qName.getLocalPart(), this.operation.getElementQName().getLocalPart());
                this.wsdlQueryReloadOp = false;
            } else {
                this.copyOptionsFromWSDLOperation(qName, this.operation.getElementQName());
            }
            this.msgContext.protectProperties();
            this.connection.invoke(this.msgContext, this.myHeaders, this.attachmentParts);
            message = this.msgContext.getResponseMessage();
            this.msgContext.resetProperties();
            if (message == null) {
                return null;
            }
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Exit Call.invoke(SOAPEnvelope)");
            }
            return message.getSOAPEnvelope();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.client.Call.invoke", "1519", this);
            if (exception instanceof WebServicesFault) {
                throw (WebServicesFault)exception;
            }
            if (entLog.isDebugEnabled()) {
                entLog.debug(Messages.getMessage("toWebServicesFault00"), exception);
            }
            throw new WebServicesFault(Messages.getMessage("errorInvoking00", "\n" + exception));
        }
    }

    public List invoke(SOAPBodyElement[] sOAPBodyElementArray) throws RemoteException {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.invoke(SOAPBodyElement[])");
        }
        if (!this.invokeOneWayCalled && this.operation.getReturnClass() == null) {
            this.setReturnType(Constants.WEBSERVICES_VOID);
        }
        SOAPEnvelope sOAPEnvelope = null;
        if (sOAPBodyElementArray != null && sOAPBodyElementArray.length > 0) {
            SOAPFactory sOAPFactory = sOAPBodyElementArray[0].getSOAPFactory();
            sOAPFactory.setSOAPConstants(this.msgContext.getSOAPConstants());
            try {
                int n;
                sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
                for (n = 0; n < sOAPBodyElementArray.length; ++n) {
                    sOAPEnvelope.getBody().addChildElement(sOAPBodyElementArray[n]);
                }
                if ((sOAPEnvelope = this.invoke(sOAPEnvelope)) == null) {
                    if (entLog.isDebugEnabled()) {
                        entLog.debug("No SOAP Response envelope; OK if request was one-way.  Was request one-way? " + this.invokeOneWayCalled);
                    }
                    if (this.invokeOneWayCalled) {
                        return null;
                    }
                    throw new WebServicesFault(Messages.getMessage("nullResponse00"));
                }
                ArrayList<SOAPElement> arrayList = new ArrayList<SOAPElement>();
                com.ibm.ws.webservices.engine.xmlsoap.SOAPBody sOAPBody = (com.ibm.ws.webservices.engine.xmlsoap.SOAPBody)sOAPEnvelope.getBody();
                for (n = 0; n < sOAPBody.getNumChildren(); ++n) {
                    arrayList.add(sOAPBody.getChildElement(n));
                }
                if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                    log.debug("Exit Call.invoke(SOAPBodyElement[])");
                }
                return arrayList;
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.client.Call.invoke", "1371", this);
                throw WebServicesFault.makeFault(sOAPException);
            }
        }
        if (this.operation.getElementQName() == null) {
            throw new WebServicesFault(Messages.getMessage("noOperation00"));
        }
        try {
            Vector vector = this.connection.invoke(this.msgContext, sOAPBodyElementArray, this.myHeaders, this.attachmentParts);
            ArrayList arrayList = (ArrayList)this.sortOutputs(vector);
            Class clazz = this.operation.getReturnClass();
            if (clazz != null) {
                arrayList = (ArrayList)JavaUtils.convert(arrayList, clazz);
            }
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Exit Call.invoke(SOAPBodyElement[])");
            }
            return arrayList;
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.client.Call.invoke", "1335", this);
            throw webServicesFault;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.client.Call.invoke", "1339", this);
            if (entLog.isDebugEnabled()) {
                entLog.debug(Messages.getMessage("toWebServicesFault00"), exception);
            }
            throw new WebServicesFault(Messages.getMessage("errorInvoking00", "\n" + exception));
        }
    }

    public void invokeOneWay(SOAPBodyElement[] sOAPBodyElementArray) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.invokeOneWay(SOAPBodyElement[])");
        }
        if (this.operation.isOneway()) {
            try {
                this.invokeOneWayCalled = true;
                this.invoke(sOAPBodyElementArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.client.Call.invokeOneWay", "1540", this);
                throw new JAXRPCException(exception.toString());
            }
            finally {
                this.invokeOneWayCalled = false;
            }
        } else {
            throw new JAXRPCException(Messages.getMessage("onewayInvalid"));
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.invokeOneWay(SOAPBodyElement[])");
        }
    }

    public Message getResponseMessage() {
        return this.msgContext.getResponseMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void addHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (this.myHeaders == null) {
            this.myHeaders = new Vector();
        }
        this.myHeaders.add(sOAPHeaderElement);
    }

    public void clearHeaders() {
        this.myHeaders = null;
    }

    private TypeMapping getTypeMapping() {
        TypeMapping typeMapping = this.msgContext.getTypeMapping();
        TypeMappingRegistry typeMappingRegistry = this.msgContext.getTypeMappingRegistry();
        if (typeMapping == null || typeMapping == typeMappingRegistry.getDefaultTypeMapping()) {
            typeMapping = (TypeMapping)typeMappingRegistry.createTypeMapping();
            typeMappingRegistry.register(this.msgContext.getEncodingStyle(), typeMapping);
        }
        if (!this.customBinderLoaded) {
            Boolean bl = (Boolean)this.getProperty("custom.binder.preload");
            if (bl == null) {
                bl = Boolean.TRUE;
            }
            if (bl.booleanValue()) {
                List list = (List)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Utils.loadCustomProviders(Thread.currentThread().getContextClassLoader());
                    }
                });
                Utils.populateTypeMapping(list, typeMapping);
                this.customBinderLoaded = true;
            }
        }
        return typeMapping;
    }

    public void registerTypeMapping(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) {
        this.registerTypeMapping(clazz, qName, serializerFactory, deserializerFactory, true);
    }

    public void registerTypeMapping(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory, boolean bl) {
        TypeMapping typeMapping = this.getTypeMapping();
        if (!bl && typeMapping.isRegistered(clazz, qName)) {
            return;
        }
        typeMapping.register(clazz, qName, serializerFactory, deserializerFactory);
    }

    public void registerTypeMapping(Class clazz, QName qName, Class clazz2, Class clazz3) {
        this.registerTypeMapping(clazz, qName, clazz2, clazz3, true);
    }

    public void registerTypeMapping(Class clazz, QName qName, Class clazz2, Class clazz3, boolean bl) {
        SerializerFactory serializerFactory = BaseSerializerFactory.createFactory(clazz2, clazz, qName);
        DeserializerFactory deserializerFactory = BaseDeserializerFactory.createFactory(clazz3, clazz, qName);
        if (serializerFactory != null || deserializerFactory != null) {
            this.registerTypeMapping(clazz, qName, serializerFactory, deserializerFactory, bl);
        }
    }

    public void setTransport(Transport transport2) {
        this.setTransport(transport2, null);
    }

    public void setTransport(Transport transport2, URL uRL) {
        this.connection = this.service.getConnection(transport2, uRL);
        this.msgContext.setTargetEndpointAddress(uRL);
    }

    public Object invoke(String string, Object[] objectArray) throws RemoteException {
        return this.invoke(QNameTable.createQName("", string), objectArray);
    }

    public Map getOutputParams() {
        if (this.outParams == null) {
            throw new JAXRPCException(Messages.getMessage("noOutputForGetOutput", "getOutputParams"));
        }
        return this.outParams;
    }

    public List getOutputValues() {
        if (this.outParamsList == null) {
            throw new JAXRPCException(Messages.getMessage("noOutputForGetOutput", "getOutputValues"));
        }
        return this.outParamsList;
    }

    public Service getService() {
        return this.service;
    }

    public void addAttachmentPart(Object object) {
        this.attachmentParts.add(object);
    }

    public void addFault(QName qName, Class clazz, QName qName2, QName qName3, QName qName4) {
        FaultDesc faultDesc = new FaultDesc();
        faultDesc.setFaultCode(qName);
        faultDesc.setClassName(clazz.getName());
        faultDesc.setPartXmlType(qName3);
        faultDesc.setPartQName(qName4);
        faultDesc.setMessageQName(qName2);
        this.operation.addFault(faultDesc);
    }

    public void addAttachmentParameter(QName qName, String string, Class clazz, ParameterMode parameterMode) {
        this.addParameter(qName, MimeUtils.getMIMETypeQName(string), clazz, parameterMode);
    }

    public void setAttachmentReturnType(String string, Class clazz) {
        this.setReturnType(MimeUtils.getMIMETypeQName(string), clazz);
    }

    private void syncProperties() {
        String string = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
        if (string != null) {
            if (this.msgContext != null) {
                this.msgContext.setOperationStyle(string);
            }
            this.operation.setStyle(Style.getStyle(string));
        }
        if ((string = (String)this.getProperty(OPERATION_USE_PROPERTY)) != null) {
            if (this.msgContext != null) {
                this.msgContext.setOperationUse(string);
            }
            this.operation.setUse(Use.getUse(string));
        }
        if ((string = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri")) != null && this.msgContext != null) {
            this.msgContext.setEncodingStyle(string);
        }
    }

    private void validateTargetEndpointAddress() throws NoEndPointException {
        if (this.connection == null) {
            throw new NoEndPointException();
        }
    }

    private WSDLQuery getWSDLQuery() {
        block8: {
            Definition definition;
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Entry Call.getWSDLQuery()");
            }
            if (!this.wsdlQueryUnavailable && this.wsdlQuery == null && (definition = this.service.getWSDLDefinition()) != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Attempting WSDLQuery.  doc base URI = " + definition.getDocumentBaseURI());
                    }
                    this.wsdlQueryUnavailable = false;
                    this.wsdlQuery = new WSDLQuery();
                    this.wsdlQuery.setLogToConsole(false);
                    Boolean bl = (Boolean)this.getProperty("noDataBinding");
                    String string = (String)this.getProperty("jaxrpcMappingFile");
                    if (bl != null) {
                        this.wsdlQuery.setNoDataBinding(bl);
                    }
                    if (string != null) {
                        this.wsdlQuery.setInputMappingFile(string);
                    }
                    WSDLFactoryImpl wSDLFactoryImpl = new WSDLFactoryImpl();
                    WSDLWriter wSDLWriter = wSDLFactoryImpl.newWSDLWriter();
                    Document document = wSDLWriter.getDocument(definition);
                    this.wsdlQuery.parse(definition.getDocumentBaseURI(), document, definition);
                }
                catch (Throwable throwable) {
                    this.wsdlQueryUnavailable = true;
                    this.wsdlQuery = null;
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Call:: WSDLQuery failed, exception ignored, processing continues. " + throwable.getMessage());
                }
            }
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.getWSDLQuery().  wsdlQuery = " + this.wsdlQuery);
        }
        return this.wsdlQuery;
    }

    private OperationDesc findOpDescInVector(Vector vector, String string) {
        OperationDesc operationDesc = null;
        for (int i = 0; i < vector.size() && operationDesc == null; ++i) {
            OperationDesc operationDesc2 = (OperationDesc)vector.get(i);
            if (!operationDesc2.getName().equals(string)) continue;
            operationDesc = operationDesc2;
        }
        return operationDesc;
    }

    private OperationDesc getWSDLQueryOperationDesc(String string, String string2) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.getWSDLQueryOperationsDesc()" + string2);
        }
        OperationDesc operationDesc = null;
        WSDLQuery wSDLQuery = this.getWSDLQuery();
        if (wSDLQuery != null) {
            Vector vector = null;
            if (string != null) {
                vector = wSDLQuery.getOperationDescs(string);
                if (vector != null) {
                    operationDesc = this.findOpDescInVector(vector, string2);
                }
            } else {
                HashMap hashMap = wSDLQuery.getOperationDescs();
                if (hashMap != null && hashMap.values() != null) {
                    Iterator iterator = hashMap.values().iterator();
                    while (iterator.hasNext() && operationDesc == null) {
                        vector = (Vector)iterator.next();
                        operationDesc = this.findOpDescInVector(vector, string2);
                    }
                }
            }
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.getWSDLQueryOperationsDesc(). OperationDesc : " + operationDesc);
        }
        return operationDesc;
    }

    public boolean loadOperationFromWSDL(String string, String string2) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.loadOperationsFromWSDL()" + string2);
        }
        boolean bl = true;
        OperationDesc operationDesc = this.getWSDLQueryOperationDesc(string, string2);
        if (operationDesc == null) {
            bl = false;
        } else {
            this.operation = operationDesc;
            this.msgContext.setOperation(operationDesc);
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.loadOperationsFromWSDL(). Return value is : " + bl);
        }
        return bl;
    }

    public boolean copyOptionsFromWSDLOperation(QName qName, QName qName2) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.copyOptionsFromWSDLOperation()" + qName2.toString());
        }
        boolean bl = true;
        String string = qName == null ? null : qName.getLocalPart();
        OperationDesc operationDesc = this.getWSDLQueryOperationDesc(string, qName2.getLocalPart());
        if (operationDesc == null) {
            this.operation.setOption(OperationDesc.WSDL_UNAVAILABLE, "true");
            String string2 = null;
            if (qName2 != null) {
                string2 = qName2.getNamespaceURI();
            } else if (qName != null) {
                string2 = qName.getNamespaceURI();
            }
            this.operation.setOption(OperationDesc.TARGET_NAMESPACE, string2);
            bl = false;
        } else if (operationDesc != this.operation) {
            Iterator iterator = operationDesc.getOptions().keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                this.operation.setOption(string3, operationDesc.getOption(string3));
            }
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.copyOptionsFromWSDLOperation(). Return value: " + bl);
        }
        return bl;
    }

    static {
        propertyNames.add("javax.xml.rpc.security.auth.username");
        propertyNames.add("javax.xml.rpc.security.auth.password");
        propertyNames.add("http.proxyHost");
        propertyNames.add("http.proxyPort");
        propertyNames.add("http.proxyUser");
        propertyNames.add("http.proxyPassword");
        propertyNames.add("https.proxyHost");
        propertyNames.add("https.proxyPort");
        propertyNames.add("https.proxyUser");
        propertyNames.add("https.proxyPassword");
        propertyNames.add("ssl.configName");
        propertyNames.add("http.redirect.enabled");
        propertyNames.add("javax.xml.rpc.session.maintain");
        propertyNames.add(ATTACHMENT_ENCAPSULATION_FORMAT);
        propertyNames.add("javax.xml.rpc.soap.operation.style");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.use");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.uri");
        propertyNames.add("javax.xml.rpc.encodingstyle.namespace.uri");
        propertyNames.add(OPERATION_USE_PROPERTY);
        propertyNames.add(TRANSPORT_NAME);
        propertyNames.add("javax.xml.rpc.service.endpoint.address");
    }
}

