/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Options;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public class AdminClient {
    protected static Log log = LogFactory.getLog(AdminClient.class.getName());
    private static ThreadLocal defaultConfiguration = new ThreadLocal();
    protected Call call;
    protected static final String ROOT_UNDEPLOY = WSDDConstants.QNAME_UNDEPLOY.getLocalPart();

    public static void setDefaultConfiguration(EngineConfiguration engineConfiguration) {
        defaultConfiguration.set(engineConfiguration);
    }

    public AdminClient() {
        try {
            EngineConfiguration engineConfiguration = (EngineConfiguration)defaultConfiguration.get();
            Service service = engineConfiguration != null ? new Service(engineConfiguration) : new Service();
            this.call = (Call)service.createCall();
        }
        catch (ServiceException serviceException) {
            FFDCFilter.processException((Throwable)serviceException, "com.ibm.ws.webservices.engine.client.AdminClient.AdminClient", "146", this);
            log.fatal(Messages.getMessage("couldntCall00"), serviceException);
            this.call = null;
        }
    }

    public Call getCall() {
        return this.call;
    }

    public String list(Options options) throws Exception {
        this.processOpts(options);
        return this.list();
    }

    public String list() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("doList00"));
        }
        String string = "<m:list xmlns:m=\"http://websphere.ibm.com/webservices/wsdd/\"/>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String quit(Options options) throws Exception {
        this.processOpts(options);
        return this.quit();
    }

    public String quit() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("doQuit00"));
        }
        String string = "<m:quit xmlns:m=\"http://websphere.ibm.com/webservices/wsdd/\"/>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String undeployHandler(String string) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("doQuit00"));
        }
        String string2 = "<m:" + ROOT_UNDEPLOY + " xmlns:m=\"" + "http://websphere.ibm.com/webservices/wsdd/" + "\">" + "<handler name=\"" + string + "\"/>" + "</m:" + ROOT_UNDEPLOY + ">";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String undeployPort(String string) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("doQuit00"));
        }
        String string2 = "<m:" + ROOT_UNDEPLOY + " xmlns:m=\"" + "http://websphere.ibm.com/webservices/wsdd/" + "\">" + "<port name=\"" + string + "\"/>" + "</m:" + ROOT_UNDEPLOY + ">";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String process(String[] stringArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Options options = new Options(stringArray);
        options.setDefaultURL("http://localhost:8080/web/services/AdminService");
        if (options.isFlagSet('d') > 0) {
            // empty if block
        }
        if ((stringArray = options.getRemainingArgs()) == null) {
            log.info(Messages.getMessage("usage00", "AdminClient xml-files | list"));
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            ByteArrayInputStream byteArrayInputStream = null;
            if (stringArray[i].equals("list")) {
                stringBuffer.append(this.list(options));
                continue;
            }
            if (stringArray[i].equals("quit")) {
                stringBuffer.append(this.quit(options));
                continue;
            }
            if (stringArray[i].equals("passwd")) {
                log.info(Messages.getMessage("changePwd00"));
                if (stringArray[i + 1] == null) {
                    log.error(Messages.getMessage("needPwd00"));
                    return null;
                }
                object = "<m:passwd xmlns:m=\"http://websphere.ibm.com/webservices/wsdd/\">";
                object = (String)object + stringArray[i + 1];
                object = (String)object + "</m:passwd>";
                byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
                ++i;
                stringBuffer.append(this.process(options, byteArrayInputStream));
                continue;
            }
            if (stringArray[i].indexOf(File.pathSeparatorChar) == -1) {
                log.info(Messages.getMessage("processFile00", stringArray[i]));
                stringBuffer.append(this.process(options, stringArray[i]));
                continue;
            }
            object = null;
            object = new StringTokenizer(stringArray[i], File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                log.info(Messages.getMessage("processFile00", string));
                stringBuffer.append(this.process(options, string));
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public void processOpts(Options options) throws Exception {
        if (this.call == null) {
            throw new Exception(Messages.getMessage("nullCall00"));
        }
        this.call.setTargetEndpointAddress(new URL(options.getURL()));
        this.call.setUsername(options.getUser());
        this.call.setPassword(options.getPassword());
        String string = options.isValueSet('t');
        if (string != null && !string.equals("")) {
            this.call.setProperty("transport_name", string);
        }
    }

    public String process(InputStream inputStream) throws Exception {
        return this.process(null, inputStream);
    }

    public String process(URL uRL) throws Exception {
        return this.process(null, uRL.openStream());
    }

    public String process(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        String string2 = this.process(null, fileInputStream);
        fileInputStream.close();
        return string2;
    }

    public String process(Options options, String string) throws Exception {
        this.processOpts(options);
        return this.process(string);
    }

    public String process(Options options, InputStream inputStream) throws Exception {
        if (this.call == null) {
            throw new Exception(Messages.getMessage("nullCall00"));
        }
        if (options != null) {
            this.processOpts(options);
        }
        this.call.setUseSOAPAction(true);
        this.call.setSOAPActionURI("AdminService");
        List list = null;
        Element element = XMLUtils.newDocument(inputStream).getDocumentElement();
        SOAPFactory sOAPFactory = new SOAPFactory();
        SOAPBodyElement sOAPBodyElement = sOAPFactory.createSOAPBodyElement(element.getNamespaceURI(), element.getLocalName());
        sOAPBodyElement.setPrefix(element.getPrefix());
        sOAPBodyElement.setAlternateContent(element);
        Object[] objectArray = new Object[]{sOAPBodyElement};
        list = (List)this.call.invoke(objectArray);
        inputStream.close();
        if (list == null || list.isEmpty()) {
            throw new WebServicesFault(Messages.getMessage("nullResponse00"));
        }
        SOAPBodyElement sOAPBodyElement2 = (SOAPBodyElement)list.get(0);
        return sOAPBodyElement2.toString();
    }

    public static void main(String[] stringArray) {
        try {
            AdminClient adminClient = new AdminClient();
            String string = adminClient.process(stringArray);
            if (string != null) {
                log.info(string);
            } else {
                System.exit(1);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.client.AdminClient.main", "375");
            log.error(Messages.getMessage("exception00"), exception);
            System.exit(1);
        }
    }
}

