/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.objectpool;

import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.ws.util.objectpool.ObjectFactory;
import com.ibm.ws.util.objectpool.ObjectPool;

public class CircularObjectPool
implements ObjectPool {
    private Object[] free;
    private ObjectFactory factory;
    private long[] timeFreed;
    private QuickApproxTime timer = QuickApproxTime.getRef();
    private int firstEntry;
    private int lastEntry;
    private int poolSize;
    private static int minPoolSize = 20;
    private static int batchSize = minPoolSize / 2;
    private boolean cleanUpOld = true;

    public CircularObjectPool(int n, ObjectFactory objectFactory) {
        this.factory = objectFactory;
        this.poolSize = n;
        this.free = new Object[this.poolSize];
        this.timeFreed = new long[this.poolSize];
        this.firstEntry = -1;
        this.lastEntry = -1;
        batchSize = minPoolSize / 2;
    }

    public CircularObjectPool(int n) {
        this(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Object object = null;
        CircularObjectPool circularObjectPool = this;
        synchronized (circularObjectPool) {
            if (this.lastEntry > -1) {
                object = this.free[this.lastEntry];
                this.free[this.lastEntry] = null;
                if (this.lastEntry == this.firstEntry) {
                    this.lastEntry = -1;
                    this.firstEntry = -1;
                } else {
                    this.lastEntry = this.lastEntry > 0 ? --this.lastEntry : this.poolSize - 1;
                }
            }
        }
        if (object == null && this.factory != null) {
            object = this.factory.create();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object) {
        Object object2 = null;
        long l = this.timer.getApproxTime();
        CircularObjectPool circularObjectPool = this;
        synchronized (circularObjectPool) {
            ++this.lastEntry;
            if (this.lastEntry == this.poolSize) {
                this.lastEntry = 0;
            }
            object2 = this.free[this.lastEntry];
            this.free[this.lastEntry] = object;
            this.timeFreed[this.lastEntry] = l;
            if (this.lastEntry == this.firstEntry) {
                ++this.firstEntry;
                if (this.firstEntry == this.poolSize) {
                    this.firstEntry = 0;
                }
            }
            if (this.firstEntry == -1) {
                this.firstEntry = this.lastEntry;
            }
            if (this.cleanUpOld) {
                while (this.firstEntry != this.lastEntry && l > this.timeFreed[this.firstEntry] + 60000L) {
                    this.free[this.firstEntry] = null;
                    ++this.firstEntry;
                    if (this.firstEntry != this.poolSize) continue;
                    this.firstEntry = 0;
                }
            }
        }
        return object2;
    }

    public void setCleanUpOld(boolean bl) {
        this.cleanUpOld = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getBatch() {
        Object[] objectArray = new Object[batchSize];
        CircularObjectPool circularObjectPool = this;
        synchronized (circularObjectPool) {
            objectArray[0] = this.get();
            for (int i = 1; this.getCurrentNumElements() > minPoolSize / 2 && i < batchSize; ++i) {
                objectArray[i] = this.get();
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putBatch(Object[] objectArray) {
        CircularObjectPool circularObjectPool = this;
        synchronized (circularObjectPool) {
            for (int i = 0; i < objectArray.length && objectArray[i] != null; ++i) {
                this.put(objectArray[i]);
            }
        }
    }

    private int getCurrentNumElements() {
        if (this.lastEntry == -1) {
            return 0;
        }
        if (this.lastEntry >= this.firstEntry) {
            return this.lastEntry - this.firstEntry + 1;
        }
        return this.lastEntry + 1 + (this.poolSize - this.firstEntry);
    }
}

