/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;

public abstract class TCPReadRequestContextImpl
extends TCPBaseRequestContext
implements TCPReadRequestContext {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl";
    protected static final int SYNC_READ = 0;
    protected static final int ASYNC_READ = 1;
    public static IOException readException = null;
    public static IOException readException2 = null;
    protected int jITAllocateSize = 0;
    protected boolean jITAllocateAction = false;
    private TCPReadCompletedCallback callback;
    private static final TraceComponent tc = Tr.register(TCPReadRequestContextImpl.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public TCPReadRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
        this.setRequestTypeRead(true);
    }

    public long read(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "read(" + l + "," + n + ")");
        }
        this.oTCPConnLink.incrementNumReads();
        if (this.config.getDumpStatsInterval() > 0) {
            ++this.oTCPConnLink.getTCPChannel().totalSyncReads;
        }
        this.checkForErrors(l, 0, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.oTCPConnLink.getSocketIOChannel().getSocket();
            Tr.event(tc, "read (sync) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress());
        }
        if (n == 0) {
            n = this.config.getInactivityTimeout();
        }
        if (n == -2) {
            this.immediateTimeout();
            return 0L;
        }
        if (this.config.getBlockingChannel() == 1) {
            long l2 = this.readRegularSocket(l, n);
            return l2;
        }
        long l3 = this.processSyncReadRequest(l, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "read ");
        }
        return l3;
    }

    public abstract long processSyncReadRequest(long var1, int var3) throws IOException;

    public VirtualConnection read(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "read(" + l + ",..," + bl + "," + n + ")");
        }
        this.oTCPConnLink.incrementNumReads();
        if (this.config.getDumpStatsInterval() > 0) {
            ++this.oTCPConnLink.getTCPChannel().totalAsyncReads;
        }
        this.checkForErrors(l, 1, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.oTCPConnLink.getSocketIOChannel().getSocket();
            Tr.event(tc, "read (async) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress());
        }
        return this.readInternal(l, tCPReadCompletedCallback, bl, n);
    }

    protected VirtualConnection readInternal(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readInternal(" + l + ",..," + bl + "," + n + ")");
        }
        if (n == -2) {
            this.immediateTimeout();
            return null;
        }
        this.setIOAmount(l);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setReadCompletedCallback(tCPReadCompletedCallback);
        this.setForceQueue(bl);
        this.setTimeoutTime(n);
        VirtualConnection virtualConnection = this.processAsyncReadRequest();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readInternal");
        }
        return virtualConnection;
    }

    public abstract VirtualConnection processAsyncReadRequest();

    private long readRegularSocket(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readRegularSocket(" + l + ")");
        }
        this.jITAllocateAction = false;
        this.setIOAmount(l);
        long l2 = 0L;
        SocketIOChannel socketIOChannel = this.oTCPConnLink.getSocketIOChannel();
        socketIOChannel.getSocket().setSoTimeout(n);
        int n2 = 0;
        n2 = socketIOChannel.attemptReadFromSocket(this, false);
        if (n2 == -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Throwing IOException");
            }
            if (readException2 == null) {
                readException2 = new IOException("Read (Blocking) failed.  End of data reached.");
            }
            throw readException2;
        }
        l2 = this.getIODoneAmount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readRegularSocket returning " + String.valueOf(l2));
        }
        return l2;
    }

    private void checkForErrors(long l, int n, int n2) {
        WsByteBuffer[] wsByteBufferArray;
        String string = null;
        if (this.config.getBlockingChannel() == 1) {
            if (n == 1) {
                string = "Async reads are not valid on blocking (regular socket) channels";
            } else if (n2 == -2) {
                string = "A cancel read, an immediate timeout of the previous read, can not be done on blocking (regular socket) channels";
            }
        }
        if (n2 == -2) {
            return;
        }
        if (l > maxReadSize) {
            string = "Number of bytes requested to read: " + l + " exceeds the maximum allowed for one read";
        } else if (l < 0L && n == 0 || l < 1L && n == 1) {
            string = "Number of bytes requested to read: " + l + " is less than minimum allowed (0 for sync, 1 for asynch)";
        } else if (this.jITAllocateSize > 0 && this.getBuffers() == null) {
            if (l > (long)this.jITAllocateSize) {
                string = "Number of bytes requested: " + l + " exceeds JIT allocated buffer size: " + this.jITAllocateSize;
            }
        } else if (this.getBuffers() == null || this.getBuffers().length == 0) {
            string = "No buffer(s) provided for reading data into";
        } else {
            wsByteBufferArray = this.getBuffers();
            long l2 = 0L;
            for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
                l2 += (long)(wsByteBufferArray[i].limit() - wsByteBufferArray[i].position());
            }
            if (l > l2 || l2 == 0L) {
                string = "Number of bytes requested: " + l + " exceeds space remaining in the buffers provided: " + l2;
            }
        }
        if (string != null) {
            wsByteBufferArray = new IllegalArgumentException(string);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, string);
            }
            FFDCFilter.processException((Throwable)wsByteBufferArray, CLASS_NAME, "100", this, this.buildDumpList());
            throw wsByteBufferArray;
        }
    }

    public void setJITAllocateSize(int n) {
        this.jITAllocateSize = n;
    }

    public int getJITAllocateSize() {
        return this.jITAllocateSize;
    }

    public boolean getJITAllocateAction() {
        return this.jITAllocateAction;
    }

    protected void setJITAllocateAction(boolean bl) {
        this.jITAllocateAction = bl;
    }

    protected void setReadCompletedCallback(TCPReadCompletedCallback tCPReadCompletedCallback) {
        this.callback = tCPReadCompletedCallback;
    }

    public TCPReadCompletedCallback getReadCompletedCallback() {
        return this.callback;
    }

    protected abstract void immediateTimeout();

    public ByteBuffer[] preProcessReadBuffers() {
        int n;
        WsByteBuffer[] wsByteBufferArray = this.getBuffers();
        boolean bl = false;
        for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
            if (wsByteBufferArray[n].isDirect() || !wsByteBufferArray[n].hasArray()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return this.getByteBufferArray();
        }
        try {
            for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
                ((WsByteBufferImpl)wsByteBufferArray[n]).setParmsToDirectBuffer();
            }
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading with Buffers which are not WsByteBufferImpl, may hurt performance");
            }
            return this.getByteBufferArray();
        }
        this.setBuffersToDirect(wsByteBufferArray);
        return this.getByteBufferArrayDirect();
    }

    public ByteBuffer preProcessOneReadBuffer() {
        WsByteBufferImpl wsByteBufferImpl = null;
        try {
            wsByteBufferImpl = (WsByteBufferImpl)this.getBuffer();
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading with a Buffer which is not a WsByteBufferImpl, may hurt performance");
            }
            return wsByteBufferImpl.getWrappedByteBuffer();
        }
        if (!wsByteBufferImpl.isDirect() && wsByteBufferImpl.hasArray()) {
            wsByteBufferImpl.setParmsToDirectBuffer();
            return wsByteBufferImpl.oWsBBDirect;
        }
        return wsByteBufferImpl.getWrappedByteBuffer();
    }

    public void postProcessReadBuffers(long l) {
        if (this.getByteBufferArrayDirect() == null) {
            try {
                if (!this.getBuffer().isDirect()) {
                    ((WsByteBufferImpl)this.getBuffer()).copyFromDirectBuffer((int)l);
                    return;
                }
                return;
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }
        long l2 = l;
        WsByteBuffer[] wsByteBufferArray = this.getBuffers();
        for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
            int n;
            block9: {
                n = wsByteBufferArray[i].remaining();
                if (!wsByteBufferArray[i].isDirect()) {
                    try {
                        if ((long)n < l2) {
                            ((WsByteBufferImpl)wsByteBufferArray[i]).copyFromDirectBuffer(n);
                            break block9;
                        }
                        ((WsByteBufferImpl)wsByteBufferArray[i]).copyFromDirectBuffer((int)l2);
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        return;
                    }
                }
                if ((long)n >= l2) break;
            }
            l2 -= (long)n;
        }
    }

    public String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer("TCPReadRequestContextImpl FFDC Data");
        stringBuffer.append("jITAllocateSize: " + this.jITAllocateSize);
        stringBuffer.append("jITAllocateAction: " + this.jITAllocateAction);
        String string = super.getFFDCDumpData();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

