/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.workloadcontroller;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.oa.EJSRootObjectAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.workloadcontroller.WorkloadCollaborator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.runtime.workloadcontroller.WorkloadRegulator;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class OrbWorkloadRegulator
extends WorkloadRegulator {
    public static final int SYSTEM = 1;
    public static final int EXISTING = 2;
    public static final int NONE = 3;
    public static final int NEW = 4;
    public static final int UNDEFINED = 0;
    public static final int ACTIVITY_SESSION = 1;
    public static final int JBROKER_SUPPORT = 2;
    public static final int EJB_CONTAINER = 3;
    public static final int WLM_SERVER_QUIESCE = 1229066304;
    private static OrbWorkloadRegulator _reg = null;
    private ORB orb = null;
    private int _requests = 0;
    private int _replies = 0;
    private boolean _fAdvanced = true;
    private boolean _fQuiesceRequested = false;
    private boolean _fQuiesceComplete = false;
    private boolean _fStartingMode = false;
    private boolean _fStartedMode = true;
    private Vector _collaborators = null;
    private boolean[] _votes = null;
    private long _lastRequestTime = 0L;
    private int _inactiveRequestTime = 5000;
    private static TraceComponent tc = Tr.register(OrbWorkloadRegulator.class);

    private OrbWorkloadRegulator(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "OrbWorkloadRequlator", string);
        }
        this._requests = 0;
        this._replies = 0;
        this._fQuiesceRequested = WorkloadController.inQuiesceMode();
        this._fQuiesceComplete = WorkloadController.inQuiesceCompleteMode();
        this._fStartingMode = WorkloadController.inStartingMode();
        this._fStartedMode = WorkloadController.inStartedMode();
        this._collaborators = new Vector();
        this._sName = string;
        this._type = 1;
        WorkloadController.registerRegulator(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "OrbWorkloadRegulator", string);
        }
    }

    protected static synchronized void create() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        if (_reg == null) {
            OrbWorkloadRegulator orbWorkloadRegulator;
            block7: {
                orbWorkloadRegulator = new OrbWorkloadRegulator("ORB");
                String string = System.getProperty("com.ibm.ejs.sm.server.quiesceInactiveRequestTime");
                if (string != null) {
                    try {
                        orbWorkloadRegulator._inactiveRequestTime = Integer.parseInt(string) * 1000;
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "create: setting quiesceInactiveRequestTime=" + orbWorkloadRegulator._inactiveRequestTime);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException(numberFormatException, "com.ibm.ws.runtime.workloadcontroller.OrbWorkloadRegulator.create", "195");
                        if (!tc.isEventEnabled()) break block7;
                        Tr.event(tc, "create: format exception: use default quiesceInactiveRequestTime=" + orbWorkloadRegulator._inactiveRequestTime);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create");
            }
            _reg = orbWorkloadRegulator;
        }
    }

    public static boolean isVoteNeeded(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isVoteNeeded", new Integer(n));
        }
        boolean bl = false;
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (OrbWorkloadRegulator._reg._fQuiesceRequested) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isVoteNeeded", new Boolean(bl));
        }
        return bl;
    }

    protected static void vote(int n, int n2) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "vote: voterID=" + n + " contextReceived=" + n2);
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        SystemException systemException = null;
        if (OrbWorkloadRegulator._reg._fQuiesceRequested && n2 != 1 && n2 != 2) {
            systemException = _reg.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "vote", systemException);
        }
        if (systemException != null) {
            throw systemException;
        }
    }

    protected static void handleRequest(ServerRequestInfo serverRequestInfo) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest:  ServerRequestInfo = " + serverRequestInfo);
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (serverRequestInfo.response_expected()) {
            _reg.incrOutstanding();
        }
        if (OrbWorkloadRegulator._reg._fQuiesceRequested) {
            OrbWorkloadRegulator.handleRequestForQuiesceRequestedMode(serverRequestInfo);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest: _fQuiesceRequested=true");
            }
            return;
        }
        if (OrbWorkloadRegulator._reg._fQuiesceComplete) {
            OrbWorkloadRegulator.handleRequestForQuiesceCompleteMode();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest: _fQuiesceComplete=true");
            }
            return;
        }
        if (OrbWorkloadRegulator._reg._fStartingMode) {
            OrbWorkloadRegulator.handleRequestForStartingMode();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest: _fStartingMode=true");
            }
            return;
        }
        if (OrbWorkloadRegulator._reg._fStartedMode) {
            OrbWorkloadRegulator.handleRequestForStartedMode();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest: _fStartedMode=true");
            }
            return;
        }
        OrbWorkloadRegulator.handleRequestForStartedMode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest: ");
        }
    }

    protected static void handleRequestForQuiesceRequestedMode(ServerRequestInfo serverRequestInfo) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequestForQuiesceRequestedMode");
        }
        boolean bl = false;
        OrbWorkloadRegulator._reg._lastRequestTime = System.currentTimeMillis();
        for (int i = 0; i < OrbWorkloadRegulator._reg._collaborators.size(); ++i) {
            WorkloadCollaborator workloadCollaborator = (WorkloadCollaborator)OrbWorkloadRegulator._reg._collaborators.elementAt(i);
            if (workloadCollaborator == null) continue;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "handleRequestForQuiesceRequestedMode: asking collaborator to vote ", new Object[]{workloadCollaborator});
            }
            bl = bl || workloadCollaborator.voteOnRequest(serverRequestInfo);
        }
        if (!bl) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "handleRequestForQuiesceRequestedMode: throw exception.");
            }
            SystemException systemException = _reg.getException();
            throw systemException;
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "handleRequestForQuiesceRequestedMode: someone voted to accept the request.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequestForQuiesceRequestedMode:  requests= " + OrbWorkloadRegulator._reg._requests + " replies= " + OrbWorkloadRegulator._reg._replies);
        }
    }

    protected static void handleRequestForQuiesceCompleteMode() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequestForQuiesceCompleteMode");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequestForQuiesceCompleteMode: throw exception.");
        }
        SystemException systemException = _reg.getException();
        throw systemException;
    }

    protected static void handleRequestForStartingMode() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequestForStartingMode");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequestForStartingMode");
        }
    }

    protected static void handleRequestForStartedMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequestForStartedMode");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequestForStartedMode:  requests= " + OrbWorkloadRegulator._reg._requests + " replies= " + OrbWorkloadRegulator._reg._replies);
        }
    }

    protected static void handleReply(ServerRequestInfo serverRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleReply");
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (serverRequestInfo.response_expected()) {
            _reg.decrOutstanding();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleReply: quiesceRequested=" + OrbWorkloadRegulator._reg._fQuiesceRequested + " requests=" + OrbWorkloadRegulator._reg._requests + " replies=" + OrbWorkloadRegulator._reg._replies);
        }
    }

    protected static void handleUserException(ServerRequestInfo serverRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleUserException");
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (serverRequestInfo.response_expected()) {
            _reg.decrOutstanding();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleUserException: quiesceRequested=" + OrbWorkloadRegulator._reg._fQuiesceRequested + " requests=" + OrbWorkloadRegulator._reg._requests + " replies=" + OrbWorkloadRegulator._reg._replies);
        }
    }

    public boolean quiesce() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesce: type= " + this.getName());
        }
        boolean bl = false;
        this._fQuiesceRequested = true;
        this._fQuiesceComplete = false;
        this._fStartingMode = false;
        this._fStartedMode = false;
        if (this._lastRequestTime == 0L) {
            this._lastRequestTime = System.currentTimeMillis();
        }
        long l = System.currentTimeMillis() - this._lastRequestTime;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "quiesce: milliseconds since last request=" + l);
        }
        bl = !this.requestsOutstanding() && l >= (long)this._inactiveRequestTime;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce: type= " + this.getName() + ": fRet=" + bl + " requests= " + this._requests + " replies= " + this._replies);
        }
        return bl;
    }

    public boolean starting() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "starting: type= " + this.getName());
        }
        boolean bl = true;
        this._fQuiesceRequested = false;
        this._fQuiesceComplete = false;
        this._fStartingMode = true;
        this._fStartedMode = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "starting: type= " + this.getName());
        }
        return bl;
    }

    public boolean started() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "started: type= " + this.getName());
        }
        boolean bl = true;
        this._fQuiesceRequested = false;
        this._fQuiesceComplete = false;
        this._fStartingMode = false;
        this._fStartedMode = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "started: type= " + this.getName());
        }
        return bl;
    }

    public boolean quiesceComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesceComplete: type= " + this.getName());
        }
        try {
            EJSRootObjectAdapter eJSRootObjectAdapter = null;
            if (this.orb != null) {
                eJSRootObjectAdapter = (EJSRootObjectAdapter)this.orb.getObjectResolver();
            }
            if (eJSRootObjectAdapter != null) {
                eJSRootObjectAdapter.quiesce(this.getException());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        boolean bl = true;
        this._fQuiesceComplete = true;
        this._fQuiesceRequested = false;
        this._fStartingMode = false;
        this._fStartedMode = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesceComplete: type= " + this.getName());
        }
        return bl;
    }

    public SystemException getException() {
        return new COMM_FAILURE(1229066304, CompletionStatus.COMPLETED_NO);
    }

    private boolean requestsOutstanding() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestsOutstanding", this.getName());
        }
        boolean bl = false;
        if (this._requests - this._replies > 0) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestsOutstanding: " + this.getName() + ": " + bl);
        }
        return bl;
    }

    private void incrOutstanding() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incrOutstanding", this.getName());
        }
        this._requests = this._requests == Integer.MAX_VALUE ? 1 : ++this._requests;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "incrOutstanding: " + this.getName() + ":  req=" + this._requests + " rep=" + this._replies);
        }
    }

    private void decrOutstanding() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrOutstanding", this.getName());
        }
        this._replies = this._replies == Integer.MAX_VALUE ? 1 : ++this._replies;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrOutstanding: " + this.getName() + ": req=" + this._requests + " rep=" + this._replies);
        }
    }

    public static synchronized void registerCollaborator(WorkloadCollaborator workloadCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCollaborator: ", new Object[]{workloadCollaborator});
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        OrbWorkloadRegulator._reg._collaborators.addElement(workloadCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCollaborator");
        }
    }

    public static OrbWorkloadRegulator getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return _reg;
    }

    public void setORB(ORB oRB) {
        this.orb = oRB;
    }

    private OrbWorkloadRegulator() {
    }
}

