/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

class URLStreamHandlerAdapter
implements URLStreamHandlerService {
    private URLStreamHandler urlStreamHandlerInstance;
    private String urlStreamHandlerClass;
    private String urlStreamHandlerClassPath;
    private String protocol;
    private ServiceRegistration registration;
    private static Method _equals;
    private static Method _getDefaultPort;
    private static Method _getHostAddress;
    private static Method _hashCode;
    private static Method _hostsEqual;
    private static Method _openConnection;
    private static Method _parseURL;
    private static Method _sameFile;
    private static Method _toExternalForm;
    private static Field _handlerField;
    private static TraceComponent tc;

    public URLStreamHandlerAdapter(String string, String string2, String string3) {
        block6: {
            this.urlStreamHandlerInstance = null;
            this.urlStreamHandlerClass = null;
            this.urlStreamHandlerClassPath = null;
            this.protocol = null;
            this.registration = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", new Object[]{string, string2, string3});
            }
            this.protocol = string;
            this.urlStreamHandlerClass = string2;
            this.urlStreamHandlerClassPath = string3;
            try {
                if (string2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to load URLStreamHandlerClass: " + string2);
                    }
                    this.urlStreamHandlerInstance = (URLStreamHandler)Class.forName(string2, true, StreamHandlerUtils.getResourceClassLoader(this.urlStreamHandlerClassPath, null)).newInstance();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found URLStreamHandlerClass: " + string2 + " for protocol: " + string);
                    }
                    this.registerInOSGi();
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Could not find URLStreamHandlerClass: " + string2 + " for protocol: " + string);
            }
        }
    }

    void destroy() {
        this.deregisterFromOSGi();
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        try {
            return (URLConnection)_openConnection.invoke(this.getInstance(), uRL);
        }
        catch (Exception exception) {
            this.log(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseURL(URLStreamHandlerSetter uRLStreamHandlerSetter, URL uRL, String string, int n, int n2) {
        URLStreamHandler uRLStreamHandler = null;
        try {
            uRLStreamHandler = (URLStreamHandler)_handlerField.get(uRL);
            _handlerField.set(uRL, this.getInstance());
            _parseURL.invoke(this.getInstance(), uRL, string, new Integer(n), new Integer(n2));
        }
        catch (Exception exception) {
            this.log(exception);
        }
        finally {
            if (uRLStreamHandler != null) {
                try {
                    _handlerField.set(uRL, uRLStreamHandler);
                }
                catch (Exception exception) {
                    this.log(exception);
                }
            }
        }
    }

    public String toExternalForm(URL uRL) {
        try {
            return (String)_toExternalForm.invoke(this.getInstance(), uRL);
        }
        catch (Exception exception) {
            this.log(exception);
            return null;
        }
    }

    public boolean equals(URL uRL, URL uRL2) {
        try {
            Boolean bl = (Boolean)_equals.invoke(this.getInstance(), uRL, uRL2);
            return bl;
        }
        catch (Exception exception) {
            this.log(exception);
            return false;
        }
    }

    public int getDefaultPort() {
        try {
            Integer n = (Integer)_getDefaultPort.invoke(this.getInstance(), null);
            return n;
        }
        catch (Exception exception) {
            this.log(exception);
            return 0;
        }
    }

    public InetAddress getHostAddress(URL uRL) {
        try {
            return (InetAddress)_getHostAddress.invoke(this.getInstance(), uRL);
        }
        catch (Exception exception) {
            this.log(exception);
            return null;
        }
    }

    public int hashCode(URL uRL) {
        try {
            Integer n = (Integer)_hashCode.invoke(this.getInstance(), uRL);
            return n;
        }
        catch (Exception exception) {
            this.log(exception);
            return uRL.hashCode();
        }
    }

    public boolean hostsEqual(URL uRL, URL uRL2) {
        try {
            Boolean bl = (Boolean)_hostsEqual.invoke(this.getInstance(), uRL, uRL2);
            return bl;
        }
        catch (Exception exception) {
            this.log(exception);
            return false;
        }
    }

    public boolean sameFile(URL uRL, URL uRL2) {
        try {
            Boolean bl = (Boolean)_sameFile.invoke(this.getInstance(), uRL, uRL2);
            return bl;
        }
        catch (Exception exception) {
            this.log(exception);
            return false;
        }
    }

    private void deregisterFromOSGi() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    private void registerInOSGi() {
        BundleContext bundleContext = BundleContextMap.instance().get(this.getClass().getClassLoader());
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        hashtable.put("url.handler.protocol", new String[]{this.protocol});
        this.registration = bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)this, hashtable);
    }

    private Object getInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException {
        return this.urlStreamHandlerInstance;
    }

    private void log(Exception exception) {
        FFDCFilter.processException((Throwable)exception, URLStreamHandlerAdapter.class.getName(), "346", this);
    }

    static {
        tc = Tr.register(URLStreamHandlerAdapter.class, "Runtime", "com.ibm.ws.runtime.runtime");
        try {
            _equals = URLStreamHandler.class.getDeclaredMethod("equals", URL.class, URL.class);
            _equals.setAccessible(true);
            _getDefaultPort = URLStreamHandler.class.getDeclaredMethod("getDefaultPort", null);
            _getDefaultPort.setAccessible(true);
            _getHostAddress = URLStreamHandler.class.getDeclaredMethod("getHostAddress", URL.class);
            _getHostAddress.setAccessible(true);
            _hashCode = URLStreamHandler.class.getDeclaredMethod("hashCode", URL.class);
            _hashCode.setAccessible(true);
            _hostsEqual = URLStreamHandler.class.getDeclaredMethod("hostsEqual", URL.class, URL.class);
            _hostsEqual.setAccessible(true);
            _openConnection = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
            _openConnection.setAccessible(true);
            _parseURL = URLStreamHandler.class.getDeclaredMethod("parseURL", URL.class, String.class, Integer.TYPE, Integer.TYPE);
            _parseURL.setAccessible(true);
            _sameFile = URLStreamHandler.class.getDeclaredMethod("sameFile", URL.class, URL.class);
            _sameFile.setAccessible(true);
            _toExternalForm = URLStreamHandler.class.getDeclaredMethod("toExternalForm", URL.class);
            _toExternalForm.setAccessible(true);
            _handlerField = URL.class.getDeclaredField("handler");
            _handlerField.setAccessible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

