/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.mbean;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasMessageImpl2;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.cbe.CBEHelper;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class RasLoggingServiceMBean
extends RuntimeCollaborator
implements WsHandler {
    public static final String NOTIFICATION_LOG_FATAL = "websphere.ras.fatal";
    public static final String NOTIFICATION_LOG_ERROR = "websphere.ras.error";
    public static final String NOTIFICATION_LOG_WARNING = "websphere.ras.warning";
    public static final String NOTIFICATION_LOG_AUDIT = "websphere.ras.audit";
    public static final String NOTIFICATION_LOG_SERVICE = "websphere.ras.service";
    public static final String NOTIFICATION_LOG_INFO = "websphere.ras.info";
    private long ntfySeqNum = 0L;
    private static boolean registered = false;

    public void setObjectName(ObjectName objectName) {
        super.setObjectName(objectName);
        RasLoggingServiceMBean.registerWithRas(this);
    }

    public String getMessageFilterLevel() {
        return ManagerAdmin.getMessageFilterLevel();
    }

    public void setMessageFilterLevel(String string) {
        ManagerAdmin.setMessageFilterLevel(string);
    }

    public Level getLevel() {
        return WsLevel.DETAIL;
    }

    public void processEvent(LogRecord logRecord) {
        int n = logRecord.getLevel().intValue();
        if (n < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[15]]) {
            this.sendEvent(NOTIFICATION_LOG_FATAL, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]]) {
            this.sendEvent(NOTIFICATION_LOG_ERROR, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]]) {
            this.sendEvent(NOTIFICATION_LOG_WARNING, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[11]]) {
            this.sendEvent(NOTIFICATION_LOG_AUDIT, logRecord);
        } else {
            this.sendEvent(NOTIFICATION_LOG_INFO, logRecord);
        }
    }

    private static synchronized void registerWithRas(RasLoggingServiceMBean rasLoggingServiceMBean) {
        if (registered) {
            return;
        }
        try {
            ManagerAdmin.addJmxListener(rasLoggingServiceMBean);
            registered = true;
        }
        catch (RasException rasException) {
            FFDCFilter.processException((Throwable)rasException, "com.ibm.ws.management.RasLoggingServiceMBean.registerWithRas", "193", rasLoggingServiceMBean);
        }
    }

    private void sendEvent(String string, LogRecord logRecord) {
        try {
            RasMessageImpl2 rasMessageImpl2 = RasLoggingServiceMBean.parseLogRec(logRecord);
            Notification notification = new Notification(string, this.getObjectName(), this.ntfySeqNum++);
            notification.setUserData(rasMessageImpl2);
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.RasLoggingServiceMBean.sendEvent", "203", this);
        }
    }

    private static RasMessageImpl2 parseLogRec(LogRecord logRecord) {
        CommonBaseEvent commonBaseEvent;
        String string = Integer.toHexString(logRecord.getThreadID());
        String string2 = RasMessageImpl2.convertSeverity(logRecord.getLevel().intValue());
        Locale locale = Locale.getDefault();
        String string3 = TraceLogFormatter.formatMessage(logRecord, locale, 0);
        String string4 = null;
        if (logRecord instanceof CommonBaseEventLogRecord && (commonBaseEvent = ((CommonBaseEventLogRecord)logRecord).getCommonBaseEvent()) != null) {
            string4 = CBEHelper.getExtendedDataElementString(commonBaseEvent, "DiagnosticProvider");
        }
        return new RasMessageImpl2(logRecord.getMillis(), string, string2, logRecord.getMessage(), logRecord.getParameters(), logRecord.getResourceBundleName(), logRecord.getLoggerName(), string3, locale.toString(), string4);
    }
}

