/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.models.base.resources.jdbc.WAS40ConnectionPool;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.advanced.cm.factory.DataSourceFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.ResourceBinderImpl;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.component.collaborator.JDBCResourceMBean;
import java.util.Properties;

public class WAS40DataSourceBinder
extends ResourceBinderImpl {
    private static final TraceComponent tc = Tr.register(WAS40DataSourceBinder.class, "ResourceBinders");

    public boolean isUsedFor(J2EEResourceFactory j2EEResourceFactory) {
        return j2EEResourceFactory instanceof WAS40DataSource;
    }

    public String getNamePrefix() {
        return "jdbc";
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory) throws ResourceBindingException {
        WAS40DataSource wAS40DataSource = (WAS40DataSource)j2EEResourceFactory;
        JDBCProvider jDBCProvider = (JDBCProvider)wAS40DataSource.getProvider();
        WAS40ConnectionPool wAS40ConnectionPool = wAS40DataSource.getConnectionPool();
        this.checkRequiredProperty(wAS40ConnectionPool, "Invalid Configuration! The DataSource: " + wAS40DataSource.getName() + " has a null ConnectionPool property.");
        Properties properties = new Properties();
        this.addPropertySet(properties, wAS40DataSource.getPropertySet());
        this.setProperty(properties, "name", wAS40DataSource.getName());
        this.setProperty(properties, "dataSourceClassName", jDBCProvider.getImplementationClassName());
        try {
            this.setProperty(properties, "databaseName", this.expandVariable(wAS40DataSource.getDatabaseName()));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.binder.WAS40DataSourceBinder.getBindingObject", "73", this);
            throw new ResourceBindingException((J2EEResourceFactory)wAS40DataSource, exception.toString());
        }
        this.setProperty(properties, "description", wAS40DataSource.getDescription());
        this.setProperty(properties, "minimumPoolSize", new Integer(wAS40ConnectionPool.getMinimumPoolSize()));
        this.setProperty(properties, "maximumPoolSize", new Integer(wAS40ConnectionPool.getMaximumPoolSize()));
        this.setProperty(properties, "connectionTimeout", new Long(wAS40ConnectionPool.getConnectionTimeout()));
        this.setProperty(properties, "idleTimeout", new Long(wAS40ConnectionPool.getIdleTimeout()));
        this.setProperty(properties, "orphanTimeout", new Long(wAS40ConnectionPool.getOrphanTimeout()));
        this.setProperty(properties, "statementCacheSize", new Long(wAS40ConnectionPool.getStatementCacheSize()));
        this.setProperty(properties, "user", wAS40DataSource.getDefaultUser());
        this.setProperty(properties, "password", wAS40DataSource.getDefaultPassword());
        this.setProperty(properties, "disableAutoConnectionCleanup", new Boolean(wAS40ConnectionPool.isDisableAutoConnectionCleanup()));
        this.addJ2EEHrefProperties(properties, j2EEResourceFactory);
        return DataSourceFactory.getBindableObject((Properties)properties);
    }

    protected void addJ2EEHrefProperties(Properties properties, J2EEResourceFactory j2EEResourceFactory) {
        MBeanFactory mBeanFactory = null;
        try {
            mBeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
            if (mBeanFactory != null) {
                this.setProperty(properties, "j2ee.resource.factory.href", mBeanFactory.getConfigId(j2EEResourceFactory));
                this.setProperty(properties, "j2ee.resource.provider.href", mBeanFactory.getConfigId(j2EEResourceFactory.getProvider()));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.binder.WAS40DataSourceBinder.addJ2EEHrefPropeties", "144", this);
        }
    }

    public void activateProviderMBean(J2EEResourceProvider j2EEResourceProvider, String string) {
        new JDBCResourceMBean((JDBCProvider)j2EEResourceProvider, string);
    }
}

