/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ws.management.util.PortConflictResolverException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PortConflictResolverNoTrace {
    private String[] configRoots;
    private Set reservedPorts;
    private SAXParser parser;
    private boolean sameHostNameAsDmgr = false;
    private String dmgrHostName = null;

    public PortConflictResolverNoTrace() throws PortConflictResolverException {
        this(null);
    }

    public PortConflictResolverNoTrace(String[] stringArray) throws PortConflictResolverException {
        this.configRoots = stringArray;
        this.reservedPorts = new HashSet();
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PortConflictResolverException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new PortConflictResolverException(sAXException);
        }
        this.readPortsFromAllConfigRoots();
    }

    public synchronized int getPort(int n) {
        int n2 = n;
        while (!this.reservePort(n2)) {
            ++n2;
        }
        return n2;
    }

    public String getReservedPorts() {
        return this.reservedPorts.toString();
    }

    public boolean reservePort(int n) {
        return this.reservePortInternal(Integer.toString(n));
    }

    protected boolean reservePortInternal(String string) {
        return this.reservedPorts.add(string);
    }

    public boolean unreservePort(int n) {
        return this.reservedPorts.remove(Integer.toString(n));
    }

    protected void readPortsFromAllConfigRoots() throws PortConflictResolverException {
        if (this.configRoots != null) {
            for (int i = 0; i < this.configRoots.length; ++i) {
                this.readPortsFromConfigRoot(this.configRoots[i]);
            }
        }
    }

    protected String[] getConfigRoots() {
        return this.configRoots;
    }

    protected void readPortsFromConfigRoot(String string) throws PortConflictResolverException {
        if (new File(string).exists()) {
            String string2 = this.getCellName(string);
            String[] stringArray = null;
            if (string2 != null) {
                stringArray = this.getNodeNames(string, string2);
            }
            if (stringArray != null) {
                this.readPorts(string, string2, stringArray);
            }
        }
    }

    private String getCellName(String string) {
        File file = new File(string, "cells");
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            return fileArray[i].getName();
        }
        return null;
    }

    private String[] getNodeNames(String string, String string2) {
        String string3;
        String string4 = string + "/cells/" + string2 + "/nodes";
        File file = new File(string4);
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory() || !new File(fileArray[i], "node.xml").exists()) continue;
            arrayList.add(fileArray[i]);
        }
        String[] stringArray = null;
        stringArray = arrayList.size() > 1 ? ((string3 = this.findDMgrNode(arrayList, string, string2)) != null ? this.filterNodesForDmgr(arrayList) : this.toFileNameArray(arrayList)) : this.toFileNameArray(arrayList);
        return stringArray;
    }

    private String[] filterNodesForDmgr(List list) {
        String[] stringArray = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            File file2 = new File(file, "/serverindex.xml");
            try {
                this.sameHostNameAsDmgr = false;
                this.parseServerIndexForSameHostNameAsDmgr(file2);
                if (!this.sameHostNameAsDmgr) continue;
                arrayList.add(file);
            }
            catch (PortConflictResolverException portConflictResolverException) {
                portConflictResolverException.printStackTrace();
            }
        }
        stringArray = this.toFileNameArray(arrayList);
        return stringArray;
    }

    private String[] toFileNameArray(List list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = ((File)iterator.next()).getName();
        }
        return stringArray;
    }

    private String findDMgrNode(List list, String string, String string2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.isDirectory() || !new File(file, "/servers/dmgr").exists()) continue;
            File file2 = new File(file, "/serverindex.xml");
            try {
                this.parseServerIndexForDmgrHost(file2);
            }
            catch (PortConflictResolverException portConflictResolverException) {
                portConflictResolverException.printStackTrace();
            }
            return file.getName();
        }
        return null;
    }

    protected void readPorts(String string, String string2, String[] stringArray) throws PortConflictResolverException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseServerIndex(new File(string + "/cells/" + string2 + "/nodes/" + stringArray[i] + "/serverindex.xml"));
        }
    }

    protected void parseServerIndex(File file) throws PortConflictResolverException {
        try {
            this.parser.parse(file, (DefaultHandler)new ServerIndexHandler());
        }
        catch (SAXException sAXException) {
            throw new PortConflictResolverException(sAXException);
        }
        catch (IOException iOException) {
            throw new PortConflictResolverException(iOException);
        }
    }

    protected void parseServerIndexForDmgrHost(File file) throws PortConflictResolverException {
        try {
            this.parser.parse(file, (DefaultHandler)new ServerIndexHandlerForDmgrHost());
        }
        catch (SAXException sAXException) {
            throw new PortConflictResolverException(sAXException);
        }
        catch (IOException iOException) {
            throw new PortConflictResolverException(iOException);
        }
    }

    protected void parseServerIndexForSameHostNameAsDmgr(File file) throws PortConflictResolverException {
        try {
            this.parser.parse(file, (DefaultHandler)new ServerIndexHandlerForSameHostNameAsDmgr());
        }
        catch (SAXException sAXException) {
            throw new PortConflictResolverException(sAXException);
        }
        catch (IOException iOException) {
            throw new PortConflictResolverException(iOException);
        }
    }

    class ServerIndexHandlerForSameHostNameAsDmgr
    extends DefaultHandler {
        ServerIndexHandlerForSameHostNameAsDmgr() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals("serverindex:ServerIndex")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("hostName") || !attributes.getValue(i).equals(PortConflictResolverNoTrace.this.dmgrHostName)) continue;
                    PortConflictResolverNoTrace.this.sameHostNameAsDmgr = true;
                }
            }
        }
    }

    class ServerIndexHandlerForDmgrHost
    extends DefaultHandler {
        ServerIndexHandlerForDmgrHost() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals("serverindex:ServerIndex")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("hostName")) continue;
                    PortConflictResolverNoTrace.this.dmgrHostName = attributes.getValue(i);
                }
            }
        }
    }

    class ServerIndexHandler
    extends DefaultHandler {
        ServerIndexHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals("endPoint")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("port")) continue;
                    PortConflictResolverNoTrace.this.reservePortInternal(attributes.getValue(i));
                }
            }
        }
    }
}

