/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.AbstractStatusReport;
import com.ibm.ws.management.status.ExecutionState;
import com.ibm.ws.management.status.NodeAgentStatusReport;
import com.ibm.ws.management.status.StatusReport;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeploymentManagerStatusReport
extends AbstractStatusReport
implements Serializable {
    private static final long serialVersionUID = 31678516957423592L;
    protected Map node_states;
    protected Map node_reports;
    protected Map cluster_states;
    protected static final TraceComponent tc = Tr.register(DeploymentManagerStatusReport.class.getName(), null, null);

    public DeploymentManagerStatusReport(Map map, Map map2, Map map3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentManagerStatusReport", new Object[]{map, map2, map3});
        }
        this.type = 2;
        this.node_states = new Hashtable(map);
        this.node_reports = new Hashtable(map2);
        this.cluster_states = new Hashtable(map3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Building list of backlevel nodes for use by app_state", map);
        }
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node: ", string);
            }
            String string2 = ExecutionState.transition((String)entry.getValue());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "State for Node: ", string2);
            }
            Object v = map2.get(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Report for Node: ", v);
            }
            if (!"ExecutionState.STARTED".equals(string2) || v != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node: " + string + " + is backlevel");
            }
            this.node_states.put(entry.getKey(), "BACK_LEVEL");
            this._back_level_nodes.add(entry.getKey());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentManagerStatusReport", new Object[]{this.timestamp});
        }
    }

    public String getClusterState(String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterState", new Object[]{string});
        }
        if ("ExecutionState.UNKNOWN".equals(string2 = ExecutionState.transition((String)this.cluster_states.get(string)))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterState", "ExecutionState.UNAVAILABLE");
            }
            return "ExecutionState.UNAVAILABLE";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterState", string2);
        }
        return string2;
    }

    public String getApplicationState(String string, String string2, String string3) {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationState", new Object[]{string, string2, string3});
        }
        if ("BACK_LEVEL".equals(string4 = ExecutionState.transition((String)this.node_states.get(string2)))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node is backlevel", string2);
            }
            StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Application");
            stringBuffer.append(",name=");
            stringBuffer.append(string);
            stringBuffer.append(",node=");
            stringBuffer.append(string2);
            stringBuffer.append(",process=");
            stringBuffer.append(string3);
            stringBuffer.append(",*");
            ObjectName objectName = this.getMBean(stringBuffer.toString());
            if (objectName != null) {
                return "ExecutionState.STARTED";
            }
            return "ExecutionState.STOPPED";
        }
        NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string2);
        if (nodeAgentStatusReport == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationState", new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        String string5 = nodeAgentStatusReport.getApplicationState(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationState", new Object[]{string5});
        }
        return string5;
    }

    public String getMessageListenerState(String string, String string2, String string3) {
        String string4;
        block13: {
            String string5;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMessageListenerState", new Object[]{string, string2, string3});
            }
            if ("BACK_LEVEL".equals(string5 = ExecutionState.transition((String)this.node_states.get(string2)))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node is backlevel", string2);
                }
                StringBuffer stringBuffer = new StringBuffer("WebSphere:type=ListenerPort,node=");
                stringBuffer.append(string2);
                stringBuffer.append(",name=");
                stringBuffer.append(string);
                stringBuffer.append(",process=");
                stringBuffer.append(string3);
                stringBuffer.append(",*");
                ObjectName objectName = this.getMBean(stringBuffer.toString());
                if (objectName != null) {
                    Boolean bl = (Boolean)this.getMBeanAttribute(objectName, "started");
                    if (bl != null) {
                        if (bl.booleanValue()) {
                            return "ExecutionState.STARTED";
                        }
                        return "ExecutionState.STOPPED";
                    }
                    return "ExecutionState.STARTED";
                }
                return "ExecutionState.STOPPED";
            }
            NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string2);
            if (nodeAgentStatusReport == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMessageListenerState", new Object[]{"ExecutionState.UNAVAILABLE"});
                }
                return "ExecutionState.UNAVAILABLE";
            }
            string4 = null;
            try {
                string4 = nodeAgentStatusReport.getMessageListenerState(string, string2, string3);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusReport.getMessageListenerState", "176", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception was thrown found", exception);
                }
            }
            catch (Error error) {
                FFDCFilter.processException((Throwable)error, "com.ibm.ws.management.status.DeploymentManagerStatusReport.getMessageListenerState", "181", this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Error occured", error);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageListenerState", new Object[]{string4});
        }
        return string4;
    }

    public String getServerType(String string, String string2) {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType", new Object[]{string, string2});
        }
        if ("BACK_LEVEL".equals(string3 = ExecutionState.transition((String)this.node_states.get(string)))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Back Level node - returning  " + string3, string);
            }
            return string3;
        }
        NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NodeAgentStatusReport", nodeAgentStatusReport);
        }
        if (nodeAgentStatusReport == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerType", null);
            }
            return null;
        }
        String string4 = nodeAgentStatusReport.getServerType(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", string4);
        }
        return string4;
    }

    public String getServerState(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerState", new Object[]{string, string2});
        }
        if (string2.equals("nodeagent")) {
            return this.getNodeState(string);
        }
        String string3 = ExecutionState.transition((String)this.node_states.get(string));
        if ("BACK_LEVEL".equals(string3)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node is backlevel", string);
            }
            StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Server");
            stringBuffer.append(",process=" + string2);
            stringBuffer.append(",node=" + string);
            stringBuffer.append(",*");
            ObjectName objectName = this.getMBean(stringBuffer.toString());
            Tr.debug(tc, "ServerON", objectName);
            if (objectName != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.STARTED"});
                }
                return "ExecutionState.STARTED";
            }
            String string4 = this.getNodeState(string);
            if ("ExecutionState.STARTED".equals(string4)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.STOPPED"});
                }
                return "ExecutionState.STOPPED";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string);
        if (nodeAgentStatusReport == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        String string5 = nodeAgentStatusReport.getServerState(string, string2);
        if (string5 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerState", new Object[]{"ExecutionState.STOPPED"});
            }
            return "ExecutionState.STOPPED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerState", new Object[]{string3});
        }
        return string5;
    }

    public String print() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Deployment Manager: ");
        stringBuffer.append("\n");
        stringBuffer.append("---------------------\n");
        Set set = this.cluster_states.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append("App: ");
            stringBuffer.append(object.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(object.getValue());
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        object = this.node_states.entrySet();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            stringBuffer.append("\nNode: ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append("\nReport: ");
            stringBuffer.append(this.node_reports.get(entry.getKey()));
            if (this.node_reports.get(entry.getKey()) != null) {
                stringBuffer.append(((StatusReport)this.node_reports.get(entry.getKey())).print());
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        stringBuffer.append("END OF DUMP");
        return stringBuffer.toString();
    }

    public String getNodeState(String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeState", new Object[]{string});
        }
        if ("BACK_LEVEL".equals(string2 = ExecutionState.transition((String)this.node_states.get(string)))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node is backlevel", string);
            }
            StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Server");
            stringBuffer.append(",process=nodeagent");
            stringBuffer.append(",node=" + string);
            stringBuffer.append(",*");
            ObjectName objectName = this.getMBean(stringBuffer.toString());
            if (objectName != null) {
                return "ExecutionState.STARTED";
            }
            return "ExecutionState.STOPPED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeState", new Object[]{string2});
        }
        return string2;
    }

    public String[] getNodes() {
        String[] stringArray = this.node_states.keySet().toArray(new String[0]);
        return stringArray;
    }

    public String[] getServers(String string) {
        NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string);
        return nodeAgentStatusReport.getServers(string);
    }

    public ObjectName getMBean(String string) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMBean", new Object[]{string});
            }
            try {
                ObjectName objectName = new ObjectName(string);
                Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
                if (iterator.hasNext()) {
                    ObjectName objectName2 = (ObjectName)iterator.next();
                    if (iterator.hasNext() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Multiple MBeans found when only one was expected");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMBean", new Object[]{objectName2});
                    }
                    return objectName2;
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", "371", this);
                Tr.error(tc, "Invalid MBean filter passed to getMBean: " + string);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                FFDCFilter.processException((Throwable)outOfMemoryError, "com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", "374", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Target Server is out of memory!", outOfMemoryError);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", "377", this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Exception occured", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean - null");
        }
        return null;
    }

    public Object getMBeanAttribute(ObjectName objectName, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanAttribute", new Object[]{objectName, string});
        }
        Object object = null;
        try {
            object = AdminServiceFactory.getAdminService().getAttribute(objectName, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", "393", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanAttribute", object);
        }
        return object;
    }
}

