/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.collaborator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.IllegalStateTransitionException;
import com.ibm.ws.management.collaborator.StatisticsProviderCollaborator;
import java.util.ArrayList;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public class J2EEManagedObjectCollaborator
extends StatisticsProviderCollaborator {
    private static TraceComponent tc = Tr.register(J2EEManagedObjectCollaborator.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    public static final int STATE_STARTING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPING = 2;
    public static final int STATE_STOPPED = 3;
    public static final int STATE_FAILED = 4;
    public static final String[] STATE_NAMES = new String[]{"STARTING", "RUNNING", "STOPPING", "STOPPED", "FAILED"};
    public static final String ATTR_CHANGED_NOTIF_TYPE = "j2ee.attribute.changed";
    private static final String[] STATE_NOTIF_TYPES = new String[]{"j2ee.state.starting", "j2ee.state.running", "j2ee.state.stopping", "j2ee.state.stopped", "j2ee.state.failed"};
    private boolean isEventProvider = false;
    private boolean isStateManageable = false;
    private String[] eventTypes = null;
    private int currentState = 3;
    private long startTime = 0L;
    private long nextSeqNum = 0L;

    public J2EEManagedObjectCollaborator() {
    }

    public J2EEManagedObjectCollaborator(int n) {
        this.currentState = n;
    }

    public String getObjectNameStr() {
        return this.getObjectName().toString();
    }

    public boolean isEventProvider() {
        return this.isEventProvider;
    }

    public boolean isStateManageable() {
        return this.isStateManageable;
    }

    public String[] getEventTypes() {
        return this.eventTypes;
    }

    public int getJ2EEState() {
        return this.currentState;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void changeState(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeState", STATE_NAMES[n]);
        }
        if (this.currentState == n) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "changeState");
            }
            return;
        }
        switch (this.currentState) {
            case 0: {
                if (n == 1 || n == 4 || n == 2) break;
                this.throwIllegalStateChangeException(n);
                break;
            }
            case 1: {
                if (n == 4 || n == 2) break;
                this.throwIllegalStateChangeException(n);
                break;
            }
            case 2: {
                if (n == 4 || n == 3) break;
                this.throwIllegalStateChangeException(n);
                break;
            }
            case 3: {
                if (n == 0) break;
                this.throwIllegalStateChangeException(n);
                break;
            }
            case 4: {
                if (n == 2 || n == 0) break;
                this.throwIllegalStateChangeException(n);
            }
        }
        if (n == 1) {
            this.startTime = System.currentTimeMillis();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Changing " + this.getObjectName() + " from state " + STATE_NAMES[this.currentState] + " to state " + STATE_NAMES[n]);
        }
        this.currentState = n;
        this.emitStateChangeNotification();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeState");
        }
    }

    private void throwIllegalStateChangeException(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Illegal state change on " + this.getObjectName() + " from state " + STATE_NAMES[this.currentState] + " to state " + STATE_NAMES[n]);
        }
        throw new IllegalStateTransitionException(this.currentState, n);
    }

    private void emitStateChangeNotification() {
        try {
            this.sendNotification(new Notification(STATE_NOTIF_TYPES[this.currentState], this.getObjectName(), this.nextSeqNum++));
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator.emitStateChangeNotification", "198", this);
        }
    }

    public void bindMBean(ModelMBeanInfo modelMBeanInfo, ModelMBean modelMBean) throws Exception {
        super.bindMBean(modelMBeanInfo, modelMBean);
        Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
        if (descriptor != null) {
            Object object = null;
            object = descriptor.getFieldValue("eventProvider");
            if (object != null && object.equals(Boolean.TRUE)) {
                this.isEventProvider = true;
                this.eventTypes = this.getEventTypes(modelMBeanInfo);
            }
            if ((object = descriptor.getFieldValue("stateManageable")) != null && object.equals(Boolean.TRUE)) {
                this.isStateManageable = true;
            }
        }
        this.modelMBean.addAttributeChangeNotificationListener(new NotificationListener(){

            public void handleNotification(Notification notification, Object object) {
                Notification notification2 = new Notification(J2EEManagedObjectCollaborator.ATTR_CHANGED_NOTIF_TYPE, notification.getSource(), notification.getSequenceNumber(), notification.getTimeStamp(), notification.getMessage());
                notification2.setUserData(notification.getUserData());
                try {
                    J2EEManagedObjectCollaborator.this.modelMBean.sendNotification(notification2);
                }
                catch (MBeanException mBeanException) {
                    FFDCFilter.processException((Throwable)mBeanException, "com.ibm.websphere.management.J2EEManagedObjectCollaborator.handleNotification", "242", this);
                    Tr.warning(tc, "ADMN0014W", (Object)new Object[]{J2EEManagedObjectCollaborator.ATTR_CHANGED_NOTIF_TYPE, mBeanException});
                }
            }
        }, null, null);
    }

    private String[] getEventTypes(ModelMBeanInfo modelMBeanInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MBeanNotificationInfo[] mBeanNotificationInfoArray = modelMBeanInfo.getNotifications();
        for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
            String[] stringArray = mBeanNotificationInfoArray[i].getNotifTypes();
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

