/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCBodyReadCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCReadAhead;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCReadCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCWriteCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.exception.IllegalRequestObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.ExpectationFailedException;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;

public class HttpOutboundServiceContextImpl
extends HttpServiceContextImpl
implements HttpOutboundServiceContext {
    private static final TraceComponent tc = Tr.register(HttpOutboundServiceContextImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    protected static final int CALLBACK_STATE_IDLE = 0;
    protected static final int CALLBACK_STATE_PENDING = 1;
    protected static final int CALLBACK_STATE_ERROR = 2;
    protected static final int CALLBACK_STATE_COMPLETE = 4;
    protected static final int READ_STATE_IDLE = 0;
    protected static final int READ_STATE_TIME_RESET = 1;
    protected static final int READ_STATE_SYNC = 3;
    protected static final int READ_STATE_ASYNC = 4;
    private HttpOutboundLink myLink = null;
    private int[] positionList = null;
    private int callback_state = 0;
    private int read_state = 0;
    private Object readAheadSyncer = new Object();
    protected Object stateSyncObject = new Object();
    private IOException readException = null;
    private boolean bReadAheadEnabled = false;
    private boolean bImmediateRead = false;
    private boolean bTempResponsesUsed = false;
    private boolean bEarlyReads = false;
    private int numResponsesReceived = 0;

    public HttpOutboundServiceContextImpl(TCPConnectionContext tCPConnectionContext, HttpOutboundLink httpOutboundLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        this.init(tCPConnectionContext, httpOutboundLink, virtualConnection, httpChannelConfig);
        this.setBodyRC(HttpOSCBodyReadCallback.getRef());
        this.positionList = new int[this.getPendingBuffers().length];
    }

    public void init(TCPConnectionContext tCPConnectionContext, HttpOutboundLink httpOutboundLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing OSC: " + this);
        }
        this.init(tCPConnectionContext, httpChannelConfig);
        this.setBodyRC(HttpOSCBodyReadCallback.getRef());
        this.setLink(httpOutboundLink);
        this.setVC(virtualConnection);
        this.getVC().getStateMap().put(CallbackIDs.CALLBACK_HTTPOSC, this);
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying OSC: " + this);
        }
        this.getVC().getStateMap().remove(CallbackIDs.CALLBACK_HTTPOSC);
        super.destroy();
        this.myLink = null;
        this.readException = null;
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing OSC: " + this);
        }
        if (null != this.getLink()) {
            this.getLink().clear();
        }
        super.clear();
        this.setReadBuffer(null);
        this.getReadSC().setBuffers(null);
        this.callback_state = 0;
        this.read_state = 0;
        this.readException = null;
        this.bReadAheadEnabled = false;
        this.bImmediateRead = false;
        this.bTempResponsesUsed = false;
        this.bEarlyReads = false;
        this.numResponsesReceived = 0;
        this.getVC().getStateMap().remove("HTTPFinalWrite");
    }

    protected void reConnect(VirtualConnection virtualConnection, IOException iOException) {
        if (this.getLink().isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting reconnect: " + this.getLink().getVirtualConnection());
            }
            this.getReadSC().setBuffers(null);
            this.getLink().reConnectAsync(iOException);
        } else {
            this.callErrorCallback(virtualConnection, iOException);
        }
    }

    void callErrorCallback(VirtualConnection virtualConnection, IOException iOException) {
        this.setPersistent(false);
        if (this.bEarlyReads && null != this.getAppReadCallback()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Early read failure calling error() on appside");
            }
            this.getAppReadCallback().error(virtualConnection, iOException);
        } else if (null != this.getAppWriteCallback()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling write.error() on appside");
            }
            this.getAppWriteCallback().error(virtualConnection, iOException);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No appside, closing connection");
            }
            this.getLink().getDeviceLink().close(virtualConnection, iOException);
        }
    }

    protected void reConnect(IOException iOException) throws IOException {
        if (this.getLink().isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting synchronous reconnect");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reconnect sync not allowed");
            }
            this.setPersistent(false);
            throw iOException;
        }
        this.getReadSC().setBuffers(null);
        this.getLink().reConnectSync(iOException);
        this.nowReconnectedSync(iOException);
    }

    protected WsByteBuffer[] getBuffList() {
        int n;
        if (!this.getLink().isReconnectAllowed()) {
            return super.getBuffList();
        }
        int n2 = this.getPendingStop();
        int n3 = n2 - (n = this.getPendingStart());
        if (0 == n3) {
            return null;
        }
        WsByteBuffer[] wsByteBufferArray = this.getPendingBuffers();
        WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[n3];
        if (this.positionList.length < wsByteBufferArray.length) {
            int[] nArray = new int[wsByteBufferArray.length];
            System.arraycopy(this.positionList, 0, nArray, 0, this.positionList.length);
            this.positionList = nArray;
        }
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            wsByteBufferArray2[i] = wsByteBufferArray[n4];
            this.positionList[n4] = wsByteBufferArray[n4].position();
            ++n4;
        }
        this.setPendingStart(n2);
        return wsByteBufferArray2;
    }

    private boolean resetWriteBuffers() {
        int n = this.getPendingStop();
        WsByteBuffer[] wsByteBufferArray = this.getPendingBuffers();
        if (null == this.positionList || null == wsByteBufferArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error in resetBuffers: posList: " + this.positionList + " list: " + wsByteBufferArray);
            }
            this.getWriteSC().setBuffer(null);
            return false;
        }
        for (int i = 0; i < n; ++i) {
            wsByteBufferArray[i].position(this.positionList[i]);
        }
        this.getWriteSC().setBuffers(wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reset positions on (" + n + ") write buffers");
        }
        return true;
    }

    protected void nowReconnectedAsync() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reconnected async for " + this);
        }
        if (!this.resetWriteBuffers()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting buffers (async) failed");
            }
            IOException iOException = new IOException("Failed reconnect");
            if (null != this.getAppWriteCallback()) {
                this.getAppWriteCallback().error(this.getVC(), iOException);
            } else {
                this.getLink().getDeviceLink().close(this.getVC(), iOException);
            }
            return;
        }
        this.setPersistent(true);
        this.updatePersistence(this.getRequestImpl());
        this.resetRead();
        VirtualConnection virtualConnection = this.getWriteSC().write(-1L, HttpOSCWriteCallback.getRef(), this.isForceAsync(), this.getWriteTimeout());
        if (null != virtualConnection) {
            if (!this.isMessageSent()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling callback.complete of app channel.");
                }
                this.getAppWriteCallback().complete(this.getLink().getVirtualConnection());
            } else {
                if (this.isReadAheadEnabled()) {
                    this.bReadAheadEnabled = false;
                }
                this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
                this.getReadSC().read(1L, HttpOSCReadCallback.getRef(), true, this.getReadTimeout());
            }
        }
    }

    protected void nowReconnectedSync(IOException iOException) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reconnected sync for " + this);
        }
        if (!this.resetWriteBuffers()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting buffers (sync) failed");
            }
            throw iOException;
        }
        this.setPersistent(true);
        this.updatePersistence(this.getRequestImpl());
        if (this.isReadAheadEnabled()) {
            this.bReadAheadEnabled = false;
        }
        try {
            this.getWriteSC().write(-1L, this.getWriteTimeout());
        }
        catch (IOException iOException2) {
            this.setPersistent(false);
            throw iOException2;
        }
    }

    public boolean disallowRewrites() {
        boolean bl = this.getLink().disallowRewrites();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Rewrites disabled: " + bl);
        }
        return bl;
    }

    public boolean allowRewrites() {
        boolean bl = this.getLink().allowRewrites();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Rewrites enabled: " + bl);
        }
        return bl;
    }

    public boolean isInboundConnection() {
        return false;
    }

    private VirtualConnection startEarlyRead(InterChannelCallback interChannelCallback, boolean bl) {
        this.getLink().disallowRewrites();
        this.setAppReadCallback(interChannelCallback);
        if (this.headersParsed() && !this.getResponseImpl().isTemporaryStatusCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "earlyRead: Final response already received.");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.headersParsed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "earlyRead: Message exists, isOwner: " + this.isResponseOwner());
            }
            this.resetMsgParsedState();
            if (!this.isResponseOwner()) {
                this.setMyResponse(null);
                this.getResponseImpl();
            } else {
                this.getResponseImpl().clear();
            }
        }
        VirtualConnection virtualConnection = this.parseResponseMessageAsync();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "earlyRead: return vc=" + virtualConnection);
        }
        if (null != virtualConnection && bl) {
            interChannelCallback.complete(this.getVC());
            return null;
        }
        return virtualConnection;
    }

    public VirtualConnection readNextResponse(InterChannelCallback interChannelCallback, boolean bl) {
        if (null == interChannelCallback) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readNext: Invalid null callback as input.");
            }
            throw new NullPointerException("Null callback");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "App channel requesting next response on " + this.getVC());
            Tr.debug(tc, "Async forcequeue flag is " + bl);
        }
        this.bTempResponsesUsed = true;
        return this.startEarlyRead(interChannelCallback, bl);
    }

    public void registerEarlyRead(InterChannelCallback interChannelCallback) {
        if (null == interChannelCallback) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "registerEarlyRead: Invalid null callback as input.");
            }
            throw new IllegalArgumentException("Callback is null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "App channel requesting early response read on " + this.getVC());
        }
        this.bEarlyReads = true;
        this.startEarlyRead(interChannelCallback, true);
    }

    public boolean deregisterEarlyRead() {
        if (!this.bEarlyReads) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "User tried to deregister non-existent early read");
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "User deregistering early read interest");
        }
        this.bEarlyReads = false;
        super.cancelOutstandingRead();
        if (this.isMessageSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error: full request already sent");
            }
            return false;
        }
        return true;
    }

    protected boolean isEarlyRead() {
        return this.bEarlyReads;
    }

    public void readAsyncResponse() {
        VirtualConnection virtualConnection = null;
        if (!this.isReadDataAvailable() && null == this.getNextReadBuffer()) {
            this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false);
            virtualConnection = this.getReadSC().read(1L, HttpOSCReadCallback.getRef(), true, this.getReadTimeout());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readAsyncResponse found existing data");
            }
            virtualConnection = this.getVC();
        }
        if (null != virtualConnection && null != this.parseResponseMessageAsync()) {
            this.handleParsedMessage();
        }
    }

    public void readSyncResponse() throws IOException {
        do {
            this.parseResponseMessageSync();
            int n = this.getResponse().getStatusCodeAsInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readSyncReponse: code is " + n);
            }
            if (this.isImmediateReadEnabled()) {
                return;
            }
            if (!this.getResponseImpl().isTemporaryStatusCode()) {
                return;
            }
            if (this.bTempResponsesUsed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "readSyncResponse: using temp response");
                }
                return;
            }
            if (this.getRequestImpl().isExpect100Continue()) {
                if (100 != n) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expect 100-continue failed with " + n);
                    }
                    this.setPersistent(false);
                    throw new ExpectationFailedException(n + " " + this.getResponseImpl().getReasonPhrase());
                }
                if (1 == this.numberResponsesReceived() && this.isHeadersSentState()) {
                    this.resetRead();
                    return;
                }
            }
            this.resetRead();
        } while (this.numberResponsesReceived() <= this.getHttpConfig().getLimitOnNumberOfResponses());
        this.setPersistent(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readSyncResponse: too many responses: " + this.numberResponsesReceived());
        }
        throw new IOException("Max temp responses received: " + this.numberResponsesReceived());
    }

    public HttpRequestMessage getRequest() {
        return this.getRequestImpl();
    }

    private final HttpRequestMessageImpl getRequestImpl() {
        if (null == this.getMyRequest()) {
            this.setMyRequest(this.getObjectFactory().getRequest(this));
        }
        return this.getMyRequest();
    }

    public HttpResponseMessage getResponse() {
        return this.getResponseImpl();
    }

    private final HttpResponseMessageImpl getResponseImpl() {
        if (null == this.getMyResponse()) {
            this.setMyResponse(this.getObjectFactory().getResponse(this));
        }
        return this.getMyResponse();
    }

    public void setRequest(HttpRequestMessage httpRequestMessage) throws IllegalRequestObjectException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRequest");
        }
        if (null == httpRequestMessage) {
            throw new IllegalRequestObjectException("Illegal null message");
        }
        HttpRequestMessageImpl httpRequestMessageImpl = null;
        try {
            httpRequestMessageImpl = (HttpRequestMessageImpl)httpRequestMessage;
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non msg impl passed to setRequest");
            }
            throw new IllegalRequestObjectException("Invalid message provided");
        }
        if (null != this.getMyRequest() && this.isRequestOwner()) {
            this.getMyRequest().destroy();
        }
        this.setMyRequest(httpRequestMessageImpl);
        VersionValues versionValues = httpRequestMessageImpl.getVersionValue();
        this.getMyRequest().init(this);
        this.getMyRequest().setVersion(versionValues);
        this.updatePersistence(this.getMyRequest());
        this.getResponseImpl().setHeaderChangeLimit(this.getMyRequest().getHeaderChangeLimit());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRequest");
        }
    }

    public void sendRequestHeaders() throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestHeaders(sync)");
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendHeaders(this.getRequestImpl());
        }
        catch (IOException iOException) {
            this.reConnect(iOException);
        }
        if (this.shouldReadResponseImmediately()) {
            this.startResponseReadSync();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestHeaders(sync)");
        }
    }

    public VirtualConnection sendRequestHeaders(InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestHeaders(async)");
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.getLink().setAllowReconnect(true);
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendHeaders(this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (null != virtualConnection && this.shouldReadResponseImmediately()) {
            virtualConnection = this.startResponseRead();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestHeaders(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    public void sendRequestBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestBody(sync)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendOutgoing(wsByteBufferArray, this.getRequestImpl());
        }
        catch (IOException iOException) {
            this.reConnect(iOException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestBody(sync)");
        }
    }

    public VirtualConnection sendRequestBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestBody(async)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.getLink().setAllowReconnect(true);
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendOutgoing(wsByteBufferArray, this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestBody(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    public void sendRawRequestBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRawRequestBody(sync)");
        }
        this.setRawBody(true);
        this.sendRequestBody(wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRawRequestBody(sync)");
        }
    }

    public VirtualConnection sendRawRequestBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRawRequestBody(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.sendRequestBody(wsByteBufferArray, interChannelCallback, bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRawRequestBody(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    public void finishRequestMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRequestMessage(sync)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getRequestImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting partial body false");
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendFullOutgoing(wsByteBufferArray, this.getRequestImpl());
        }
        catch (IOException iOException) {
            this.reConnect(iOException);
        }
        if (this.bEarlyReads) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "finishRequestMessage(sync): early read is active");
            }
            return;
        }
        if (this.headersParsed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Response headers already parsed");
            }
            if (this.bTempResponsesUsed || !this.getResponseImpl().isTemporaryStatusCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishRequestMessage(sync): already parsed");
                }
                return;
            }
            this.resetRead();
            this.readSyncResponse();
        } else {
            this.startResponseReadSync();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRequestMessage(sync)");
        }
    }

    public VirtualConnection finishRequestMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRequestMessage(async)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getRequestImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting partial body false");
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.setForceAsync(bl);
        this.getLink().setAllowReconnect(true);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendFullOutgoing(wsByteBufferArray, this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (null != virtualConnection) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Request write completed immediately.");
            }
            if (this.bEarlyReads) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishRequestMessage(async): early read is active");
                }
                return this.getVC();
            }
            if (this.headersParsed()) {
                if (this.bTempResponsesUsed || !this.getResponseImpl().isTemporaryStatusCode()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "finishRequestMessage(async): already parsed");
                    }
                    return this.getVC();
                }
                this.resetRead();
                this.readAsyncResponse();
                virtualConnection = null;
            } else {
                virtualConnection = this.startResponseRead();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRequestMessage(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    public void finishRawRequestMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRawRequestMessage(sync)");
        }
        this.setRawBody(true);
        this.finishRequestMessage(wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRawRequestMessage(sync)");
        }
    }

    public VirtualConnection finishRawRequestMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRawRequestMessage(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.finishRequestMessage(wsByteBufferArray, interChannelCallback, bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRawRequestMessage(async)");
        }
        return virtualConnection;
    }

    private HttpInvalidMessageException checkRequestValidity() {
        if (this.shouldReadResponseImmediately()) {
            return null;
        }
        int n = this.getRequest().getContentLength();
        int n2 = this.getNumBytesWritten();
        if (-1 != n && n2 != n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Request had content-length of " + n + " but sent " + n2);
            }
            this.setPersistent(false);
            return new HttpInvalidMessageException("Request length " + n + " but sent " + n2);
        }
        return null;
    }

    protected void handleParsedMessage() {
        InterChannelCallback interChannelCallback = null;
        interChannelCallback = this.bEarlyReads || this.bTempResponsesUsed ? this.getAppReadCallback() : this.getAppWriteCallback();
        VirtualConnection virtualConnection = null;
        do {
            ++this.numResponsesReceived;
            if (!this.getResponseImpl().isTemporaryStatusCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Notifying app channel of final response.");
                }
                interChannelCallback.complete(this.getVC());
                return;
            }
            int n = this.getResponseImpl().getStatusCodeAsInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received response (#" + this.numberResponsesReceived() + "): " + n);
            }
            if (this.numberResponsesReceived() > this.getHttpConfig().getLimitOnNumberOfResponses()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Too many async temp responses received.");
                }
                interChannelCallback.error(this.getVC(), new IOException("Max temp responses received: " + this.numberResponsesReceived()));
                return;
            }
            if (this.bTempResponsesUsed) {
                interChannelCallback.complete(this.getVC());
                return;
            }
            if (this.getRequestImpl().isExpect100Continue()) {
                if (100 != n) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expect 100-continue failed with " + n);
                    }
                    this.setPersistent(false);
                    interChannelCallback.error(this.getVC(), new ExpectationFailedException(n + " " + this.getResponseImpl().getReasonPhrase()));
                    return;
                }
                if (1 == this.numberResponsesReceived() && this.isHeadersSentState()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Notifying channel of first 100-continue");
                    }
                    interChannelCallback.complete(this.getVC());
                    return;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring temporary response...");
            }
            this.resetRead();
            virtualConnection = this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false) ? this.getVC() : this.getReadSC().read(1L, HttpOSCReadCallback.getRef(), false, this.getReadTimeout());
            if (null == virtualConnection) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting a parse of response data.");
            }
            virtualConnection = this.parseResponseMessageAsync();
        } while (null != virtualConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtualConnection startResponseRead() {
        HttpInvalidMessageException httpInvalidMessageException;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startResponseRead");
        }
        if (null != (httpInvalidMessageException = this.checkRequestValidity())) {
            this.getAppWriteCallback().error(this.getVC(), httpInvalidMessageException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "startResponseRead: error");
            }
            return null;
        }
        if (this.isReadAheadEnabled() && 1 != this.getReadState()) {
            int n = 0;
            Object object = this.stateSyncObject;
            synchronized (object) {
                n = this.getCallbackState();
                this.setReadState(4);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Async response read, callback state: " + n);
            }
            switch (n) {
                case 4: {
                    this.readAsyncResponse();
                    break;
                }
                case 2: {
                    this.setPersistent(false);
                    this.reConnect(this.getVC(), this.readException);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unexpected state (" + n + ") during async readahead");
                    }
                    this.setPersistent(false);
                    this.reConnect(this.getVC(), new IOException("Read-ahead state failure"));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "startResponseRead: read-ahead");
            }
            return null;
        }
        if (this.bEarlyReads || this.bTempResponsesUsed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "startResponseRead: temp resp env");
            }
            this.getAppWriteCallback().complete(this.getVC());
            return null;
        }
        this.getResponseImpl();
        this.readAsyncResponse();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startResponseRead");
        }
        return null;
    }

    VirtualConnection parseResponseMessageAsync() {
        VirtualConnection virtualConnection = null;
        try {
            do {
                if (this.parseMessage()) {
                    return this.getVC();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reading for more data to parse");
                }
                this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false);
            } while (null != (virtualConnection = this.getReadSC().read(1L, HttpOSCReadCallback.getRef(), false, this.getReadTimeout())));
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while parsing response: " + exception);
            }
            this.setPersistent(false);
            if (this.bEarlyReads || this.bTempResponsesUsed) {
                this.getAppReadCallback().error(this.getVC(), exception);
            } else {
                this.getAppWriteCallback().error(this.getVC(), exception);
            }
            return null;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private void parseResponseMessageSync() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResponseReadSync() throws IOException {
        HttpInvalidMessageException httpInvalidMessageException;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startResponseReadSync");
        }
        if (null != (httpInvalidMessageException = this.checkRequestValidity())) {
            throw httpInvalidMessageException;
        }
        if (this.isReadAheadEnabled() && 1 != this.getReadState()) {
            int n = 0;
            Object object = this.stateSyncObject;
            synchronized (object) {
                n = this.getCallbackState();
                this.setReadState(3);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Sync response read, callback state: " + n);
            }
            switch (n) {
                case 4: {
                    break;
                }
                case 2: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Read-ahead reports previous failure");
                    }
                    if (null == this.readException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Callback indicates error but no exception");
                        }
                        throw new IOException("Bad read-ahead state");
                    }
                    throw this.readException;
                }
                case 1: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for read-ahead to finish");
                    }
                    while (1 == this.getCallbackState()) {
                        try {
                            object = this.readAheadSyncer;
                            synchronized (object) {
                                this.readAheadSyncer.wait(2 * this.getHttpConfig().getReadTimeout());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Read-ahead block wait timed out");
                        }
                    }
                    if (null == this.readException) break;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Read-ahead reports new failure");
                    }
                    throw this.readException;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unexpected state (" + n + ") during sync readahead");
                    }
                    throw new IOException("Read-ahead state failure: " + n);
                }
            }
        }
        this.getResponseImpl();
        this.readSyncResponse();
    }

    private boolean checkBodyValidity() throws IOException {
        if (this.isImmediateReadEnabled() || this.bEarlyReads) {
            if (!this.headersParsed()) {
                IOException iOException = new IOException("Request headers not sent yet");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempt to read response prior to sendRequest");
                }
                throw iOException;
            }
        } else if (!this.isMessageSent()) {
            IOException iOException = new IOException("Request not finished yet");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read response prior to finishRequest");
            }
            throw iOException;
        }
        return this.isIncomingBodyValid();
    }

    public WsByteBuffer[] getResponseBodyBuffers() throws IOException, IllegalHttpBodyException {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getResponseBodyBuffers(sync)");
            }
            if (!this.checkBodyValidity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffers(sync): No body allowed");
                }
                return null;
            }
            this.setMultiRead(true);
            if (!this.isBodyComplete()) {
                try {
                    this.readBodyBuffers(this.getResponseImpl(), false);
                }
                catch (BodyCompleteException bodyCompleteException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getResponseBodyBuffers(sync): BodyCompleteException");
                    }
                    return null;
                }
                catch (IllegalHttpBodyException illegalHttpBodyException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Unexpected exception: " + illegalHttpBodyException);
                }
            }
        }
        WsByteBuffer[] wsByteBufferArray = this.getAllStorageBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseBodyBuffers(sync): " + (null == wsByteBufferArray ? 0 : wsByteBufferArray.length));
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getResponseBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseBodyBuffers(async)");
        }
        try {
            if (!this.checkBodyValidity() || this.incomingBuffersReady()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffers(async): read not needed");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffers(async): error=" + iOException);
            }
            return null;
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffers(async): body complete");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(interChannelCallback);
        this.setForceAsync(bl);
        this.setMultiRead(true);
        try {
            if (!this.readBodyBuffers(this.getResponseImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffers(async): read already");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodybuffers(async): exception: " + iOException);
            }
            interChannelCallback.error(this.getVC(), iOException);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseBodyBuffers(async): null");
        }
        return null;
    }

    public WsByteBuffer getResponseBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseBodyBuffer(sync)");
        }
        if (!this.checkBodyValidity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffer(sync): No body allowed");
            }
            return null;
        }
        this.setMultiRead(false);
        WsByteBuffer wsByteBuffer = this.getNextBuffer();
        if (null == wsByteBuffer && !this.isBodyComplete()) {
            block9: {
                try {
                    this.readBodyBuffer(this.getResponseImpl(), false);
                }
                catch (BodyCompleteException bodyCompleteException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getResponseBodyBuffer(sync): BodyCompleteException");
                    }
                    return null;
                }
                catch (IllegalHttpBodyException illegalHttpBodyException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Unexpected exception: " + illegalHttpBodyException);
                }
            }
            wsByteBuffer = this.getNextBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseBodyBuffer(sync): " + wsByteBuffer);
        }
        return wsByteBuffer;
    }

    public VirtualConnection getResponseBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseBodyBuffer(async)");
        }
        try {
            if (!this.checkBodyValidity() || this.incomingBuffersReady()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffer(async): read not needed");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffer(async): error " + iOException);
            }
            return null;
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffer(async): body complete");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(interChannelCallback);
        this.setForceAsync(bl);
        this.setMultiRead(false);
        try {
            if (!this.readBodyBuffer(this.getResponseImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResponseBodyBuffer(async): read finished");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getResponseBodyBuffer(async): exception: " + iOException);
            }
            interChannelCallback.error(this.getVC(), iOException);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseBodyBuffer(async): null");
        }
        return null;
    }

    public WsByteBuffer getRawResponseBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawResponseBodyBuffer(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer wsByteBuffer = this.getResponseBodyBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawResponseBodyBuffer(sync): " + wsByteBuffer);
        }
        return wsByteBuffer;
    }

    public WsByteBuffer[] getRawResponseBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawResponseBodyBuffers(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer[] wsByteBufferArray = this.getResponseBodyBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawResponseBodyBuffers(sync): " + wsByteBufferArray);
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getRawResponseBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawResponseBodyBuffer(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.getResponseBodyBuffer(interChannelCallback, bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawResponseBodyBuffer(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    public VirtualConnection getRawResponseBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawResponseBodyBuffers(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.getResponseBodyBuffers(interChannelCallback, bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawResponseBodyBuffers(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    protected boolean readUntilEnd(boolean bl) throws IllegalHttpBodyException, BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Called readUntilEnd");
        }
        if (!this.isReadDataAvailable()) {
            try {
                if (this.fillABuffer(1, bl, false)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception: " + iOException);
                }
                return false;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "End of body found in new buffer");
                }
                return false;
            }
        }
        int n = this.getReadBuffer().position();
        int n2 = this.getReadBuffer().limit();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Current body buffer " + this.getReadBuffer());
        }
        if (0 == n && n2 == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Return a full buffer");
            }
            this.storeTempBuffer(this.returnLastBuffer());
            this.setReadBuffer(null);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Slice the return buffer");
            }
            this.storeTempBuffer(this.getReadBuffer().slice());
            this.getReadBuffer().position(n2);
        }
        return false;
    }

    protected final HttpBaseMessageImpl getMessageBeingParsed() {
        return this.getResponseImpl();
    }

    protected final HttpBaseMessageImpl getMessageBeingSent() {
        return this.getRequestImpl();
    }

    public final HttpOutboundLink getLink() {
        return this.myLink;
    }

    private final void setLink(HttpOutboundLink httpOutboundLink) {
        this.myLink = httpOutboundLink;
    }

    protected boolean reconnectAllowed() {
        return this.getLink().isReconnectAllowed();
    }

    public HttpObjectFactory getObjectFactory() {
        return null == this.getLink() ? null : this.getLink().getObjectFactory();
    }

    protected WsByteBuffer createChunkHeader(byte[] byArray) {
        if (!this.getLink().isReconnectAllowed()) {
            return super.createChunkHeader(byArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OSC creating chunk length buffer");
        }
        WsByteBuffer wsByteBuffer = this.allocateBuffer(32);
        wsByteBuffer.put(byArray);
        wsByteBuffer.put(BNFHeaders.EOL);
        wsByteBuffer.flip();
        return wsByteBuffer;
    }

    protected WsByteBuffer createChunkTrailer() {
        if (!this.getLink().isReconnectAllowed()) {
            return super.createChunkTrailer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OSC creating chunk trailer");
        }
        WsByteBuffer wsByteBuffer = this.allocateBuffer(32);
        wsByteBuffer.put(CHUNK_TRAILER_DATA);
        wsByteBuffer.flip();
        return wsByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerReadAhead(InterChannelCallback interChannelCallback, int n) {
        int n2;
        int n3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Read-ahead requested (timeout=" + n + ") " + this.getVC());
        }
        if (-1 > n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid timeout used by caller.");
            }
            return false;
        }
        Object object = this.stateSyncObject;
        synchronized (object) {
            n3 = this.getCallbackState();
            n2 = this.getReadState();
            this.setCallbackState(1, null);
        }
        if (0 != n3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Callback state is invalid: " + n3);
            }
            return false;
        }
        if (0 != n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read for response state is invalid: " + n2);
            }
            return false;
        }
        this.bReadAheadEnabled = true;
        int n4 = -1 == n ? this.getReadTimeout() : n;
        this.setAppReadCallback(interChannelCallback);
        this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
        this.getReadSC().read(1L, HttpOSCReadAhead.getRef(), true, n4);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "App channel called init: " + this);
        }
        int n = 0;
        int n2 = 0;
        if (this.isReadAheadEnabled()) {
            Object object = this.stateSyncObject;
            synchronized (object) {
                n = this.getCallbackState();
                n2 = this.getReadState();
                this.setReadState(1);
            }
        }
        if (0 == n) {
            return true;
        }
        if (1 != n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Callback state indicates error: " + n);
            }
            return false;
        }
        if (0 != n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read for response state indicates error: " + n2);
            }
            return false;
        }
        return super.cancelOutstandingRead();
    }

    protected int getCallbackState() {
        return this.callback_state;
    }

    protected void setCallbackState(int n, IOException iOException) {
        this.callback_state = n;
        this.readException = iOException;
    }

    protected int getReadState() {
        return this.read_state;
    }

    protected void setReadState(int n) {
        this.read_state = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeupReadAhead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Received synchronous read-ahead wake-up call.");
        }
        Object object = this.readAheadSyncer;
        synchronized (object) {
            this.readAheadSyncer.notify();
        }
    }

    private int numberResponsesReceived() {
        return this.numResponsesReceived;
    }

    private boolean isReadAheadEnabled() {
        return this.bReadAheadEnabled;
    }

    protected boolean isImmediateReadEnabled() {
        return this.bImmediateRead;
    }

    public boolean enableImmediateResponseRead() {
        if (this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Request hdrs already sent, too late for immediate read");
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Immediate response read requested: " + this.getVC());
        }
        this.bImmediateRead = true;
        return true;
    }

    protected boolean shouldReadResponseImmediately() {
        return this.isImmediateReadEnabled() || this.getRequestImpl().isExpect100Continue() || this.getRequestImpl().containsHeader(HttpConstants.HDR_UPGRADE);
    }

    public boolean cancelOutstandingRead() {
        this.disallowRewrites();
        return super.cancelOutstandingRead();
    }

    public boolean cancelOutstandingWrite() {
        this.disallowRewrites();
        return super.cancelOutstandingWrite();
    }

    public HttpAddress getTargetAddress() {
        return this.myLink.getTargetAddress();
    }
}

