/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class HttpOSCWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCWriteCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpOSCWriteCallback myInstance = null;

    private HttpOSCWriteCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpOSCWriteCallback();
        }
    }

    public static final HttpOSCWriteCallback getRef() {
        if (null == myInstance) {
            HttpOSCWriteCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + virtualConnection);
        }
        if ((httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC)).isEarlyRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Notifying app channel of write complete");
            }
            httpOutboundServiceContextImpl.getAppWriteCallback().complete(virtualConnection);
            return;
        }
        if (httpOutboundServiceContextImpl.isHeadersSentState() && 0 == httpOutboundServiceContextImpl.getNumBytesWritten() && httpOutboundServiceContextImpl.shouldReadResponseImmediately()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Sent headers, reading for response");
            }
            httpOutboundServiceContextImpl.startResponseRead();
            return;
        }
        if (!httpOutboundServiceContextImpl.isMessageSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling write complete callback of app channel.");
            }
            httpOutboundServiceContextImpl.getAppWriteCallback().complete(virtualConnection);
        } else if (httpOutboundServiceContextImpl.shouldReadResponseImmediately()) {
            httpOutboundServiceContextImpl.readAsyncResponse();
        } else {
            httpOutboundServiceContextImpl.startResponseRead();
        }
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + virtualConnection + " ioe=" + iOException);
        }
        if ((httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC)).canceledWrite()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring error callback on canceled write");
            }
            httpOutboundServiceContextImpl.resetCanceledWrite();
            return;
        }
        httpOutboundServiceContextImpl.setPersistent(false);
        httpOutboundServiceContextImpl.reConnect(virtualConnection, iOException);
    }
}

