/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.EnumWrap;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.matcher.impl.MethodMatcher;
import com.ibm.ws.http.channel.matcher.impl.SchemeMatcher;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedSchemeException;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.SchemeValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;

public class HttpRequestMessageImpl
extends HttpBaseMessageImpl
implements HttpRequestMessage {
    private static final TraceComponent tc = Tr.register(HttpRequestMessageImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final long serialVersionUID = 5759292362534888246L;
    private static final byte LEFT_BRACKET = 91;
    private static final byte RIGHT_BRACKET = 93;
    private static final byte[] SLASH = new byte[]{47};
    private static final byte[] STAR = new byte[]{42};
    private static final int NOT_PRESENT = -1;
    private static final int NOT_TESTED = -2;
    private MethodValues myMethod = HttpConstants.METHOD_UNDEF;
    private SchemeValues myScheme = null;
    private byte[] myURIBytes = SLASH;
    private transient String myURIString = null;
    private byte[] myQueryBytes = null;
    private transient String sUrlHost = null;
    private transient String sHdrHost = null;
    private transient int iUrlPort = -1;
    private transient int iHdrPort = -2;
    private transient Map queryParams = null;

    public HttpRequestMessageImpl() {
        this.setHeaderValidation(false);
        this.setOwner(null);
        this.setBinaryParseState(14);
    }

    public HttpRequestMessageImpl(HttpInboundServiceContext httpInboundServiceContext) {
        this.setHeaderValidation(false);
        this.setOwner(httpInboundServiceContext);
        this.setBinaryParseState(14);
    }

    public HttpRequestMessageImpl(HttpOutboundServiceContext httpOutboundServiceContext) {
        this.setHeaderValidation(false);
        this.setOwner(httpOutboundServiceContext);
        this.setBinaryParseState(14);
    }

    public void init(HttpInboundServiceContext httpInboundServiceContext) {
        this.setHeaderValidation(false);
        this.setOwner(httpInboundServiceContext);
        this.setBinaryParseState(14);
    }

    public void init(HttpOutboundServiceContext httpOutboundServiceContext) {
        this.setHeaderValidation(false);
        this.setOwner(httpOutboundServiceContext);
        this.setBinaryParseState(14);
        this.setVersion(this.getServiceContext().getHttpConfig().getOutgoingVersion());
    }

    public void init(HttpInboundServiceContext httpInboundServiceContext, BNFHeaders bNFHeaders) {
        this.setHeaderValidation(false);
        this.setOwner(httpInboundServiceContext);
        this.setBinaryParseState(14);
        if (null != bNFHeaders) {
            bNFHeaders.duplicate(this);
        }
    }

    public void init(HttpOutboundServiceContext httpOutboundServiceContext, BNFHeaders bNFHeaders) {
        this.setHeaderValidation(false);
        this.setOwner(httpOutboundServiceContext);
        this.setBinaryParseState(14);
        if (null != bNFHeaders) {
            bNFHeaders.duplicate(this);
        }
        this.setVersion(this.getServiceContext().getHttpConfig().getOutgoingVersion());
    }

    public void setOwner(HttpServiceContext httpServiceContext) {
        if (null != this.getServiceContext()) {
            this.getServiceContext().setRequestOwner(false);
        }
        if (null != httpServiceContext) {
            super.init(httpServiceContext);
            this.getServiceContext().setRequestOwner(true);
            this.setIncoming(this.getServiceContext().isInboundConnection());
        }
    }

    public boolean isBodyExpected() {
        if (super.isBodyExpected()) {
            return this.myMethod.isBodyAllowed();
        }
        return false;
    }

    public boolean isBodyAllowed() {
        return this.isBodyExpected();
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing this request: " + this);
        }
        super.clear();
        this.myMethod = HttpConstants.METHOD_UNDEF;
        this.myScheme = null;
        this.myURIBytes = SLASH;
        this.myURIString = null;
        this.myQueryBytes = null;
        this.queryParams = null;
        this.sUrlHost = null;
        this.sHdrHost = null;
        this.iUrlPort = -1;
        this.iHdrPort = -2;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying this request: " + this);
        }
        HttpObjectFactory httpObjectFactory = this.getObjectFactory();
        super.destroy();
        if (null != httpObjectFactory) {
            httpObjectFactory.releaseRequest(this);
        }
    }

    protected void setParsedFirstToken(byte[] byArray) throws Exception {
        MethodValues methodValues = MethodMatcher.getRef().matchMethod(byArray);
        if (null == methodValues) {
            methodValues = MethodValues.makeUndefinedValue(byArray);
        }
        this.setMethod(methodValues);
    }

    protected void setParsedSecondToken(byte[] byArray) throws Exception {
        this.setRequestURL(byArray);
    }

    protected void setParsedThirdToken(byte[] byArray) throws Exception {
        this.setVersion(byArray);
    }

    protected void parsingComplete() throws MalformedMessageException {
        int n = this.getNumberFirstLineTokens();
        if (2 == n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received a request without a version ID");
            }
            throw new UnsupportedProtocolVersionException("Missing version");
        }
        if (3 != n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "numFirstLineTokensRead is " + n);
            }
            throw new MalformedMessageException("Received " + n + " first line tokens");
        }
    }

    protected byte[] getMarshalledFirstToken() {
        return this.myMethod.getByteArray();
    }

    protected byte[] getMarshalledSecondToken() {
        return this.getResource();
    }

    protected byte[] getMarshalledThirdToken() {
        return this.getVersionValue().getByteArray();
    }

    public boolean parseBinaryFirstLine(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        byte by;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseBinaryFirstLine for " + this);
            Tr.debug(tc, "Buffer: " + wsByteBuffer);
        }
        if (this.getBinaryParseState() == 14) {
            if (!wsByteBuffer.hasRemaining()) {
                return false;
            }
            by = wsByteBuffer.get();
            if (by != 49) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported binary version in message: " + by);
                }
                throw new MalformedMessageException("Invalid binary message");
            }
            this.setBinaryParseState(7);
            this.resetCacheToken(4);
        }
        by = 0;
        block8: while (by == 0) {
            if (!this.fillCacheToken(wsByteBuffer)) {
                return false;
            }
            switch (this.getBinaryParseState()) {
                case 7: {
                    int n = GenericUtils.asInt(this.getParsedToken());
                    if (0 == (n & 0x20000)) {
                        this.setMethod(MethodValues.getByOrdinal(n));
                        this.setBinaryParseState(9);
                        this.resetCacheToken(4);
                        continue block8;
                    }
                    this.setBinaryParseState(8);
                    this.resetCacheToken(n & 0x1FFFF);
                    continue block8;
                }
                case 8: {
                    this.setMethod(MethodValues.makeUndefinedValue(this.getParsedToken()));
                    this.setBinaryParseState(9);
                    this.createCacheToken(4);
                    continue block8;
                }
                case 9: {
                    this.setBinaryParseState(10);
                    this.resetCacheToken(GenericUtils.asInt(this.getParsedToken()));
                    continue block8;
                }
                case 10: {
                    this.setRequestURL(this.getParsedToken());
                    this.setBinaryParseState(5);
                    this.createCacheToken(4);
                    continue block8;
                }
                case 5: {
                    int n = GenericUtils.asInt(this.getParsedToken());
                    if (0 == (n & 0x20000)) {
                        this.setVersion(VersionValues.getByOrdinal(n));
                        this.setBinaryParseState(1);
                        this.resetCacheToken(4);
                        by = 1;
                        continue block8;
                    }
                    this.setBinaryParseState(6);
                    this.resetCacheToken(n & 0x1FFFF);
                    continue block8;
                }
                case 6: {
                    this.setVersion(VersionValues.makeUndefinedValue(this.getParsedToken()));
                    this.setBinaryParseState(1);
                    this.createCacheToken(4);
                    by = 1;
                    continue block8;
                }
            }
            throw new MalformedMessageException("Invalid state in first line: " + this.getBinaryParseState());
        }
        this.setFirstLineComplete(true);
        return true;
    }

    public WsByteBuffer[] marshallLine() {
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        wsByteBufferArray = this.putBytes(this.myMethod.getMethodSpace(), wsByteBufferArray);
        wsByteBufferArray = this.putBytes(this.getMarshalledSecondToken(), wsByteBufferArray);
        wsByteBufferArray = this.putBytes(this.getVersionValue().getSpaceVersion(), wsByteBufferArray);
        wsByteBufferArray = this.putBytes(BNFHeaders.EOL, wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string = GenericUtils.nullOutPasswords(this.getMarshalledSecondToken(), (byte)38);
            Tr.debug(tc, "Marshalling first line: " + this.getMethod() + " " + string + " " + this.getVersion());
        }
        return wsByteBufferArray;
    }

    public WsByteBuffer[] marshallBinaryFirstLine() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallBinaryFirstLine");
        }
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        byte[] byArray = null;
        wsByteBufferArray = this.putByte((byte)49, wsByteBufferArray);
        if (this.getMethodValue().isUndefined()) {
            byArray = this.myMethod.getByteArray();
            wsByteBufferArray = this.putInt(byArray.length | 0x20000, wsByteBufferArray);
            wsByteBufferArray = this.putBytes(byArray, wsByteBufferArray);
        } else {
            wsByteBufferArray = this.putInt(this.myMethod.getOrdinal(), wsByteBufferArray);
        }
        byte[] byArray2 = this.getResource();
        wsByteBufferArray = this.putInt(byArray2.length, wsByteBufferArray);
        wsByteBufferArray = this.putBytes(byArray2, wsByteBufferArray);
        if (this.getVersionValue().isUndefined()) {
            byArray = this.getVersionValue().getByteArray();
            wsByteBufferArray = this.putInt(byArray.length | 0x20000, wsByteBufferArray);
            wsByteBufferArray = this.putBytes(byArray, wsByteBufferArray);
        } else {
            wsByteBufferArray = this.putInt(this.getVersionValue().getOrdinal(), wsByteBufferArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string = GenericUtils.nullOutPasswords(this.getMarshalledSecondToken(), (byte)38);
            Tr.debug(tc, "Marshalling first line: " + this.getMethod() + " " + string + " " + this.getVersion());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallBinaryFirstLine");
        }
        return wsByteBufferArray;
    }

    public void headerComplianceCheck() throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "headerComplianceCheck");
        }
        super.headerComplianceCheck();
        if (this.getServiceContext().isOutgoingBodyValid() && !this.containsHeader(HttpConstants.HDR_DATE)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a missing Date header");
            }
            this.setCurrentDate();
        }
        if (this.getVersionValue().equals(HttpConstants.HTTP_VERSION_11) && !this.containsHeader(HttpConstants.HDR_HOST)) {
            HttpOutboundServiceContext httpOutboundServiceContext = (HttpOutboundServiceContext)((Object)this.getServiceContext());
            String string = httpOutboundServiceContext.getTargetAddress().getHostname();
            if (80 != httpOutboundServiceContext.getRemotePort()) {
                string = string + ":" + httpOutboundServiceContext.getRemotePort();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a missing Host header: " + string);
            }
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_HOST, string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "headerComplianceCheck");
        }
    }

    public String getMethod() {
        if (null != this.myMethod) {
            return this.myMethod.getName();
        }
        return null;
    }

    public final MethodValues getMethodValue() {
        return this.myMethod;
    }

    public void setMethod(String string) throws UnsupportedMethodException {
        MethodValues methodValues = MethodMatcher.getRef().matchMethod(string);
        if (null == methodValues) {
            throw new UnsupportedMethodException("Illegal method " + string);
        }
        this.setMethod(methodValues);
    }

    public void setMethod(byte[] byArray) throws UnsupportedMethodException {
        MethodValues methodValues = MethodMatcher.getRef().matchMethod(byArray);
        if (null == methodValues) {
            throw new UnsupportedMethodException("Illegal method " + GenericUtils.getEnglishString(byArray));
        }
        this.setMethod(methodValues);
    }

    public void setMethod(MethodValues methodValues) {
        this.myMethod = methodValues;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setMethod(v): " + (null != methodValues ? methodValues.getName() : null));
        }
    }

    public final String getRequestURI() {
        if (null == this.myURIString) {
            this.myURIString = GenericUtils.getEnglishString(this.myURIBytes);
        }
        return this.myURIString;
    }

    public final byte[] getRequestURIAsByteArray() {
        return this.myURIBytes;
    }

    private String getTargetHost() {
        String string = this.getVirtualHost();
        if (null == string) {
            string = this.isIncoming() ? this.getServiceContext().getLocalAddr().getCanonicalHostName() : this.getServiceContext().getRemoteAddr().getCanonicalHostName();
        }
        return string;
    }

    private int getTargetPort() {
        int n = this.getVirtualPort();
        if (-1 == n) {
            n = this.isIncoming() ? this.getServiceContext().getLocalPort() : this.getServiceContext().getRemotePort();
        }
        return n;
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = new StringBuffer(this.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(this.getTargetHost());
        stringBuffer.append(":");
        stringBuffer.append(this.getTargetPort());
        stringBuffer.append(this.getRequestURI());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRequestURL() returning " + stringBuffer.toString());
        }
        return stringBuffer;
    }

    public final String getRequestURLAsString() {
        return this.getRequestURL().toString();
    }

    public final byte[] getRequestURLAsByteArray() {
        return GenericUtils.getBytes(this.getRequestURL());
    }

    public final String getURLHost() {
        return this.sUrlHost;
    }

    public final int getURLPort() {
        return this.iUrlPort;
    }

    public String getVirtualHost() {
        if (null != this.sUrlHost) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualHost: url host-> " + this.sUrlHost);
            }
            return this.sUrlHost;
        }
        if (null != this.sHdrHost) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualHost: hdr host-> " + this.sHdrHost);
            }
            return this.sHdrHost;
        }
        String string = this.getHeaderAsString(HttpConstants.HDR_HOST);
        if (null == string || 0 >= string.length()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualHost: No host header: [" + string + "]");
            }
            return null;
        }
        int n = -1;
        if ('[' == string.charAt(0)) {
            n = string.indexOf(93);
            if (-1 == n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getVirtualHost: Invalid IPv6 IP, missing right bracket");
                }
                return null;
            }
            ++n;
        } else {
            n = string.indexOf(58);
        }
        if (-1 != n) {
            string = string.substring(0, n);
        }
        this.sHdrHost = string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getVirtualHost: " + string);
        }
        return string;
    }

    public int getVirtualPort() {
        int n;
        if (-1 != this.iUrlPort) {
            return this.iUrlPort;
        }
        if (-1 <= this.iHdrPort) {
            return this.iHdrPort;
        }
        byte[] byArray = this.getHeaderAsByteArray(HttpConstants.HDR_HOST);
        if (null == byArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualPort: No host header");
            }
            return -1;
        }
        this.iHdrPort = -1;
        int n2 = -1;
        if (91 == byArray[0]) {
            n2 = GenericUtils.byteIndexOf(byArray, (byte)93, 0);
            if (-1 == n2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getVirtualPort: Invalid IPV6 ip in host header");
                }
                return -1;
            }
            ++n2;
        } else {
            n2 = GenericUtils.byteIndexOf(byArray, (byte)58, 0);
        }
        if (-1 == n2 || byArray.length <= n2 || 58 != byArray[n2]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualPort: No port in host header");
            }
            return -1;
        }
        if (0 >= (n = byArray.length - ++n2)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualPort: No port after colon");
            }
            return -1;
        }
        try {
            this.iHdrPort = GenericUtils.asIntValue(byArray, n2, n);
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualPort: Invalid port value: " + HttpChannelUtils.getEnglishString(byArray, n2, n));
            }
            return -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getVirtualPort: returning " + this.iHdrPort);
        }
        return this.iHdrPort;
    }

    private byte[] getResource() {
        byte[] byArray = this.myURIBytes;
        if (this.getOutboundSCImpl().getLink().getTargetAddress().isForwardProxy()) {
            byArray = this.getRequestURLAsByteArray();
        }
        if (null != this.myQueryBytes) {
            byte[] byArray2 = byArray;
            byArray = new byte[byArray2.length + 1 + this.myQueryBytes.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[byArray2.length] = 63;
            System.arraycopy(this.myQueryBytes, 0, byArray, byArray2.length + 1, this.myQueryBytes.length);
        }
        return byArray;
    }

    private void parseURLHost(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (0 >= n3) {
            throw new IllegalArgumentException("Missing host/port");
        }
        int n4 = n;
        int n5 = n2;
        int n6 = -1;
        int n7 = -1;
        if (91 != byArray[n4]) {
            int n8 = GenericUtils.byteIndexOf(byArray, (byte)58, n4, n3);
            if (-1 != n8) {
                n5 = n8;
                n6 = n8 + 1;
                n7 = n2;
            }
        } else {
            int n9;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IPV6 host in the URL");
            }
            if (-1 != (n9 = GenericUtils.byteIndexOf(byArray, (byte)93, n4, n3))) {
                n5 = ++n9;
                if (n9 < n2 && 58 == byArray[n9]) {
                    n6 = n9 + 1;
                    n7 = n2;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No end to the IPV6 IP");
                }
                throw new IllegalArgumentException("Invalid IPV6 IP");
            }
        }
        n3 = n5 - n4;
        if (0 >= n3) {
            throw new IllegalArgumentException("Hostname not present");
        }
        this.sUrlHost = GenericUtils.getEnglishString(byArray, n4, n5);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Found URL host: " + this.sUrlHost);
        }
        if (-1 != n6 && n7 > n6) {
            n3 = n7 - n6;
            this.iUrlPort = GenericUtils.asIntValue(byArray, n6, n3);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Defaulting URL port to match scheme: " + this.getScheme());
            }
            this.iUrlPort = HttpConstants.SCHEME_HTTPS.equals(this.getSchemeValue()) ? 443 : 80;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Found URL port of " + this.iUrlPort);
        }
    }

    private void parseURI(byte[] byArray, int n) {
        if (n >= byArray.length) {
            this.myURIBytes = SLASH;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Defaulting to slash since no URI data found");
            }
            return;
        }
        int n2 = byArray.length;
        for (int i = n; i < byArray.length; ++i) {
            if (63 != byArray[i]) continue;
            n2 = i;
            break;
        }
        if (n == n2) {
            throw new IllegalArgumentException("Missing URI: " + GenericUtils.getEnglishString(byArray));
        }
        if (0 == n && n2 == byArray.length) {
            this.myURIBytes = byArray;
        } else {
            this.myURIBytes = new byte[n2 - n];
            System.arraycopy(byArray, n, this.myURIBytes, 0, this.myURIBytes.length);
            if (++n2 < byArray.length) {
                byte[] byArray2 = new byte[byArray.length - n2];
                System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
                this.setQueryString(byArray2);
            }
        }
    }

    private void parseAuthority(byte[] byArray, int n) {
        if (n >= byArray.length) {
            throw new IllegalArgumentException("Invalid authority: " + GenericUtils.getEnglishString(byArray));
        }
        int n2 = n;
        int n3 = byArray.length;
        for (int i = n; i < byArray.length; ++i) {
            if (64 == byArray[i]) {
                n2 = i + 1;
                continue;
            }
            if (47 != byArray[i]) continue;
            n3 = i;
            break;
        }
        this.parseURLHost(byArray, n2, n3);
        this.parseURI(byArray, n3);
    }

    private void parseScheme(byte[] byArray) {
        for (int i = 1; i < byArray.length; ++i) {
            if (58 != byArray[i]) continue;
            Object object = SchemeMatcher.getRef().match(byArray, 0, i);
            if (null == object) {
                throw new IllegalArgumentException("Invalid scheme inside URL: " + GenericUtils.getEnglishString(byArray));
            }
            this.setScheme((SchemeValues)object);
            if (i + 2 >= byArray.length || 47 != byArray[i + 1] || 47 != byArray[i + 2]) {
                throw new IllegalArgumentException("Invalid net_path: " + GenericUtils.getEnglishString(byArray));
            }
            this.parseAuthority(byArray, i + 3);
            return;
        }
        throw new IllegalArgumentException("Invalid scheme in URL: " + GenericUtils.getEnglishString(byArray));
    }

    private boolean isAlpha(byte by) {
        if (97 <= by && 122 >= by) {
            return true;
        }
        return 65 <= by && 90 >= by;
    }

    public void setRequestURL(String string) {
        this.setRequestURL(GenericUtils.getEnglishBytes(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRequestURL(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRequestURL input [" + GenericUtils.nullOutPasswords(byArray, (byte)38) + "]");
        }
        if (null == byArray || 0 == byArray.length) {
            throw new IllegalArgumentException("setRequestURL: null URL");
        }
        super.setFirstLineChanged();
        this.initScheme();
        this.myURIString = null;
        this.sUrlHost = null;
        this.iUrlPort = -1;
        this.myQueryBytes = null;
        this.queryParams = null;
        if (42 == byArray[0]) {
            if (1 == byArray.length) {
                this.myURIBytes = STAR;
            } else {
                if (63 != byArray[1]) throw new IllegalArgumentException("Invalid leading * : " + GenericUtils.getEnglishString(byArray));
                this.parseURI(byArray, 0);
            }
        } else if (47 == byArray[0]) {
            if (1 == byArray.length) {
                this.myURIBytes = SLASH;
            } else if (47 == byArray[1] && this.getServiceContext().getHttpConfig().isStrictURLFormat()) {
                this.parseAuthority(byArray, 2);
            } else {
                this.parseURI(byArray, 0);
            }
        } else {
            if (!this.isAlpha(byArray[0])) throw new IllegalArgumentException("setRequestURL: invalid URL: " + GenericUtils.getEnglishString(byArray));
            this.parseScheme(byArray);
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
        Tr.debug(tc, "setRequestURL: set URI to " + this.getRequestURI());
    }

    public void setRequestURI(String string) {
        this.setRequestURI(GenericUtils.getEnglishBytes(string));
    }

    public void setRequestURI(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            throw new IllegalArgumentException("setRequestURI: null input");
        }
        super.setFirstLineChanged();
        if (42 == byArray[0]) {
            if (1 != byArray.length && 63 != byArray[1]) {
                String string = GenericUtils.getEnglishString(byArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setRequestURI: invalid uri [" + string + "]");
                }
                throw new IllegalArgumentException("Invalid uri: " + string);
            }
        } else if (47 != byArray[0]) {
            String string = GenericUtils.getEnglishString(byArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setRequestURI: invalid uri [" + string + "]");
            }
            throw new IllegalArgumentException("Invalid uri: " + string);
        }
        this.initScheme();
        this.myURIString = null;
        this.sUrlHost = null;
        this.iUrlPort = -1;
        this.myQueryBytes = null;
        this.queryParams = null;
        this.parseURI(byArray, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRequestURI: set URI to " + this.getRequestURI());
        }
    }

    public final SchemeValues getSchemeValue() {
        return this.myScheme;
    }

    public void initScheme() {
        if (null == this.getServiceContext().getTSC()) {
            return;
        }
        this.myScheme = this.getServiceContext().isSecure() ? HttpConstants.SCHEME_HTTPS : HttpConstants.SCHEME_HTTP;
    }

    public String getScheme() {
        if (null == this.myScheme) {
            this.initScheme();
        }
        return this.myScheme.getName();
    }

    public void setScheme(SchemeValues schemeValues) {
        this.myScheme = schemeValues;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setScheme(v): " + (null != schemeValues ? schemeValues.getName() : null));
        }
    }

    public void setScheme(String string) throws UnsupportedSchemeException {
        SchemeValues schemeValues = SchemeMatcher.getRef().matchScheme(string);
        if (null == schemeValues) {
            throw new UnsupportedSchemeException("Illegal scheme " + string);
        }
        this.setScheme(schemeValues);
    }

    public void setScheme(byte[] byArray) throws UnsupportedSchemeException {
        SchemeValues schemeValues = SchemeMatcher.getRef().matchScheme(byArray);
        if (null == schemeValues) {
            throw new UnsupportedSchemeException("Illegal scheme " + GenericUtils.getEnglishString(byArray));
        }
        this.setScheme(schemeValues);
    }

    public Cookie getCookie(String string) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        Cookie cookie = this.getCookie(string, HttpConstants.HDR_COOKIE);
        if (null == cookie) {
            cookie = this.getCookie(string, HttpConstants.HDR_COOKIE2);
        }
        return null == cookie ? null : (Cookie)cookie.clone();
    }

    public byte[] getCookieValue(String string) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        byte[] byArray = this.getCookieValue(string, HttpConstants.HDR_COOKIE);
        if (null == byArray) {
            byArray = this.getCookieValue(string, HttpConstants.HDR_COOKIE2);
        }
        return byArray;
    }

    public List getAllCookieValues(String string) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        return super.getAllCookieValues(string, HttpConstants.HDR_COOKIE, HttpConstants.HDR_COOKIE2);
    }

    public List getAllCookies(String string) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        return super.getAllCookies(string, HttpConstants.HDR_COOKIE, HttpConstants.HDR_COOKIE2);
    }

    public List getAllCookies() {
        return this.getAllCookies(HttpConstants.HDR_COOKIE, HttpConstants.HDR_COOKIE2);
    }

    public boolean setCookie(Cookie cookie, HeaderKeys headerKeys) {
        if (null == cookie) {
            throw new NullPointerException("Cookie name");
        }
        if (1 < cookie.getVersion()) {
            throw new IllegalArgumentException("Invalid cookie version: " + cookie.getVersion());
        }
        if (headerKeys.equals(HttpConstants.HDR_COOKIE) || headerKeys.equals(HttpConstants.HDR_COOKIE2)) {
            return this.addCookie(cookie, headerKeys);
        }
        return false;
    }

    public boolean setCookie(String string, String string2, HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new NullPointerException("HeaderKeys");
        }
        return this.setCookie(new Cookie(string, string2), headerKeys);
    }

    public boolean removeCookie(String string, HeaderKeys headerKeys) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        if (headerKeys.equals(HttpConstants.HDR_COOKIE) || headerKeys.equals(HttpConstants.HDR_COOKIE2)) {
            return this.deleteCookie(string, headerKeys);
        }
        return false;
    }

    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Request Message: " + this);
            Tr.debug(tc, "Method: " + this.getMethod());
            Tr.debug(tc, "URL: " + this.getRequestURLAsString());
            Tr.debug(tc, "Query: " + this.getQueryString());
            Tr.debug(tc, "UrlHost: " + this.getURLHost());
            Tr.debug(tc, "UrlPort: " + this.getURLPort());
            Tr.debug(tc, "Host: " + this.getHeaderAsString(HttpConstants.HDR_HOST));
            super.debug();
        }
    }

    public HttpRequestMessage duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the request message: " + this);
        }
        HttpRequestMessageImpl httpRequestMessageImpl = null;
        HttpObjectFactory httpObjectFactory = this.getObjectFactory();
        if (null == httpObjectFactory) {
            httpRequestMessageImpl = new HttpRequestMessageImpl();
            httpRequestMessageImpl.setIncoming(this.isIncoming());
        } else {
            httpRequestMessageImpl = this.isIncoming() ? httpObjectFactory.getRequest(this.getInboundSC()) : httpObjectFactory.getRequest(this.getOutboundSC());
        }
        httpRequestMessageImpl.setMethod(this.myMethod);
        httpRequestMessageImpl.setRequestURI(this.myURIBytes);
        httpRequestMessageImpl.setScheme(this.myScheme);
        httpRequestMessageImpl.setQueryString(this.myQueryBytes);
        httpRequestMessageImpl.iUrlPort = this.iUrlPort;
        httpRequestMessageImpl.sUrlHost = this.sUrlHost;
        httpRequestMessageImpl.iHdrPort = this.iHdrPort;
        httpRequestMessageImpl.sHdrHost = this.sHdrHost;
        super.duplicate(httpRequestMessageImpl);
        return httpRequestMessageImpl;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "De-serializing into: " + this);
        }
        super.readExternal(objectInput);
        String string = (String)objectInput.readObject();
        try {
            this.setMethod(string);
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown method parsed: " + string);
            }
            this.setMethod(MethodValues.makeUndefinedValue(GenericUtils.getEnglishBytes(string)));
        }
        string = (String)objectInput.readObject();
        try {
            this.setScheme(string);
        }
        catch (UnsupportedSchemeException unsupportedSchemeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown scheme parsed: " + string);
            }
            this.setScheme(SchemeValues.makeUndefinedValue(GenericUtils.getEnglishBytes(string)));
        }
        this.myURIBytes = GenericUtils.readValue(objectInput, objectInput.readInt());
        int n = objectInput.readInt();
        if (-1 != n) {
            this.setQueryString(GenericUtils.readValue(objectInput, n));
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Serializing: " + this);
        }
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.getMethod());
        objectOutput.writeObject(this.getScheme());
        objectOutput.writeInt(this.getRequestURIAsByteArray().length);
        objectOutput.write(this.getRequestURIAsByteArray());
        if (null != this.getQueryStringAsByteArray()) {
            objectOutput.writeInt(this.getQueryStringAsByteArray().length);
            objectOutput.write(this.getQueryStringAsByteArray());
        } else {
            objectOutput.writeInt(-1);
        }
    }

    public void setQueryString(String string) {
        this.myQueryBytes = GenericUtils.getEnglishBytes(string);
        this.queryParams = null;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && null != this.myQueryBytes) {
            Tr.debug(tc, "setQueryString(String): set query to [" + GenericUtils.nullOutPasswords(this.myQueryBytes, (byte)38) + "]");
        }
    }

    public void setQueryString(byte[] byArray) {
        this.myQueryBytes = byArray;
        this.queryParams = null;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && null != this.myQueryBytes) {
            Tr.debug(tc, "setQueryString(byte[]): set query to [" + GenericUtils.nullOutPasswords(this.myQueryBytes, (byte)38) + "]");
        }
    }

    public String getQueryString() {
        return GenericUtils.getEnglishString(this.myQueryBytes);
    }

    public final byte[] getQueryStringAsByteArray() {
        return this.myQueryBytes;
    }

    public String getParameter(String string) {
        String[] stringArray = (String[])this.getParameterMap().get(string);
        return null == stringArray || 0 == stringArray.length ? null : stringArray[0];
    }

    private final Map getQueryParameters() {
        return this.queryParams;
    }

    public Map getParameterMap() {
        if (null == this.queryParams) {
            this.parseParameters();
        }
        return this.queryParams;
    }

    public Enumeration getParameterNames() {
        return new EnumWrap(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String string) {
        return (String[])this.getParameterMap().get(string);
    }

    private synchronized void parseParameters() {
        if (null != this.queryParams) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseParameters for " + this);
        }
        String string = this.getCharset().name();
        String string2 = this.getQueryString();
        if (null != string2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing URL query data");
            }
            Map map = HttpChannelUtils.parseQueryString(string2, string);
            if (null == this.queryParams) {
                this.queryParams = map;
            } else {
                this.mergeQueryParams(map);
            }
        }
        if (null == this.queryParams) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No query data found in URL");
            }
            this.queryParams = new Hashtable();
        }
    }

    private void mergeQueryParams(Map map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "mergeQueryParams: " + map);
        }
        if (null == map) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            String[] stringArray = (String[])this.getQueryParameters().get(k);
            String[] stringArray2 = (String[])map.get(k);
            if (null != stringArray) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "map already contains key " + k);
                }
                String[] stringArray3 = new String[stringArray.length + stringArray2.length];
                System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
                this.getQueryParameters().put(k, stringArray3);
            } else {
                this.getQueryParameters().put(k, stringArray2);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "put key " + k + " into map.");
        }
    }
}

