/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ws.timeutils.QuickApproxTime;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class HttpLocalFormat {
    protected static final long DEFAULT_TOLERANCE = 1000L;
    private SimpleDateFormat RFC1123_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private SimpleDateFormat RFC1036_FORMAT = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
    private SimpleDateFormat ASCII_FORMAT = new SimpleDateFormat("EEE MMM  d HH:mm:ss yyyy", Locale.US);
    private SimpleDateFormat NCSA_FORMAT = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);
    private CachedTime c1123Time = null;
    private CachedTime c1036Time = null;
    private CachedTime cAsciiTime = null;
    private CachedTime cNCSATime = null;

    public HttpLocalFormat() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.get1123Format().setTimeZone(timeZone);
        this.get1036Format().setTimeZone(timeZone);
        this.getAsciiFormat().setTimeZone(timeZone);
        this.c1123Time = new CachedTime(this.get1123Format());
        this.c1036Time = new CachedTime(this.get1036Format());
        this.cAsciiTime = new CachedTime(this.getAsciiFormat());
        this.cNCSATime = new CachedTime(this.getNCSAFormat());
    }

    public byte[] get1123TimeAsBytes(long l) {
        return this.c1123Time.getTimeAsBytes(l);
    }

    public String get1123TimeAsString(long l) {
        return this.c1123Time.getTimeAsString(l);
    }

    public byte[] get1036TimeAsBytes(long l) {
        return this.c1036Time.getTimeAsBytes(l);
    }

    public String get1036TimeAsString(long l) {
        return this.c1036Time.getTimeAsString(l);
    }

    public byte[] getAsciiTimeAsBytes(long l) {
        return this.cAsciiTime.getTimeAsBytes(l);
    }

    public String getAsciiTimeAsString(long l) {
        return this.cAsciiTime.getTimeAsString(l);
    }

    public byte[] getNCSATimeAsBytes(long l) {
        return this.cNCSATime.getTimeAsBytes(l);
    }

    public String getNCSATimeAsString(long l) {
        return this.cNCSATime.getTimeAsString(l);
    }

    public SimpleDateFormat get1123Format() {
        return this.RFC1123_FORMAT;
    }

    public SimpleDateFormat get1036Format() {
        return this.RFC1036_FORMAT;
    }

    public SimpleDateFormat getAsciiFormat() {
        return this.ASCII_FORMAT;
    }

    public SimpleDateFormat getNCSAFormat() {
        return this.NCSA_FORMAT;
    }

    private class CachedTime {
        private SimpleDateFormat myFormat = null;
        private long lastTimeCheck = 0L;
        private String sTime = null;
        private byte[] baTime = null;
        private Date myDate = new Date();
        private StringBuffer myBuffer = new StringBuffer(33);

        protected CachedTime(SimpleDateFormat simpleDateFormat) {
            this.myFormat = simpleDateFormat;
        }

        private void updateTime(long l) {
            long l2 = QuickApproxTime.getRef().getApproxTime();
            if (l2 == this.lastTimeCheck) {
                return;
            }
            if (0L != l) {
                long l3;
                long l4 = l3 = -1L == l ? 1000L : l;
                if (l2 - this.lastTimeCheck <= l3) {
                    return;
                }
            }
            this.myDate.setTime(l2);
            this.myBuffer.setLength(0);
            this.myBuffer = this.myFormat.format(this.myDate, this.myBuffer, new FieldPosition(0));
            char[] cArray = new char[this.myBuffer.length()];
            this.myBuffer.getChars(0, cArray.length, cArray, 0);
            if (null == this.baTime || this.baTime.length != cArray.length) {
                this.baTime = new byte[cArray.length];
            }
            for (int i = 0; i < cArray.length; ++i) {
                this.baTime[i] = (byte)cArray[i];
            }
            this.sTime = new String(cArray);
            this.lastTimeCheck = l2;
        }

        protected byte[] getTimeAsBytes(long l) {
            this.updateTime(l);
            return this.baTime;
        }

        protected String getTimeAsString(long l) {
            this.updateTime(l);
            return this.sTime;
        }
    }
}

