/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.logging.HTTPLoggingService;
import com.ibm.ws.http.logging.impl.BaseLogger;
import com.ibm.ws.http.logging.impl.DisabledHTTPLogger;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.FileNotFoundException;
import java.util.Map;

public class HttpChannelConfig {
    private static final TraceComponent tc = Tr.register(HttpChannelConfig.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int TIMEOUT_MODIFIER = 1000;
    private static final boolean DEF_KEEP_ALIVE_ENABLED = true;
    private static final int DEF_MAX_PERSIST_REQ = 100;
    private static final int DEF_BYTE_CACHE_SIZE = 512;
    private static final int DEF_OUTGOING_HDR_BUFF_SIZE = 1024;
    private static final int DEF_INCOMING_HDR_BUFF_SIZE = 8192;
    private static final int DEF_INCOMING_BODY_BUFF_SIZE = 32768;
    private static final int DEF_PERSIST_TIMEOUT = 30000;
    private static final int DEF_READ_TIMEOUT = 60000;
    private static final int DEF_WRITE_TIMEOUT = 60000;
    private static final int DEF_LIMIT_NUM_RESPONSES = 10;
    private static final long DEF_DATE_HEADER_RANGE = 1000L;
    private int maxPersistRequest = 100;
    private VersionValues outgoingHttpVersion = HttpConstants.HTTP_VERSION_11;
    private boolean bDirectBuffers = true;
    private boolean bKeepAliveEnabled = true;
    private int outgoingHdrBuffSize = 1024;
    private int incomingHdrBuffSize = 8192;
    private int incomingBodyBuffSize = 32768;
    private int persistTimeout = 30000;
    private int readTimeout = 60000;
    private int writeTimeout = 60000;
    private int byteCacheSize = 512;
    private boolean bExtractValue = true;
    private boolean bBinaryTransport = false;
    private HTTPLoggingService httpLogger = DisabledHTTPLogger.getRef();
    private int limitFieldSize = 32768;
    private int limitNumHeaders = 500;
    private int limitNumResponses = 10;
    private boolean bKeepThread = false;
    private boolean bAllowRetries = true;
    private boolean bServantRegion = false;
    private boolean bRunningOnZOS = false;
    private boolean bControlRegion = false;
    private boolean bHeaderValidation = true;
    private boolean bJITOnlyReads = false;
    private boolean bStrictURLFormat = false;
    private boolean bRemoveServerHeader = false;
    private byte[] baServerHeaderValue = null;
    private long lDateHeaderRange = 1000L;
    private boolean bCookiesConfigureNoCache = true;
    private int headerChangeLimit = -1;

    public HttpChannelConfig(ChannelData channelData) {
        this.parseConfig(channelData);
    }

    private void parseConfig(ChannelData channelData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "parseConfig: " + channelData.getName());
        }
        Map map = channelData.getPropertyBag();
        this.parseZOSInfo(map);
        this.parsePersistence(map);
        this.parseOutgoingVersion(map);
        this.parseBufferType(map);
        this.parseOutgoingBufferSize(map);
        this.parseIncomingHdrBufferSize(map);
        this.parseIncomingBodyBufferSize(map);
        this.parsePersistTimeout(map);
        this.parseReadTimeout(map);
        this.parseWriteTimeout(map);
        this.parseByteCacheSize(map);
        this.parseDelayedExtract(map);
        this.parseBinaryTransport(map);
        this.parseLimitFieldSize(map);
        this.parseLimitNumberHeaders(map);
        this.parseLimitNumberResponses(map);
        this.parseKeepThread(map);
        this.parseAllowRetries(map);
        this.parseLoggingInfo(map, channelData);
        this.parseHeaderValidation(map);
        this.parseStrictURLFormat(map);
        this.parseServerHeader(map);
        this.parseDateHeaderRange(map);
        this.parseCookieUpdate(map);
        this.parseHeaderChangeLimit(map);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseConfig");
        }
    }

    private void parsePersistence(Map map) {
        this.parseKeepAliveEnabled(map);
        if (this.isKeepAliveEnabled()) {
            this.parseMaxPersist(map);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: KeepAlives disabled, ignoring MaxKeepAliveRequests");
        }
    }

    private void parseKeepAliveEnabled(Map map) {
        boolean bl = true;
        String string = (String)map.get("defaultToOutgoingKeepAlive");
        if (null != string) {
            bl = this.convertBoolean(string);
        }
        if (null != (string = (String)map.get("KeepAliveEnabled"))) {
            bl &= this.convertBoolean(string);
        }
        this.setKeepAliveEnabled(bl);
    }

    private void parseMaxPersist(Map map) {
        block3: {
            String string = (String)map.get("MaxKeepAliveRequests");
            if (null != string) {
                try {
                    this.setMaximumPersistentRequests(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".parseMaxPersist", "128", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Maximum persistent requests of " + string + " is incorrect");
                }
            }
        }
    }

    private void parseOutgoingVersion(Map map) {
        String string = (String)map.get("outgoingVersion");
        if ("1.0".equals(string)) {
            this.setOutgoingVersion(HttpConstants.HTTP_VERSION_10);
        }
    }

    private void parseBufferType(Map map) {
        String string = (String)map.get("useDirectBuffers");
        if (null != string) {
            this.setDirectBufferType(this.convertBoolean(string));
        }
    }

    private void parseOutgoingBufferSize(Map map) {
        block3: {
            String string = (String)map.get("outgoingHdrBufferSize");
            if (null != string) {
                try {
                    this.setOutgoingHdrBufferSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".parseOutgoingBufferSize", "166", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Outgoing header buffer size of " + string + " is incorrect");
                }
            }
        }
    }

    private void parseIncomingHdrBufferSize(Map map) {
        block3: {
            String string = (String)map.get("incomingHdrBufferSize");
            if (null != string) {
                try {
                    this.setIncomingHdrBufferSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".parseIncomingHdrBufferSize", "184", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Incoming header buffer size of " + string + " is incorrect");
                }
            }
        }
    }

    private void parseIncomingBodyBufferSize(Map map) {
        block3: {
            String string = (String)map.get("incomingBodyBufferSize");
            if (null != string) {
                try {
                    this.setIncomingBodyBufferSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".parseIncomingBodyBufferSize", "202", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Incoming body buffer size of " + string + " is incorrect");
                }
            }
        }
    }

    private void parsePersistTimeout(Map map) {
        block3: {
            String string = (String)map.get("persistTimeout");
            if (null != string) {
                try {
                    this.setPersistTimeout(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".parsePersistTimeout", "220", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Persist timeout of " + string + " is incorrect");
                }
            }
        }
    }

    private void parseReadTimeout(Map map) {
        block3: {
            String string = (String)map.get("readTimeout");
            if (null != string) {
                try {
                    this.setReadTimeout(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".parseReadTimeout", "237", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Read timeout of " + string + " is incorrect");
                }
            }
        }
    }

    private void parseWriteTimeout(Map map) {
        block3: {
            String string = (String)map.get("writeTimeout");
            if (null != string) {
                try {
                    this.setWriteTimeout(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".parseWriteTimeout", "254", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Writetimeout of " + string + " is incorrect");
                }
            }
        }
    }

    private void parseByteCacheSize(Map map) {
        block3: {
            String string = (String)map.get("byteCacheSize");
            if (null != string) {
                try {
                    this.setByteCacheSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".parseByteCacheSize", "271", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Bytecache setting of " + string + " is invalid.");
                }
            }
        }
    }

    private void parseDelayedExtract(Map map) {
        String string = (String)map.get("extractValue");
        if (null != string) {
            this.setExtractValue(this.convertBoolean(string));
        }
    }

    private void parseBinaryTransport(Map map) {
        String string = (String)map.get("enableBinaryTransport");
        if (null != string) {
            this.setBinaryTransport(this.convertBoolean(string));
        }
    }

    private void parseLimitFieldSize(Map map) {
        block3: {
            String string = (String)map.get("limitFieldSize");
            if (null != string) {
                try {
                    this.setLimitOfFieldSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Max field size setting of " + string + " is invalid.");
                }
            }
        }
    }

    private void parseLimitNumberHeaders(Map map) {
        block3: {
            String string = (String)map.get("limitNumHeaders");
            if (null != string) {
                try {
                    this.setLimitOnNumberOfHeaders(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Max number of headers setting of " + string + " is invalid.");
                }
            }
        }
    }

    private void parseLimitNumberResponses(Map map) {
        block3: {
            String string = (String)map.get("LimitNumberResponses");
            if (null != string) {
                try {
                    this.setLimitOnNumberOfResponses(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Max number of responses setting of " + string + " is invalid.");
                }
            }
        }
    }

    private void parseKeepThread(Map map) {
        String string = (String)map.get("keepThread");
        if (null != string) {
            this.setKeepThread(this.convertBoolean(string));
        }
    }

    private void parseLoggingInfo(Map map, ChannelData channelData) {
        if (this.isServantRegion()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: logging disabled on servant region");
            }
            return;
        }
        String string = (String)map.get("loggingDisable");
        if (null != string) {
            if (this.convertBoolean(string)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Config: logging is disabled");
                }
                this.setHttpLogger(DisabledHTTPLogger.getRef());
            } else {
                this.parseLoggingParams(map, channelData);
            }
        }
    }

    private void parseLoggingParams(Map map, ChannelData channelData) {
        String string = (String)map.get("accessLogFileName");
        String string2 = (String)map.get("errorLogFileName");
        if (null == string && null == string2) {
            Object object = channelData.getChannelFramework().lookupService(HTTPLoggingService.class);
            if (null != object) {
                this.setHttpLogger((HTTPLoggingService)object);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Config: using logger service");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Config: Svc lookup failed, disabling logging.");
                }
                this.setHttpLogger(DisabledHTTPLogger.getRef());
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: Creating custom logger");
            }
            BaseLogger baseLogger = new BaseLogger();
            this.setHttpLogger(baseLogger);
            this.parseAccessLog(baseLogger, channelData, map, string);
            this.parseErrorLog(baseLogger, map, string2);
        }
    }

    private void parseAccessLog(BaseLogger baseLogger, ChannelData channelData, Map map, String string) {
        if (null != string) {
            try {
                baseLogger.createAccessLogger(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Config: Filename failed: " + string);
                }
                return;
            }
            this.parseAccessMaxSize(map);
            this.parseAccessMaxFiles(map);
            this.parseNCSAFormat(map, channelData);
            baseLogger.enableAccessLogging();
            baseLogger.startAccessLogging();
        }
    }

    private void parseErrorLog(BaseLogger baseLogger, Map map, String string) {
        if (null != string) {
            String string2 = (String)map.get("loggingLevel");
            if (null == string2) {
                string2 = HttpConstants.LOG_WARN.getName();
            }
            try {
                baseLogger.createErrorLogger(string, string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Config: Filename failed: " + string);
                }
                return;
            }
            this.parseErrorMaxSize(map);
            this.parseErrorMaxFiles(map);
            baseLogger.enableErrorLogging();
            baseLogger.startErrorLogging();
        }
    }

    private void parseAccessMaxSize(Map map) {
        block3: {
            String string = (String)map.get("accessLogMaximumSize");
            if (null != string) {
                try {
                    this.getHttpLogger().setAccessLogMaximumSize(Integer.parseInt(string) * 1000000);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: invalid access size: " + string);
                }
            }
        }
    }

    private void parseErrorMaxSize(Map map) {
        block3: {
            String string = (String)map.get("errorLogMaximumSize");
            if (null != string) {
                try {
                    this.getHttpLogger().setErrorLogMaximumSize(Integer.parseInt(string) * 1000000);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: invalid error size: " + string);
                }
            }
        }
    }

    private void parseAccessMaxFiles(Map map) {
        block3: {
            String string = (String)map.get("MaximumAccessBackupFiles");
            if (null != string) {
                try {
                    this.getHttpLogger().setAccessLogMaximumBackupFiles(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: invalid access max files: " + string);
                }
            }
        }
    }

    private void parseErrorMaxFiles(Map map) {
        block3: {
            String string = (String)map.get("MaximumErrorBackupFiles");
            if (null != string) {
                try {
                    this.getHttpLogger().setErrorLogMaximumBackupFiles(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: invalid error max files: " + string);
                }
            }
        }
    }

    private void parseNCSAFormat(Map map, ChannelData channelData) {
        boolean bl;
        String string = (String)map.get("loggingFormatCombined");
        if (null != string && (bl = this.convertBoolean(string))) {
            this.getHttpLogger().setAccessFormat(1);
        }
        this.getHttpLogger().log(HttpConstants.LOG_DEBUG, this.isNCSACombinedFormat() ? "Configuration specifies the NCSA combined format for " + channelData.getName() : "Configuration specifies the NCSA common format for " + channelData.getName(), null);
    }

    private void parseAllowRetries(Map map) {
        String string = (String)map.get("allowRetries");
        if (null != string) {
            this.setAllowRetries(this.convertBoolean(string));
        } else if (this.runningOnZOS() && !this.isServantRegion()) {
            this.setAllowRetries(false);
        }
    }

    private void parseZOSInfo(Map map) {
        String string = (String)map.get("RunningOnZOS");
        if (null != string) {
            this.setRunningOnZOS(this.convertBoolean(string));
        }
        if (null != (string = (String)map.get("ServantRegion")) && this.convertBoolean(string)) {
            this.setServantRegionFlag(true);
            if (!this.runningOnZOS()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Config: SR detection setting z/OS flag to true.");
                }
                this.bRunningOnZOS = true;
            }
            this.bJITOnlyReads = true;
        }
        if (null != (string = (String)map.get("ControlRegion")) && this.convertBoolean(string)) {
            this.setControlRegionFlag(true);
            if (!this.runningOnZOS()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Config: CR detection setting z/OS flag to true.");
                }
                this.bRunningOnZOS = true;
            }
        }
        this.parseJITOnlyReads(map);
    }

    private void parseHeaderValidation(Map map) {
        String string = (String)map.get("splitResponseProtection");
        if (null != string && !this.convertBoolean(string)) {
            this.setHeaderValidation(false);
        }
    }

    private void parseJITOnlyReads(Map map) {
        String string = (String)map.get("JITOnlyReads");
        if (null != string) {
            this.setJITOnlyReads(this.convertBoolean(string));
        }
    }

    private void parseStrictURLFormat(Map map) {
        String string = (String)map.get("StrictURLFormat");
        if (null != string) {
            this.setStrictURLFormat(this.convertBoolean(string));
        }
    }

    private void parseServerHeader(Map map) {
        String string = (String)map.get("ServerHeaderValue");
        if (null != string && !"".equals(string)) {
            this.setServerHeaderValue(string);
        } else {
            this.setServerHeaderValue("WebSphere Application Server/6.1");
        }
        string = (String)map.get("RemoveServerHeader");
        if (null != string) {
            this.setRemoveServerHeader(this.convertBoolean(string));
        }
    }

    private void parseDateHeaderRange(Map map) {
        block3: {
            String string = (String)map.get("DateHeaderRange");
            if (null != string) {
                try {
                    this.setDateHeaderRange(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Date header range of " + string + " is invalid.");
                }
            }
        }
    }

    private void parseCookieUpdate(Map map) {
        String string = (String)map.get("CookiesConfigureNoCache");
        if (null != string) {
            this.setCookiesConfigureNoCache(this.convertBoolean(string));
        }
    }

    private void parseHeaderChangeLimit(Map map) {
        block3: {
            String string = (String)map.get("HeaderChangeLimit");
            if (null != string) {
                try {
                    this.setHeaderChangeLimit(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Config: Header change count of " + string + " is invalid.");
                }
            }
        }
    }

    private boolean convertBoolean(String string) {
        return "true".equalsIgnoreCase(string);
    }

    private int rangeLimit(int n, int n2, int n3) {
        if (n < n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: " + n + " too small");
            }
            return n2;
        }
        if (n > n3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: " + n + " too large");
            }
            return n3;
        }
        return n;
    }

    private int minLimit(int n, int n2) {
        if (n < n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: " + n + " too small.");
            }
            return n2;
        }
        return n;
    }

    public int getMaximumPersistentRequests() {
        return this.maxPersistRequest;
    }

    private void setMaximumPersistentRequests(int n) {
        this.maxPersistRequest = this.minLimit(n, -1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the maximum persistent requests to " + this.getMaximumPersistentRequests());
        }
    }

    public VersionValues getOutgoingVersion() {
        return this.outgoingHttpVersion;
    }

    private void setOutgoingVersion(VersionValues versionValues) {
        this.outgoingHttpVersion = versionValues;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the Http Version to " + this.getOutgoingVersion().getName());
        }
    }

    public boolean isDirectBufferType() {
        return this.bDirectBuffers;
    }

    private void setDirectBufferType(boolean bl) {
        this.bDirectBuffers = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: use directBuffers set to " + this.isDirectBufferType());
        }
    }

    public boolean isKeepAliveEnabled() {
        return this.bKeepAliveEnabled;
    }

    private void setKeepAliveEnabled(boolean bl) {
        this.bKeepAliveEnabled = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: KeepAliveEnabled set to " + this.isKeepAliveEnabled());
        }
    }

    public int getOutgoingHdrBufferSize() {
        return this.outgoingHdrBuffSize;
    }

    private void setOutgoingHdrBufferSize(int n) {
        this.outgoingHdrBuffSize = this.rangeLimit(n, 1024, 0x100000);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: Outgoing hdr buffer size set to " + this.getOutgoingHdrBufferSize());
        }
    }

    public int getIncomingHdrBufferSize() {
        return this.incomingHdrBuffSize;
    }

    private void setIncomingHdrBufferSize(int n) {
        this.incomingHdrBuffSize = this.rangeLimit(n, 1024, 0x100000);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: Incoming hdr buffer size set to " + this.getIncomingHdrBufferSize());
        }
    }

    public int getIncomingBodyBufferSize() {
        return this.incomingBodyBuffSize;
    }

    private void setIncomingBodyBufferSize(int n) {
        this.incomingBodyBuffSize = this.rangeLimit(n, 1024, 0x100000);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: Incoming body buffer size set to " + this.getIncomingBodyBufferSize());
        }
    }

    public int getPersistTimeout() {
        return this.persistTimeout;
    }

    private void setPersistTimeout(int n) {
        this.persistTimeout = this.minLimit(n, 0) * 1000;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: Persist timeout set to " + this.getPersistTimeout());
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    private void setReadTimeout(int n) {
        this.readTimeout = this.minLimit(n, 0) * 1000;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: Read timeout set to " + this.getReadTimeout());
        }
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    private void setWriteTimeout(int n) {
        this.writeTimeout = this.minLimit(n, 0) * 1000;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: Write timeout set to " + this.getWriteTimeout());
        }
    }

    public int getByteCacheSize() {
        return this.byteCacheSize;
    }

    private void setByteCacheSize(int n) {
        this.byteCacheSize = this.rangeLimit(n, 256, 2048);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the byte cache size to " + this.getByteCacheSize());
        }
    }

    public boolean shouldExtractValue() {
        return this.bExtractValue;
    }

    private void setExtractValue(boolean bl) {
        this.bExtractValue = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the value extraction to " + this.shouldExtractValue());
        }
    }

    public boolean isBinaryTransportEnabled() {
        return this.bBinaryTransport;
    }

    private void setBinaryTransport(boolean bl) {
        this.bBinaryTransport = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the binary transport flag to " + this.isBinaryTransportEnabled());
        }
    }

    public HTTPLoggingService getHttpLogger() {
        return this.httpLogger;
    }

    public void setHttpLogger(HTTPLoggingService hTTPLoggingService) {
        this.httpLogger = hTTPLoggingService;
    }

    public boolean isAccessLoggingEnabled() {
        return this.getHttpLogger().isAccessLoggingEnabled();
    }

    public boolean isErrorLoggingEnabled() {
        return this.getHttpLogger().isErrorLoggingEnabled();
    }

    public boolean isErrorLoggingEnabledAtDebug() {
        return this.getHttpLogger().isLoggingLevelEnabled(HttpConstants.LOG_DEBUG);
    }

    public boolean isNCSACombinedFormat() {
        return 1 == this.getHttpLogger().getAccessFormat();
    }

    public int getLimitOfFieldSize() {
        return this.limitFieldSize;
    }

    private void setLimitOfFieldSize(int n) {
        this.limitFieldSize = this.rangeLimit(n, 50, 32768);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the limit on field size to " + this.getLimitOfFieldSize());
        }
    }

    public int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    private void setLimitOnNumberOfHeaders(int n) {
        this.limitNumHeaders = this.rangeLimit(n, 50, 500);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the limit on number of headers to " + this.getLimitOnNumberOfHeaders());
        }
    }

    public int getLimitOnNumberOfResponses() {
        return this.limitNumResponses;
    }

    private void setLimitOnNumberOfResponses(int n) {
        this.limitNumResponses = -1 == n ? 50 : this.rangeLimit(n, 1, 50);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the limit on number of responses to " + this.getLimitOnNumberOfResponses());
        }
    }

    public boolean isKeepThread() {
        return this.bKeepThread;
    }

    private void setKeepThread(boolean bl) {
        this.bKeepThread = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the keepthread flag to " + this.isKeepThread());
        }
    }

    public boolean allowsRetries() {
        return this.bAllowRetries;
    }

    private void setAllowRetries(boolean bl) {
        this.bAllowRetries = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the allow retries flag to " + this.allowsRetries());
        }
    }

    public boolean isServantRegion() {
        return this.bServantRegion;
    }

    private void setServantRegionFlag(boolean bl) {
        this.bServantRegion = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the Z servant region flag to " + bl);
        }
    }

    public boolean isControlRegion() {
        return this.bControlRegion;
    }

    private void setControlRegionFlag(boolean bl) {
        this.bControlRegion = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set the Z control region flag to " + bl);
        }
    }

    public boolean runningOnZOS() {
        return this.bRunningOnZOS;
    }

    private void setRunningOnZOS(boolean bl) {
        this.bRunningOnZOS = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: running on z/OS is " + bl);
        }
    }

    public boolean isHeaderValidationEnabled() {
        return this.bHeaderValidation;
    }

    private void setHeaderValidation(boolean bl) {
        this.bHeaderValidation = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: header validation is " + this.bHeaderValidation);
        }
    }

    public boolean isJITOnlyReads() {
        return this.bJITOnlyReads;
    }

    private void setJITOnlyReads(boolean bl) {
        this.bJITOnlyReads = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: JIT only reads set to " + bl);
        }
    }

    public boolean isStrictURLFormat() {
        return this.bStrictURLFormat;
    }

    private void setStrictURLFormat(boolean bl) {
        this.bStrictURLFormat = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: Strict URL formatting set to " + bl);
        }
    }

    public byte[] getServerHeaderValue() {
        return this.baServerHeaderValue;
    }

    private void setServerHeaderValue(String string) {
        this.baServerHeaderValue = GenericUtils.getEnglishBytes(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: server header value set to " + string);
        }
    }

    public boolean removeServerHeader() {
        return this.bRemoveServerHeader;
    }

    private void setRemoveServerHeader(boolean bl) {
        this.bRemoveServerHeader = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: remove server header set to " + bl);
        }
    }

    public long getDateHeaderRange() {
        return this.lDateHeaderRange;
    }

    private void setDateHeaderRange(long l) throws NumberFormatException {
        if (0L > l) {
            throw new NumberFormatException("Date range invalid: " + l);
        }
        this.lDateHeaderRange = l;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: date header range is " + l);
        }
    }

    public boolean shouldCookiesConfigureNoCache() {
        return this.bCookiesConfigureNoCache;
    }

    private void setCookiesConfigureNoCache(boolean bl) {
        this.bCookiesConfigureNoCache = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: set-cookie configuring no-cache is " + bl);
        }
    }

    public int getHeaderChangeLimit() {
        return this.headerChangeLimit;
    }

    private void setHeaderChangeLimit(int n) {
        this.headerChangeLimit = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Config: header change limit is " + n);
        }
    }
}

