/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ws.ffdc.AnalysisEngineWrapper;
import com.ibm.ws.ffdc.CallStack;
import com.ibm.ws.ffdc.Configure;
import com.ibm.ws.ffdc.DiagnosticEngine;
import com.ibm.ws.ffdc.ExceptionEntry;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.FFDCHelper;
import com.ibm.ws.ffdc.FFDCJanitor;
import com.ibm.ws.ffdc.IncidentStreamManager;
import com.ibm.ws.ffdc.WrappingFileOutputStream;
import com.ibm.wsspi.ffdc.FFDCService;
import java.io.File;
import java.io.PrintStream;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;

public class FFDCImpl
implements FFDCService {
    private static boolean isInitialized;
    private static Configure currentConfiguration;
    private static HashMap exceptionTable;
    private static final Object reEntrantObject;
    private static final ThreadLocal threadLocal;
    private static int exceptionCount;
    private static Object tableGuard;
    private static Object fileGuard;
    private static long lastTimeOfDump;
    private static int numberOfEntiesProcessed;
    private static final long lowWaterTime = 60000L;
    private static final int normalDumpThreshold = 10;
    private static final long highWaterTime = 300000L;
    private static final Object LAE;
    private static long lastRead;
    private static int tableEntries;
    private static int internalFailures;
    private static int analysisEngineFailures;
    private static final int internalFailureLimit = 10;
    private static String exceptionFileName;
    private static FFDCJanitor janitor;

    public void processException(Throwable throwable, String string, String string2) {
        try {
            FFDCImpl.filterEngine(throwable, string, string2, null, null);
        }
        catch (Throwable throwable2) {
            FFDCImpl.internalProblem(throwable2, currentConfiguration);
        }
    }

    public void processException(Throwable throwable, String string, String string2, Object object) {
        try {
            FFDCImpl.filterEngine(throwable, string, string2, object, null);
        }
        catch (Throwable throwable2) {
            FFDCImpl.internalProblem(throwable2, currentConfiguration);
        }
    }

    public void processException(Throwable throwable, String string, String string2, Object[] objectArray) {
        try {
            FFDCImpl.filterEngine(throwable, string, string2, null, objectArray);
        }
        catch (Throwable throwable2) {
            FFDCImpl.internalProblem(throwable2, currentConfiguration);
        }
    }

    public void processException(Throwable throwable, String string, String string2, Object object, Object[] objectArray) {
        try {
            FFDCImpl.filterEngine(throwable, string, string2, object, objectArray);
        }
        catch (Throwable throwable2) {
            FFDCImpl.internalProblem(throwable2, currentConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterEngine(Throwable throwable, String string, String string2, Object object, Object[] objectArray) throws Throwable {
        block26: {
            if (!isInitialized) {
                return;
            }
            Configure configure = currentConfiguration;
            if (!configure.theSwitch || configure.processLevel == 0) {
                return;
            }
            ExceptionEntry exceptionEntry = null;
            String string3 = null;
            boolean bl = false;
            long l = 0L;
            int n = 1;
            boolean bl2 = false;
            boolean bl3 = false;
            long l2 = 0L;
            boolean bl4 = false;
            boolean bl5 = false;
            Object var18_16 = null;
            String string4 = null;
            String[] stringArray = null;
            String[] stringArray2 = null;
            String string5 = null;
            boolean bl6 = false;
            String string6 = null;
            try {
                l = System.currentTimeMillis();
                if (configure.refreshInterval != 0 && FFDCImpl.checkIfRefreshNeeded(l, configure.refreshInterval)) {
                    configure = currentConfiguration;
                }
                if (janitor == null) {
                    janitor = FFDCJanitor.getInstance();
                }
                janitor.doCleanupIfNeeded();
                string3 = throwable.getClass().getName();
                string5 = FFDCImpl.formKey(string3, string, string2);
                if (exceptionTable.containsKey(string5)) {
                    exceptionEntry = (ExceptionEntry)exceptionTable.get(string5);
                    ++exceptionEntry.count;
                    l2 = exceptionEntry.timeStamp;
                    exceptionEntry.timeStamp = l;
                    n = exceptionEntry.count;
                    bl2 = exceptionEntry.include;
                    bl3 = exceptionEntry.exclude;
                } else {
                    exceptionEntry = new ExceptionEntry(string3, string, string2, l);
                    Object object2 = tableGuard;
                    synchronized (object2) {
                        exceptionTable.put(string5, exceptionEntry);
                        ++tableEntries;
                    }
                    bl6 = true;
                }
                ++exceptionCount;
                if (FFDCImpl.dumpAlgorithm(l)) {
                    FFDCImpl.dumpHashTable(tableEntries, configure.exceptionFileSize, configure.exceptionFileBackup);
                } else if (bl6) {
                    FFDCImpl.dumpEntry(exceptionEntry, tableEntries, configure.exceptionFileSize, configure.exceptionFileBackup);
                }
                if (configure.processLevel == 1) {
                    return;
                }
                if (threadLocal.get() != null) {
                    bl5 = true;
                    return;
                }
                threadLocal.set(reEntrantObject);
                bl4 = true;
                if (!FFDCImpl.dynamicDump(l, l2, n, bl2, bl3, configure)) break block26;
                string4 = CallStack.getCallStack(throwable);
                stringArray = CallStack.exceptionCallStack(string4);
                string6 = string3 + ' ' + string + ' ' + string2;
                if (stringArray != null && configure.useLogAnalysisEngine && analysisEngineFailures < 10) {
                    try {
                        stringArray2 = AnalysisEngineWrapper.checkKnowledgeBase(string3, stringArray, string6, configure.exceptionFileSize, configure.exceptionFileBackup);
                    }
                    catch (Throwable throwable2) {
                        ++analysisEngineFailures;
                    }
                }
                DiagnosticEngine.processIncident(object, throwable, string3, string, string2, string4, stringArray2, stringArray, l, string6, objectArray);
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                if (!bl5) {
                    if (bl4) {
                        threadLocal.set(null);
                    }
                    IncidentStreamManager.closeIncidentStream(null);
                }
            }
        }
    }

    private static String formKey(String string, String string2, String string3) {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(string.length() + string2.length() + string3.length());
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(string3);
        return new String(stringBuffer);
    }

    private static boolean dumpAlgorithm(long l) {
        boolean bl = false;
        ++numberOfEntiesProcessed;
        if (l - lastTimeOfDump > 300000L) {
            bl = true;
        } else if (numberOfEntiesProcessed > 10 && l - lastTimeOfDump > 60000L) {
            bl = true;
        }
        if (bl) {
            lastTimeOfDump = l;
            numberOfEntiesProcessed = 0;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpException(String string, String string2, String string3, String string4, int n, int n2) {
        PrintStream printStream = null;
        Object object = fileGuard;
        synchronized (object) {
            try {
                printStream = FFDCImpl.openFile(n, n2);
                if (printStream == null) {
                    return;
                }
                printStream.println("-----------------------------------------------------------------------");
                printStream.println(string + " " + string2 + " " + string3);
                printStream.println(string4);
                printStream.println("-----------------------------------------------------------------------");
                printStream.close();
            }
            catch (Throwable throwable) {
                FFDCImpl.internalProblem(throwable, currentConfiguration);
                return;
            }
        }
    }

    private static void dumpHashTable(int n, int n2, int n3) {
        FFDCImpl.dumpHashTable(null, n, n2, n3);
    }

    private static void dumpEntry(ExceptionEntry exceptionEntry, int n, int n2, int n3) {
        FFDCImpl.dumpHashTable(exceptionEntry, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpHashTable(ExceptionEntry exceptionEntry, int n, int n2, int n3) {
        PrintStream printStream = null;
        Iterator iterator = null;
        ExceptionEntry exceptionEntry2 = null;
        int n4 = 0;
        Object object = fileGuard;
        synchronized (object) {
            try {
                printStream = FFDCImpl.openFile(n2, n3);
                if (printStream == null) {
                    return;
                }
                if (exceptionEntry == null) {
                    iterator = exceptionTable.values().iterator();
                    try {
                        printStream.println();
                        printStream.println(" Index  Count   Time of last Occurrence   Exception SourceId ProbeId");
                        printStream.println("------+------+---------------------------+--------------------------");
                        Object object2 = tableGuard;
                        synchronized (object2) {
                            while (iterator.hasNext()) {
                                exceptionEntry2 = (ExceptionEntry)iterator.next();
                                printStream.println(exceptionEntry2.format(++n4));
                            }
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        printStream.println("incomplete  dump, see next entry for full table");
                    }
                    printStream.println("------+------+---------------------------+--------------------------");
                } else {
                    printStream.println("+" + exceptionEntry.format(n).substring(1));
                }
                printStream.close();
            }
            catch (Throwable throwable) {
                FFDCImpl.internalProblem(throwable, currentConfiguration);
                return;
            }
        }
    }

    private static PrintStream openFile(int n, int n2) {
        PrintStream printStream = null;
        String string = null;
        int n3 = 0;
        if (n > 0x100000) {
            n = 0x100000;
        }
        if ((n3 = n * 1024) < 0) {
            n3 = 0x100000;
        }
        try {
            string = FFDCImpl.getFileName();
            if (string == null) {
                return null;
            }
            WrappingFileOutputStream wrappingFileOutputStream = new WrappingFileOutputStream(string, n3, n2);
            printStream = new PrintStream(wrappingFileOutputStream);
        }
        catch (Throwable throwable) {
            FFDCImpl.internalProblem(throwable, currentConfiguration);
            return null;
        }
        return printStream;
    }

    private static String getFileName() {
        String string = "exception";
        String string2 = null;
        string2 = FFDCHelper.getServerName();
        if (string2 == null || string2.length() == 0) {
            string2 = "serverName";
        }
        try {
            String string3 = FFDCHelper.getDefaultLoggingDirectory();
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(string3);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(string2);
            stringBuffer.append('_');
            stringBuffer.append(string);
            stringBuffer.append(FFDC.getExceptionIndexFileNameExtension());
            return new String(stringBuffer);
        }
        catch (Throwable throwable) {
            FFDCImpl.internalProblem(throwable, currentConfiguration);
            return null;
        }
    }

    private static boolean dynamicDump(long l, long l2, int n, boolean bl, boolean bl2, Configure configure) {
        if (bl) {
            return true;
        }
        if (bl2) {
            return false;
        }
        if (n > configure.numberOfTimesToProcess) {
            return false;
        }
        if (configure.timeBetweenProcessing == 0L && n <= configure.numberOfTimesToProcess) {
            return true;
        }
        return configure.timeBetweenProcessing != 0L && (l2 == 0L || l - l2 >= configure.timeBetweenProcessing);
    }

    private static boolean checkIfRefreshNeeded(long l, int n) {
        long l2 = 0L;
        double d = 0.0;
        if (lastRead == 0L) {
            lastRead = l;
        } else {
            l2 = l - lastRead;
            d = l2 / 60000L;
            if (d > (double)n) {
                FFDC.configureComponents();
                lastRead = l;
                return true;
            }
        }
        return false;
    }

    static void configure(Configure configure) {
        Configure configure2 = null;
        long l = 0L;
        if (!isInitialized) {
            exceptionTable = new HashMap(100);
        }
        l = System.currentTimeMillis();
        configure2 = currentConfiguration;
        currentConfiguration = configure;
        if (configure2 != null) {
            if (configure2.exclusionList != null) {
                FFDCImpl.primeTable(configure2.exclusionList, false, false, l);
            }
            if (configure2.inclusionList != null) {
                FFDCImpl.primeTable(configure2.inclusionList, false, false, l);
            }
        }
        if (configure.exclusionList != null) {
            FFDCImpl.primeTable(configure.exclusionList, false, true, l);
        }
        if (configure.inclusionList != null) {
            FFDCImpl.primeTable(configure.inclusionList, true, false, l);
        }
        isInitialized = true;
        if (configure.currentState == 3 && configure2.theSwitch) {
            FFDCImpl.dumpHashTable(exceptionCount, FFDCImpl.currentConfiguration.exceptionFileSize, FFDCImpl.currentConfiguration.exceptionFileBackup);
        }
    }

    private static void primeTable(String[] stringArray, boolean bl, boolean bl2, long l) {
        String[] stringArray2 = null;
        String string = null;
        ExceptionEntry exceptionEntry = null;
        try {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                stringArray2 = FFDCHelper.split(stringArray[i], 58);
                if (stringArray2 == null || stringArray2.length != 3) continue;
                string = FFDCImpl.formKey(stringArray2[0], stringArray2[1], stringArray2[2]);
                if (exceptionTable.containsKey(string)) {
                    exceptionEntry = (ExceptionEntry)exceptionTable.get(string);
                    exceptionEntry.include = bl;
                    exceptionEntry.exclude = bl2;
                    continue;
                }
                exceptionEntry = new ExceptionEntry(stringArray2[0], stringArray2[1], stringArray2[2], l, bl, bl2);
                exceptionTable.put(string, exceptionEntry);
                ++tableEntries;
            }
        }
        catch (Throwable throwable) {
            FFDCImpl.internalProblem(throwable, currentConfiguration);
        }
    }

    private static void internalProblem(Throwable throwable, Configure configure) {
        boolean bl = false;
        try {
            if (configure != null && configure.debugMode) {
                bl = true;
                throwable.printStackTrace();
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        if (++internalFailures > 10) {
            isInitialized = false;
            if (bl) {
                System.out.println("Disable ffdc filter (" + internalFailures + ")");
            }
        }
    }

    static {
        Tr.setupLogging();
        reEntrantObject = new Object();
        threadLocal = new ThreadLocal();
        exceptionCount = 0;
        tableGuard = new Object();
        fileGuard = new Object();
        lastTimeOfDump = 0L;
        numberOfEntiesProcessed = 0;
        LAE = null;
        lastRead = 0L;
        tableEntries = 0;
        internalFailures = 0;
        analysisEngineFailures = 0;
        exceptionFileName = null;
        janitor = null;
    }
}

