/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.ExtensionRegistry;
import com.ibm.ws.extension.thinregistry.PluginDescriptor;
import com.ibm.ws.extension.thinregistry.PluginParser;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.xml.sax.InputSource;

public class RegistryLoader {
    private static final String srcClass = "RegistryLoader";
    private ExtensionRegistry _registry = null;
    private PluginParser _parser = null;

    public RegistryLoader(ExtensionRegistry extensionRegistry) {
        this._registry = extensionRegistry;
        this._parser = new PluginParser();
    }

    public void addToRegistry(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block2: {
                    try {
                        Enumeration<URL> enumeration = classLoader.getResources("plugin.xml");
                        RegistryLoader.this.loadAllPluginXmls(enumeration, classLoader);
                        enumeration = classLoader.getResources("fragment.xml");
                        RegistryLoader.this.loadAllPluginXmls(enumeration, classLoader);
                    }
                    catch (IOException iOException) {
                        if (!LoggingServices.debugEnabled) break block2;
                        LoggingServices.trace("Exception loading plugin descriptors: ", iOException);
                    }
                }
                return null;
            }
        });
    }

    private void loadAllPluginXmls(Enumeration enumeration, ClassLoader classLoader) {
        try {
            while (true) {
                URL uRL = (URL)enumeration.nextElement();
                String string = uRL.toExternalForm();
                URLConnection uRLConnection = null;
                try {
                    uRLConnection = uRL.openConnection();
                }
                catch (IOException iOException) {
                    continue;
                }
                this.loadPluginXml(uRL, classLoader);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private boolean loadPluginXml(URL uRL, ClassLoader classLoader) {
        boolean bl;
        block3: {
            bl = false;
            String string = uRL.toExternalForm();
            try {
                InputSource inputSource = new InputSource(uRL.openStream());
                inputSource.setSystemId(string);
                PluginDescriptor pluginDescriptor = this._parser.parsePlugin(inputSource);
                if (pluginDescriptor != null) {
                    pluginDescriptor.setPluginClassLoader(classLoader);
                    pluginDescriptor.setInstallURL(uRL);
                    this._registry.addPlugin(pluginDescriptor);
                    bl = true;
                }
            }
            catch (IOException iOException) {
                if (!LoggingServices.debugEnabled) break block3;
                LoggingServices.trace("Exception parsing plugin descriptor: ", iOException);
            }
        }
        return bl;
    }

    void releaseLoader() {
        this._parser.releaseParser();
        this._parser = null;
    }
}

