/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.ws.cluster.topography.IntrinsicDescriptionA;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClusterMemberDescriptionImpl
extends IntrinsicDescriptionA
implements ClusterMemberDescription {
    private static final TraceComponent tc = Tr.register(ClusterMemberDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected byte availability = 0;
    protected byte reachability = 0;
    protected boolean leaf = true;
    protected String version = "";
    protected Set clusterAssociations = Collections.synchronizedSet(new HashSet());
    private boolean debug = tc.isDebugEnabled();
    protected final Object lock = new Object();

    public ClusterMemberDescriptionImpl(DescriptionKey descriptionKey) {
        super(descriptionKey);
    }

    public synchronized void setState(byte by) {
        switch (by) {
            case 0: {
                if (this.reachability != by) {
                    this.setReachability(by);
                    break;
                }
                this.setAvailability(by);
                break;
            }
            case 3: 
            case 4: {
                this.setReachability(by);
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                this.setAvailability(by);
                break;
            }
            default: {
                this.setReachability(by);
                this.setAvailability(by);
            }
        }
    }

    public void setReachability(byte by) {
        if (by != this.reachability) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "setReachability [" + this.reachability + "] " + by, this.getKey());
            }
            this.reachability = by;
            this.notifyListeners("type.state.change.reachability", this);
            this.notifyListeners("type.state.change", this);
        }
    }

    public byte getReachability() {
        return this.reachability;
    }

    public void setAvailability(byte by) {
        if (this.availability != by) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "setAvailability [" + this.availability + "] " + by, this.getKey());
            }
            this.availability = by;
            this.updateMemento();
        }
    }

    public synchronized void setVersion(String string) {
        if (string != null) {
            this.version = string;
            this.updateMemento();
        }
    }

    public synchronized void setClusterAssociation(DescriptionKey descriptionKey) {
        this.clusterAssociations.add(descriptionKey);
        this.updateMemento();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "adding cluster association", new Object[]{descriptionKey, this.clusterAssociations});
        }
    }

    public synchronized void removeClusterAssociation(DescriptionKey descriptionKey) {
        if (this.clusterAssociations.contains(descriptionKey)) {
            this.clusterAssociations.remove(descriptionKey);
            this.updateMemento();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "removed cluster association", new Object[]{descriptionKey, this.clusterAssociations});
            }
        }
    }

    public String getDefinitionKey() {
        return ClusterMemberDescription.class.getName();
    }

    public synchronized void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        dataOutput.writeByte(0);
        if (this.debug) {
            Tr.debug(tc, "wrote version 0");
        }
        super.exportToStream(dataOutput, format);
        int n = format.getType();
        ClusterMemberDescription.Memento memento = null;
        if (n == 3) {
            memento = (ClusterMemberDescription.Memento)this.getMemento();
        }
        byte by = this.availability;
        String string = this.version;
        if (memento != null) {
            by = memento.getState();
            string = memento.getVersion();
        }
        dataOutput.writeByte(by);
        if (this.debug) {
            Tr.debug(tc, "wrote state " + by);
        }
        dataOutput.writeUTF(string);
        if (this.debug) {
            Tr.debug(tc, "wrote version " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public synchronized Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        MementoImpl mementoImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((mementoImpl = (MementoImpl)memento) == null) {
            mementoImpl = (MementoImpl)this.createMemento();
        }
        byte by = dataInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "read version " + by);
        }
        super.importFromStream(dataInput, format, mementoImpl);
        mementoImpl.m_availability = dataInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "read state " + mementoImpl.m_availability);
        }
        mementoImpl.m_version = dataInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "read version " + mementoImpl.m_version);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return mementoImpl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[").append(super.toString()).append(" available:").append(this.availability).append(" reachable:").append(this.reachability);
        stringBuffer.append(" leaf:").append(this.leaf);
        stringBuffer.append(" version:").append(this.version).append(']');
        return stringBuffer.toString();
    }

    public void setMemento(Description.Memento memento) {
        MementoImpl mementoImpl = (MementoImpl)memento;
        MementoImpl mementoImpl2 = (MementoImpl)this.getMemento();
        if (mementoImpl.m_availability == -128) {
            mementoImpl.m_availability = 0;
        }
        super.setMemento(memento);
        if (mementoImpl2.m_availability != mementoImpl.m_availability) {
            this.notifyListeners("type.state.change.availability", this);
            this.notifyListeners("type.state.change", this);
        }
        if (mementoImpl.m_availability == 0) {
            this.setReachability((byte)0);
        }
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.28 ");
        }
    }

    public class MementoImpl
    extends IntrinsicDescriptionA.MementoA
    implements ClusterMemberDescription.Memento {
        protected byte m_availability;
        protected String m_version;
        protected Set m_clusterAssociations;

        protected MementoImpl() {
            super(ClusterMemberDescriptionImpl.this);
            this.m_availability = 0;
            this.m_version = "";
            this.m_clusterAssociations = new HashSet();
        }

        public byte getState() {
            if (ClusterMemberDescriptionImpl.this.reachability == 0) {
                return this.m_availability;
            }
            return ClusterMemberDescriptionImpl.this.reachability;
        }

        public byte getAvailability() {
            return this.m_availability;
        }

        public String getVersion() {
            return this.m_version;
        }

        public boolean isLeaf() {
            return true;
        }

        public Set getClusterAssociations() {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "returning cluster association", new Object[]{ClusterMemberDescriptionImpl.this.clusterAssociations});
            }
            return this.m_clusterAssociations;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[").append(super.toString());
            stringBuffer.append(" available:").append(this.m_availability);
            stringBuffer.append(" version:").append(this.m_version).append(']');
            return stringBuffer.toString();
        }
    }
}

