/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.algorithm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.wsspi.cluster.Identity;
import java.util.Random;

public final class WeightedProportionalAlgorithm
implements SelectionAlgorithm {
    private static final TraceComponent tc = Tr.register(WeightedProportionalAlgorithm.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Memento m;
    private static final Random random;
    private int index = random.nextInt(Integer.MAX_VALUE);
    private int round = 0;

    public WeightedProportionalAlgorithm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.prepare(new Identity[0], new int[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity select() {
        int n;
        Memento memento = this.m;
        if (memento.size == 0) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", this);
        }
        int n2 = 0;
        while ((long)n2 < memento.sum) {
            ++this.index;
            n = this.index %= memento.size;
            ++this.round;
            if ((long)this.round >= memento.sum) {
                this.round = 0;
                memento = this.m;
                if (memento.size == 0) {
                    return null;
                }
                n %= memento.size;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "variables", new Object[]{new StringBuffer("iteration ").append(n2).append(" index ").append(n).append(" round ").append(this.round).append(" total hits ").append(memento.totalhits).append(" sum ").append(memento.sum).append(" size ").append(memento.size), new StringBuffer("member ").append(memento.targets[n]).append(" weight ").append(memento.weights[n]).append(" hits ").append(memento.hits[n]).append(" proportion ").append(memento.proportion[n]).append(" hit proportion ").append(memento.hits[n] / memento.totalhits)});
            }
            if (memento.proportion[n] >= memento.hits[n] / memento.totalhits) {
                Memento memento2 = memento;
                synchronized (memento2) {
                    memento.totalhits += 1.0;
                    int n3 = n;
                    memento.hits[n3] = memento.hits[n3] + 1.0;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "select", "select - " + memento.targets[n]);
                }
                return memento.targets[n];
            }
            ++n2;
        }
        n2 = 0;
        if (n2 < memento.size) {
            ++this.index;
            n = this.index %= memento.size;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "select - outer loop " + memento.targets[n]);
            }
            return memento.targets[n];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", "select - null target " + this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Identity[] identityArray, int[] nArray) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", identityArray);
        }
        if (identityArray.length != nArray.length) {
            throw new IllegalStateException("The target and weight tables must have identical size.");
        }
        int n2 = identityArray.length;
        double d = n2;
        long l = 0L;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            l += nArray[i] <= 0 ? 0L : (long)nArray[i];
            dArray[i] = 1.0;
        }
        double[] dArray2 = new double[n2];
        if (l > 0L) {
            for (n = 0; n < n2; ++n) {
                dArray2[n] = nArray[n] <= 0 ? -1.0 : (double)nArray[n] / (double)l + 1.0E-16;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                dArray2[n] = 1.0 / (double)n2 + 1.0E-16;
            }
        }
        WeightedProportionalAlgorithm weightedProportionalAlgorithm = this;
        synchronized (weightedProportionalAlgorithm) {
            this.m = new Memento(identityArray, nArray, dArray2, n2, l, dArray, d);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare", this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[");
        stringBuffer.append(this.m.size);
        stringBuffer.append(" ");
        stringBuffer.append(this.m.sum);
        stringBuffer.append(" ");
        stringBuffer.append(this.index);
        stringBuffer.append(" ");
        stringBuffer.append(this.round);
        stringBuffer.append(" ");
        stringBuffer.append(this.m.totalhits);
        stringBuffer.append(" ");
        for (int i = 0; i < this.m.size; ++i) {
            stringBuffer.append(this.m.targets[i]);
            stringBuffer.append(" ");
            stringBuffer.append(this.m.weights[i]);
            stringBuffer.append(" ");
            stringBuffer.append(this.m.hits[i]);
            stringBuffer.append(" ");
            stringBuffer.append(this.m.proportion[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.22 ");
        }
        random = new Random();
    }

    private final class Memento {
        final Identity[] targets;
        final int[] weights;
        double[] hits;
        double totalhits;
        final double[] proportion;
        final int size;
        final long sum;

        private Memento(Identity[] identityArray, int[] nArray, double[] dArray, int n, long l, double[] dArray2, double d) {
            this.targets = identityArray;
            this.weights = nArray;
            this.proportion = dArray;
            this.size = n;
            this.sum = l;
            this.hits = dArray2;
            this.totalhits = d;
        }
    }
}

