/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.service.ClusterServiceImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TargetImpl
implements Target {
    private static final TraceComponent tc = Tr.register(TargetImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ClusterMemberService cms = (ClusterMemberService)ProcessProperties.getInstance().get("key.clustermember.service");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final ProcessProperties processProps = ProcessProperties.getInstance();
    private static final Map scmdDistinction = new HashMap(1);
    Identity[] clusterIdentities = null;
    Identity memberIdentity = null;
    ClusterMemberDescription member = null;
    boolean inHost = false;
    boolean inProcess = false;
    boolean inServer = false;
    Map endPoints = null;
    ClusterService ivClusterService = ClusterServiceFactory.getClusterService();

    public TargetImpl(Identity[] identityArray, Identity identity, EndPoint[] endPointArray) {
        DescriptionKey descriptionKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{Arrays.toString(identityArray), identity, Arrays.toString(endPointArray)});
        }
        this.clusterIdentities = identityArray;
        this.memberIdentity = identity;
        this.member = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)this.memberIdentity);
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)this.member.getMemento();
        SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)memento.getExtrinsicData(descriptionKey = keyRepository.getDescriptionKey((DescriptionKey)identity, scmdDistinction));
        if (selectionClusterMemberDescription != null && ((SelectionClusterMemberDescription.Memento)selectionClusterMemberDescription.getMemento()).getHost().equals(processProps.get("key.virtual.host"))) {
            this.inHost = true;
        }
        if (this.cms != null) {
            this.inServer = this.cms.getServerClusterContextListener().validateClusterResidency(this.clusterIdentities[this.clusterIdentities.length - 1]);
            this.inProcess = this.cms.getServerClusterContextListener().validateClusterProcessResidency(this.clusterIdentities[this.clusterIdentities.length - 1]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", "ClusterMember=" + identity);
        }
        if (identity == null) {
            Tr.error(tc, "Target member is null for the key=" + identity);
        }
        this.endPoints = new HashMap();
        for (int i = 0; i < endPointArray.length; ++i) {
            this.endPoints.put(endPointArray[i].getIdentity(), endPointArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public Identity getMemberIdentity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberIdentity");
            Tr.exit(tc, "getMemberIdentity", this.memberIdentity);
        }
        return this.memberIdentity;
    }

    public Identity[] getClusterIdentities() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentities");
            Tr.exit(tc, "getClusterIdentities", this.clusterIdentities);
        }
        return this.clusterIdentities;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[clusterIdentities ");
        for (int i = 0; i < this.clusterIdentities.length; ++i) {
            stringBuffer.append(this.clusterIdentities[i]);
        }
        stringBuffer.append(", memberIdentity ").append(this.memberIdentity);
        stringBuffer.append(", endPoints ").append(this.endPoints);
        stringBuffer.append(", inHost ").append(this.inHost);
        stringBuffer.append(", inProcess ").append(this.inProcess);
        stringBuffer.append(", inServer ").append(this.inServer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public EndPoint selectEndPoint(Identity identity) {
        return (EndPoint)this.endPoints.get(identity);
    }

    public EndPoint[] matchEndPoints(Map map) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", map);
        }
        EndPoint[] endPointArray = null;
        endPointArray = ((ClusterServiceImpl)this.ivClusterService).matchEndPoints(this.endPoints, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints", endPointArray);
        }
        return endPointArray;
    }

    public void setAvailability(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailability", Boolean.toString(bl));
        }
        byte by = bl ? (byte)0 : 4;
        this.member.setReachability(by);
    }

    public boolean isTargetInHost() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInHost");
            Tr.exit(tc, "isTargetInHost", Boolean.toString(this.inHost));
        }
        return this.inHost;
    }

    public boolean isTargetInProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInProcess");
            Tr.exit(tc, "isTargetInProcess", Boolean.toString(this.inProcess));
        }
        return this.inProcess;
    }

    public ClusterMemberDescription getMember() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMember");
            Tr.exit(tc, "getMember", this.member);
        }
        return this.member;
    }

    public boolean isAvailable() {
        return ((ClusterMemberDescription.Memento)this.member.getMemento()).getState() == 0;
    }

    public boolean isTargetInServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInServer");
            Tr.exit(tc, "isTargetInServer", Boolean.toString(this.inServer));
        }
        return this.inServer;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.16 : none");
        }
        scmdDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
    }
}

