/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.HealthMonitorSleepTimePolicy;
import com.ibm.ws.cluster.channel.MonitorTaskInfo;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPool;
import java.util.WeakHashMap;

public class HealthMonitorSteppedSleepTimePolicy
implements HealthMonitorSleepTimePolicy {
    private static final TraceComponent tc = Tr.register(HealthMonitorSteppedSleepTimePolicy.class, "HealthMonitor", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int Default_Sleep_Poll_Interval = 1000;
    private WeakHashMap epTasks = null;
    private SleeperThreadPool sleeperThreadPool = null;
    private int sleepInterval = 1000;
    private int[][][] intervalMap = new int[][][]{new int[][]{{5, 1000}, {10, 5000}, {30, 15000}, {90, 60000}, {Integer.MAX_VALUE, 300000}}, new int[][]{{180, 5000}, {420, 15000}, {540, 60000}, {600, 120000}, {Integer.MAX_VALUE, 300000}}};

    public HealthMonitorSteppedSleepTimePolicy(WeakHashMap weakHashMap, SleeperThreadPool sleeperThreadPool) {
        this.epTasks = weakHashMap;
        this.sleeperThreadPool = sleeperThreadPool;
    }

    public int getSleepTime(MonitorTaskInfo monitorTaskInfo) {
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSleepTime");
        }
        int n3 = Math.abs(monitorTaskInfo.getTestCount());
        if (tc.isDebugEnabled()) {
            n2 = this.epTasks.size();
            int n4 = this.sleeperThreadPool.queueLength();
            n = this.sleeperThreadPool.getNumberOfFreeThread();
            int n5 = this.sleeperThreadPool.getLongestSleepTime();
            long l = System.currentTimeMillis();
            long l2 = monitorTaskInfo.getLastAccessedTimeStamp() - l;
            long l3 = monitorTaskInfo.getStateChangedTimeStamp() - l;
            Tr.debug(tc, "getSleepTime", new Object[]{"# of Tasks=" + n2, "thread Q Length=" + n4, "# Free Threads=" + n, "# Of Successive Test=" + n3, "longestSleepTime=" + n5, "last Access Interval=" + Long.toString(l2), "last State Changed Interval=" + Long.toString(l3)});
        }
        n2 = this.sleepInterval;
        int[][] nArray = this.intervalMap[monitorTaskInfo.getEndPoint().isAvailable() ? 0 : 1];
        for (n = 0; n < nArray.length; ++n) {
            if (n3 > nArray[n][0]) continue;
            n2 = nArray[n][1];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSleepTime", Integer.toString(n2));
        }
        return n2;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : 1.2 : none");
        }
    }
}

