/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.chains.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.ws.channel.framework.chains.Chain;
import com.ibm.ws.channel.framework.chains.impl.StopChainTask;
import com.ibm.ws.channel.framework.impl.ChainDataImpl;
import com.ibm.ws.channel.framework.impl.RuntimeState;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.framework.ChannelData;

public abstract class ChainImpl
implements Chain {
    private static final TraceComponent tc = Tr.register(ChainImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    protected Channel[] channels = null;
    protected ChainDataImpl chainData = null;
    protected RuntimeState state = RuntimeState.UNINITIALIZED;
    protected ChannelData[] channelDataArray = null;
    private StopChainTask stopChainTask = null;

    public ChainImpl(ChainData chainData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.chainData = (ChainDataImpl)chainData;
        this.state = RuntimeState.UNINITIALIZED;
        this.channelDataArray = new ChannelData[this.chainData.getChannelList().length];
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            this.channelDataArray[i] = (ChannelData)this.chainData.getChannelList()[i];
            this.channelDataArray[i].getPropertyBag().put("chainData", chainData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public String getName() {
        return this.chainData.getName();
    }

    public ChainData getChainData() {
        return this.chainData;
    }

    public Channel[] getChannels() {
        return this.channels;
    }

    public ChannelData[] getChannelsData() {
        return this.channelDataArray;
    }

    public RuntimeState getState() {
        return this.state;
    }

    public boolean containsChannel(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsChannel");
        }
        boolean bl = false;
        for (int i = 0; i < this.channels.length; ++i) {
            if (!this.channels[i].getName().equals(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found channel, " + string);
            }
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsChannel");
        }
        return bl;
    }

    public void setStopTask(StopChainTask stopChainTask) {
        this.stopChainTask = stopChainTask;
    }

    public StopChainTask getStopTask() {
        return this.stopChainTask;
    }

    public void init() {
        this.state = RuntimeState.INITIALIZED;
        this.chainData.chainInitialized();
    }

    public void start() {
        this.state = RuntimeState.STARTED;
        this.chainData.chainStarted();
    }

    public void quiesce() {
        this.state = RuntimeState.QUIESCED;
    }

    public void stop() {
        this.state = RuntimeState.INITIALIZED;
        this.chainData.chainStopped();
    }

    public void destroy() {
        this.state = RuntimeState.UNINITIALIZED;
        this.chainData.chainDestroyed();
    }

    public String toString() {
        return "Chain: " + this.chainData.getName() + "\r\n" + "\ttype = " + this.chainData.getType().getOrdinal() + "\r\n" + "\tstate: " + this.state.ordinal;
    }
}

