/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.common;

import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.ws.channel.common.ChannelPoolObject;
import com.ibm.ws.channel.common.ChannelUtilsBase;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ChannelUtilsLogger
extends ChannelUtilsBase {
    private static final String ME = ChannelUtilsLogger.class.getName();
    private static ChannelUtilsLogger chLogger = new ChannelUtilsLogger();

    public static ChannelPoolObject getChannelObject(Logger logger, String string, ObjectPool objectPool) {
        return chLogger.getObject(logger, string, objectPool, logger.isLoggable(Level.FINEST), logger.isLoggable(Level.FINE));
    }

    public static boolean releaseChannelObject(Logger logger, String string, ChannelPoolObject channelPoolObject, ObjectPool objectPool) {
        return chLogger.releaseObject(logger, string, channelPoolObject, objectPool, logger.isLoggable(Level.FINEST), logger.isLoggable(Level.FINE));
    }

    public static void printDebugStackTrace(Logger logger, Throwable throwable, String string) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceDebugStack(logger, throwable, string);
    }

    public static void printThreadStackTrace(Logger logger, Thread thread) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceThreadStack(logger, thread);
    }

    public static void displayChannels(Logger logger, ChannelFramework channelFramework, String string, String string2) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        if (channelFramework == null) {
            chLogger.debugTrace(logger, string2 + ", no cfw");
        } else {
            chLogger.traceChannels(logger, channelFramework, string, string2);
        }
    }

    public static void displayChains(Logger logger, ChannelFramework channelFramework, Class clazz, String string, String string2) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceChains((Object)logger, channelFramework, clazz, string, string2);
    }

    public static void displayChains(Logger logger, ChannelFramework channelFramework, String string, String string2, String string3) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceChains((Object)logger, channelFramework, string, string2, string3);
    }

    public static void displayChains(Logger logger, ChainData[] chainDataArray, String string, String string2) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        if (chainDataArray == null || chainDataArray.length == 0) {
            chLogger.debugTrace(logger, string2 + ", no chains to trace (" + string + ")");
        } else {
            chLogger.traceChains(logger, Arrays.asList(chainDataArray), string, string2);
        }
    }

    public static void displayChains(Logger logger, List list, String string, String string2) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceChains(logger, list, string, string2);
    }

    protected void debugTrace(Object object, String string) {
        ((Logger)object).finest(string);
    }

    protected void entryTrace(Object object, String string, Object object2) {
        ((Logger)object).entering(ME, string, object2);
    }

    protected void exitTrace(Object object, String string, Object object2) {
        ((Logger)object).exiting(ME, string, object2);
    }
}

