/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.ExtClassLoaderMBean;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ExtClassLoader
extends URLClassLoader
implements WsClassLoader,
ExtClassLoaderMBean {
    private Gateway gateway = null;
    private static ExtClassLoader instance;
    protected ArrayList containedPaths = new ArrayList();
    protected ArrayList nativePaths = new ArrayList();
    String classpath = null;
    String nativepath = null;

    public void installGateway(Gateway gateway) {
        if (this.gateway != null) {
            throw new IllegalStateException("Gateway cannot be installed twice");
        }
        this.gateway = gateway;
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        return super.loadClass(string, bl);
    }

    public static ExtClassLoader getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ExtClassLoader(System.getProperty("ws.ext.dirs"));
        return instance;
    }

    public ExtClassLoader(String string) {
        this(string, ClassLoader.getSystemClassLoader());
    }

    public ExtClassLoader(ClassLoader classLoader) {
        this((String)null, classLoader);
    }

    public ExtClassLoader(String string, ClassLoader classLoader) {
        super(new URL[0], classLoader);
        if (string != null) {
            this.addPath(string);
        }
        if (instance == null) {
            instance = this;
        }
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = super.findClass(string);
        if (WSLauncher.debug) {
            WSLauncher.out.println("[Loaded " + string + " by ExtClassLoader]");
        }
        return clazz;
    }

    protected String findLibrary(String string) {
        String string2;
        if (WSLauncher.debug) {
            WSLauncher.out.println("looking for library on nativepath: " + string);
        }
        if ((string2 = this.findLibrary0(string, this.nativePaths)) == null) {
            if (WSLauncher.debug) {
                WSLauncher.out.println("looking for library on classpath: " + string);
            }
            string2 = this.findLibrary0(string, this.containedPaths);
        }
        return string2;
    }

    protected String findLibrary0(String string, ArrayList arrayList) {
        final String string2 = System.mapLibraryName(string);
        final ArrayList arrayList2 = arrayList;
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        URL uRL = (URL)arrayList2.get(i);
                        File file = new File(uRL.getFile());
                        if (!file.isDirectory()) continue;
                        File file2 = new File(file, string2);
                        if (WSLauncher.debug) {
                            WSLauncher.out.println("File: " + file2.getPath() + (file2.isFile() ? " is a file" : " is not a file"));
                            WSLauncher.out.println("File: " + file2.getPath() + (file2.exists() ? " exists" : " does not exist"));
                        }
                        if (!file2.exists()) continue;
                        if (WSLauncher.debug) {
                            WSLauncher.out.println("library found: " + file2.getPath());
                        }
                        return file2.getPath();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public void addPath(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                Object[] objectArray;
                File file = new File(stringTokenizer.nextToken());
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (file.isDirectory()) {
                    objectArray = file.list();
                    if (objectArray != null) {
                        if (objectArray.length == 0) {
                            continue;
                        }
                    } else {
                        WSLauncher.out.println("An exception occurred while trying to retrieve the list of files in the directory \"" + file + "\".  Verify the permissions associated with this directory");
                    }
                }
                try {
                    objectArray = file.toURL();
                    this.addURL((URL)objectArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!file.isDirectory()) continue;
                if (WSLauncher.debug) {
                    WSLauncher.out.println("Adding jar and zip files from " + file.getPath());
                }
                if ((objectArray = file.list()) == null) continue;
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = ((String)objectArray[i]).toLowerCase();
                    if (WSLauncher.debug) {
                        WSLauncher.out.println("Checking file " + string2);
                    }
                    if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
                    File file2 = new File(file, (String)objectArray[i]);
                    try {
                        this.addURL(file2.toURL());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void addURL(URL uRL) {
        if (!this.containedPaths.contains(uRL)) {
            this.containedPaths.add(uRL);
            super.addURL(uRL);
            this.classpath = null;
        }
    }

    public String getClassPath() {
        if (this.classpath == null) {
            StringBuffer stringBuffer = new StringBuffer();
            URL[] uRLArray = super.getURLs();
            for (int i = 0; i < uRLArray.length; ++i) {
                try {
                    File file = new File(uRLArray[i].getFile());
                    stringBuffer.append(file.getCanonicalPath());
                    stringBuffer.append(File.pathSeparator);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuffer.append(System.getProperty("java.class.path"));
            this.classpath = stringBuffer.toString();
        }
        return this.classpath;
    }

    public URL[] getURLs() {
        return null;
    }

    public URL[] _getURLs() {
        return super.getURLs();
    }

    public void addNativePath(String string) {
        if (string == null) {
            if (WSLauncher.debug) {
                WSLauncher.out.println("Native path not added: invalid path argument (null)");
            }
        } else {
            File file = null;
            Exception exception = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    file = new File(stringTokenizer.nextToken()).getCanonicalFile();
                    this.nativePaths.add(file.toURL());
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                if (WSLauncher.debug) {
                    if (exception != null) {
                        WSLauncher.out.println("An error occurred adding native path \"" + (file == null ? "null" : file.toString()) + "\": " + exception);
                    } else if (!file.exists()) {
                        WSLauncher.out.println("Native path \"" + file.getPath() + "\" does not exist! Specify a directory containing a native library.");
                    } else if (!file.isDirectory()) {
                        WSLauncher.out.println("Native path \"" + file.getPath() + "\" is not a directory! Specify a directory containing a native library.");
                    } else {
                        String[] stringArray = file.list();
                        if (stringArray == null || stringArray.length == 0) {
                            WSLauncher.out.println("Native path \"" + file.getPath() + "\" is empty! Specify a directory containing a native library.");
                        } else {
                            boolean bl = false;
                            boolean bl2 = false;
                            String string2 = null;
                            for (int i = stringArray.length - 1; i >= 0; --i) {
                                if (stringArray[i] == null) continue;
                                string2 = stringArray[i].toLowerCase();
                                bl |= string2.endsWith(".dll") || string2.endsWith(".so") || string2.endsWith(".a");
                                bl2 |= string2.endsWith(".jar") || string2.endsWith(".zip") || string2.endsWith(".class");
                            }
                            if (!bl) {
                                WSLauncher.out.println("Native path \"" + file.getPath() + "\" contains no native libraries! Specify a directory containing a native library.");
                            }
                            if (bl2) {
                                WSLauncher.out.println("Native path \"" + file.getPath() + "\" contains JAR/Zip/class files. Should path be in classpath also/instead?");
                            }
                        }
                    }
                }
                file = null;
                exception = null;
            }
        }
    }

    public String getNativePath() {
        if (this.nativepath == null) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = this.nativePaths.toArray();
            for (int i = 0; i < this.nativePaths.size(); ++i) {
                try {
                    File file = new File(((URL)objectArray[i]).getFile());
                    stringBuffer.append(file.getCanonicalPath());
                    stringBuffer.append(File.pathSeparator);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.nativepath = stringBuffer.toString();
        }
        return this.nativepath;
    }

    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (uRL == null && this.gateway != null) {
            uRL = this.gateway.findResource(string);
        }
        return uRL;
    }

    public Enumeration findResources(String string) throws IOException {
        final Enumeration<URL> enumeration = super.findResources(string);
        final URL[] uRLArray = this.gateway != null ? this.gateway.findResources(string) : null;
        if (uRLArray == null || uRLArray.length == 0) {
            return enumeration;
        }
        return new Enumeration(){
            int current = 0;

            public boolean hasMoreElements() {
                if (this.current < uRLArray.length) {
                    return true;
                }
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                if (this.current < uRLArray.length) {
                    return uRLArray[this.current++];
                }
                return enumeration.nextElement();
            }
        };
    }

    public static interface Gateway {
        public Class loadClass(String var1);

        public URL findResource(String var1);

        public URL[] findResources(String var1) throws IOException;
    }
}

