/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.ejs.ras.Tr;
import com.ibm.ras.RASMessageLogger;
import com.ibm.ras.RASTraceLogger;
import com.ibm.websphere.ras.WsJrasMessageLogger;
import com.ibm.websphere.ras.WsJrasTraceLogger;
import java.util.Hashtable;

public class Manager {
    private static final Object svMgrLock = new Object();
    private static Manager svMgr = null;
    private static String svIbm = "IBM";
    private static String svWebSphere = "WebSphere";
    private Hashtable ivTraceLoggers = new Hashtable(20);
    private Hashtable ivMessageLoggers = new Hashtable(20);
    private long ivMsgLoggingMask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager getManager() {
        if (svMgr == null) {
            Object object = svMgrLock;
            synchronized (object) {
                if (svMgr == null) {
                    svMgr = new Manager(true);
                }
            }
        }
        return svMgr;
    }

    public Manager() {
        this(true);
    }

    private Manager(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASMessageLogger createRASMessageLogger(String string, String string2, String string3, String string4) throws IllegalArgumentException {
        this.checkParameters(string, string2, string3, string4);
        WsJrasMessageLogger wsJrasMessageLogger = null;
        boolean bl = false;
        Hashtable hashtable = this.ivMessageLoggers;
        synchronized (hashtable) {
            wsJrasMessageLogger = (WsJrasMessageLogger)this.ivMessageLoggers.get(string4);
            if (wsJrasMessageLogger == null) {
                wsJrasMessageLogger = new WsJrasMessageLogger(string, string2, string3, string4);
                this.ivMessageLoggers.put(string4, wsJrasMessageLogger);
                bl = true;
            }
        }
        if (!bl) {
            this.checkLoggerCoherency(wsJrasMessageLogger, string, string2, string3);
        }
        return wsJrasMessageLogger;
    }

    public RASMessageLogger createRASMessageLogger(String string, String string2) throws IllegalArgumentException {
        return this.createRASMessageLogger(svIbm, svWebSphere, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASTraceLogger createRASTraceLogger(String string, String string2, String string3, String string4) throws IllegalArgumentException {
        this.checkParameters(string, string2, string3, string4);
        WsJrasTraceLogger wsJrasTraceLogger = null;
        Hashtable hashtable = this.ivTraceLoggers;
        synchronized (hashtable) {
            wsJrasTraceLogger = (WsJrasTraceLogger)this.ivTraceLoggers.get(string4);
            if (wsJrasTraceLogger == null) {
                wsJrasTraceLogger = new WsJrasTraceLogger(string, string2, string3, string4);
                this.ivTraceLoggers.put(string4, wsJrasTraceLogger);
            }
        }
        return wsJrasTraceLogger;
    }

    public RASTraceLogger createRASTraceLogger(String string, String string2) throws IllegalArgumentException {
        return this.createRASTraceLogger(svIbm, svWebSphere, string, string2);
    }

    public void addLoggerToGroup(RASTraceLogger rASTraceLogger, String string) throws IllegalArgumentException {
        if (rASTraceLogger == null) {
            throw new IllegalArgumentException("Logger parameter is invalid");
        }
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Group parameter is invalid");
        }
        WsJrasTraceLogger wsJrasTraceLogger = null;
        try {
            wsJrasTraceLogger = (WsJrasTraceLogger)rASTraceLogger;
            Tr.register(wsJrasTraceLogger.ivTrName, string);
            wsJrasTraceLogger.traceStateChanged();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Specified RASITraceLogger is not a WebSphere TraceLogger");
        }
    }

    private void checkParameters(String string, String string2, String string3, String string4) throws IllegalArgumentException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Organization parameter is invalid");
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Product parameter is invalid");
        }
        if (string3 == null || string3.equals("")) {
            throw new IllegalArgumentException("Component parameter is invalid");
        }
        if (string4 == null || string4.equals("")) {
            throw new IllegalArgumentException("Name parameter is invalid");
        }
    }

    private void checkLoggerCoherency(RASMessageLogger rASMessageLogger, String string, String string2, String string3) throws IllegalArgumentException {
        if (!string.equals(rASMessageLogger.getOrganization())) {
            throw new IllegalArgumentException("Organization parameter mismatch");
        }
        if (!string2.equals(rASMessageLogger.getProduct())) {
            throw new IllegalArgumentException("Product parameter mismatch");
        }
        if (!string3.equals(rASMessageLogger.getComponent())) {
            throw new IllegalArgumentException("Component parameter mismatch");
        }
    }
}

