/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandMgrInitException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.ClientCommandMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;

public final class CommandMgrInitializer {
    private static TraceComponent tc = Tr.register(CommandMgrInitializer.class, "CommandMgrInitializer", "com.ibm.websphere.management.resources.cmdframework");
    private CommandMgr commandMgr;

    private CommandMgrInitializer() {
    }

    public static synchronized void initializeClientMode(AdminClient adminClient) throws CommandMgrInitException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeClientMode");
        }
        CommandMgr.initialized = true;
        if (adminClient == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminclient is null.  Just return");
            }
            return;
        }
        try {
            CommandUtility.getRemoteCmdMgrMbean(adminClient);
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.ClientCommandMgr");
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            ClientCommandMgr clientCommandMgr = null;
            clientCommandMgr = commandMgr == null || !clazz.isInstance(commandMgr) ? (ClientCommandMgr)clazz.newInstance() : (ClientCommandMgr)commandMgr;
            clientCommandMgr.setAdminClient(adminClient);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeClientMode");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgrInitializer", "52");
            Tr.error(tc, "commandframework failed to initialize in client mode", throwable);
            throw new CommandMgrInitException(throwable, "ClientMode");
        }
    }

    public static synchronized void initializeServerMode() {
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.ServerCommandMgr");
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            if (commandMgr == null || !clazz.isInstance(commandMgr)) {
                clazz.newInstance();
            }
            CommandMgr.initialized = true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgrInitializer", "52");
            Tr.error(tc, "commandframework failed to initialize in server mode", throwable);
        }
    }

    public static void initializeLocalMode() {
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.LocalCommandMgr");
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            if (commandMgr == null || !clazz.isInstance(commandMgr)) {
                clazz.newInstance();
            }
            CommandMgr.initialized = true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgrInitializer", "52");
            Tr.error(tc, "commandframework failed to initialize in local mode", throwable);
        }
    }
}

